/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.wmspedido;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.capsules.impl.CapsUsuario;
import com.touchcomp.basementor.constants.enums.wmsopcoes.EnumConstWmsOpcoesOp;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.impl.WmsSaldoEstoque;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Embalagem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.WmsOpcoes;
import com.touchcomp.basementor.model.vo.WmsPedido;
import com.touchcomp.basementor.model.vo.WmsPedidoItem;
import com.touchcomp.basementor.model.vo.WmsPedidoItemEmb;
import com.touchcomp.basementor.model.vo.WmsPedidoItemGrade;
import com.touchcomp.basementor.model.vo.WmsPedidoMapaSep;
import com.touchcomp.basementor.model.vo.WmsStatusPedido;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.components.wmspedido.CompWmsPedidoStatus;
import com.touchcomp.basementorservice.dao.impl.DaoWmsPedidoImpl;
import com.touchcomp.basementorservice.helpers.impl.opcoes.wmsopcoes.HelperWmsOpcoes;
import com.touchcomp.basementorservice.helpers.impl.wmspedido.HelperWmsPedido;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.centrocusto.ServiceCentroCustoImpl;
import com.touchcomp.basementorservice.service.impl.embalagem.ServiceEmbalagemImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.basementorservice.service.impl.wmssaldoestoque.ServiceWmsSaldoEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.wmsstatuspedido.ServiceWmsStatusPedidoImpl;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.wmspedido.web.DTOWmsPedido;
import com.touchcomp.touchvomodel.vo.wmspedido.web.DTOWmsPedidoMapaSep;
import com.touchcomp.touchvomodel.vo.wmspedido.web.DTOWmsPedidoRes;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceWmsPedidoImpl
extends ServiceGenericEntityImpl<WmsPedido, Long, DaoWmsPedidoImpl> {
    final ServiceGradeCorImpl serviceGradeCor;
    final ServiceProdutoImpl serviceProduto;
    final ServiceEmbalagemImpl serviceEmbalagemImpl;
    final ServiceWmsStatusPedidoImpl serviceWmsStatusPedidoImpl;
    final ServiceWmsSaldoEstoqueImpl serviceWmsSaldoEstoqueImpl;
    final HelperWmsPedido helperWmsPedido;
    final HelperWmsOpcoes helperWmsOpcoes;
    final CompWmsPedidoStatus compStatus;
    final ServiceUsuarioImpl serviceUsuario;
    final ServiceCentroCustoImpl serviceCentroCusto;

    @Autowired
    public ServiceWmsPedidoImpl(DaoWmsPedidoImpl dao, ServiceGradeCorImpl serviceGradeCor, ServiceProdutoImpl serviceProduto, ServiceEmbalagemImpl serviceEmbalagemImpl, HelperWmsPedido helperWmsPedido, HelperWmsOpcoes helperWmsOpcoes, ServiceWmsStatusPedidoImpl serviceWmsStatusPedidoImpl, ServiceWmsSaldoEstoqueImpl serviceWmsSaldoEstoqueImpl, CompWmsPedidoStatus compStatus, ServiceUsuarioImpl serviceUsuario, ServiceCentroCustoImpl serviceCentroCusto) {
        super(dao);
        this.serviceGradeCor = serviceGradeCor;
        this.serviceProduto = serviceProduto;
        this.serviceEmbalagemImpl = serviceEmbalagemImpl;
        this.helperWmsPedido = helperWmsPedido;
        this.serviceWmsSaldoEstoqueImpl = serviceWmsSaldoEstoqueImpl;
        this.helperWmsOpcoes = helperWmsOpcoes;
        this.serviceWmsStatusPedidoImpl = serviceWmsStatusPedidoImpl;
        this.compStatus = compStatus;
        this.serviceUsuario = serviceUsuario;
        this.serviceCentroCusto = serviceCentroCusto;
    }

    public DTOWmsPedido.DTOWmsPedidoItem getNovoItemGrade(Long idGrade, Empresa empresa) {
        GradeCor gradeCor = (GradeCor)this.serviceGradeCor.get(idGrade);
        if (gradeCor == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0064.001"));
        }
        LinkedList<DTOWmsPedido.DTOWmsPedidoItemGrade> ret = new LinkedList<DTOWmsPedido.DTOWmsPedidoItemGrade>();
        ret.add(this.convertGrade(gradeCor, empresa));
        DTOWmsPedido.DTOWmsPedidoItem item = new DTOWmsPedido.DTOWmsPedidoItem();
        item.setGrades(ret);
        item.setProduto(gradeCor.getProdutoGrade().getProduto().toString());
        item.setProdutoIdentificador(gradeCor.getProdutoGrade().getProduto().getIdentificador());
        item.setProdutoUnidadeMedida(gradeCor.getProdutoGrade().getProduto().getUnidadeMedida().getSigla());
        return item;
    }

    public DTOWmsPedido.DTOWmsPedidoItemGrade getNovaGrade(Long idGrade, Empresa empresa) {
        GradeCor grade = (GradeCor)this.serviceGradeCor.get(idGrade);
        if (grade == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0064.001"));
        }
        return this.convertGrade(grade, empresa);
    }

    DTOWmsPedido.DTOWmsPedidoItemGrade convertGrade(GradeCor grade, Empresa empresa) {
        DTOWmsPedido.DTOWmsPedidoItemGrade gr = new DTOWmsPedido.DTOWmsPedidoItemGrade();
        gr.setGradeCor(grade.toString());
        gr.setGradeCorIdentificador(grade.getIdentificador());
        return gr;
    }

    @Override
    public WmsPedido beforeSave(WmsPedido aux) {
        try {
            this.validQuantidadeItem(aux);
            aux.getItens().forEach(i -> {
                boolean gradeU = i.getGrades().size() == 1;
                for (WmsPedidoItemGrade grade : i.getGrades()) {
                    Double pesoUnit = i.getProduto().getPesoUnitario();
                    Double volumeUnit = i.getProduto().getVolume();
                    if (gradeU && !ToolMethods.isWithData((Number)grade.getQuantidade())) {
                        grade.setQuantidade(i.getQuantidadeTotal());
                    }
                    grade.setPesoTotal(Double.valueOf(pesoUnit * grade.getQuantidade()));
                    grade.setPesoTotal(Double.valueOf(volumeUnit * grade.getQuantidade()));
                    grade.setWmsPedidoItem(i);
                }
                if (i.getItensEmbalagens() == null) {
                    i.setItensEmbalagens(new LinkedList());
                }
                for (WmsPedidoItemEmb ie : i.getItensEmbalagens()) {
                    ie.setItemPedidoWms(i);
                }
                i.setWmsPedido(aux);
            });
            this.helperWmsPedido.build(aux).calcularTotais();
            if (this.getSharedData() != null) {
                this.helperWmsPedido.reservarPedido(aux, this.getSharedData().getWmsOpcoes(aux.getEmpresa()));
            }
            return aux;
        }
        catch (ExceptionInvalidState ex) {
            this.logError(ex);
            throw new ExceptionRuntimeBase(new ExcepCodeDetail(ex.getFormattedMessage()), (Throwable)ex);
        }
    }

    public WmsPedido get(Long idSolicitacao, Grupo grupoUsuarios) {
        return ((DaoWmsPedidoImpl)this.getDao()).get(idSolicitacao, grupoUsuarios);
    }

    public List<DTOWmsPedidoRes> getPedidos(Short filtrarData, Date dataInicial, Date dataFinal, Long idStatusPedido, Grupo grupoUsuarios, Empresa empresa) {
        List<WmsPedido> peds = ((DaoWmsPedidoImpl)this.getDao()).getPedidos(filtrarData, dataInicial, dataFinal, idStatusPedido, grupoUsuarios, empresa);
        List<DTOWmsPedidoRes> ret = this.buildToDTO(peds, DTOWmsPedidoRes.class);
        return ret;
    }

    public void atualizarSituacaoPedidos(List<DTOWmsPedidoRes> pedidos) {
        for (DTOWmsPedidoRes pedido : pedidos) {
            WmsPedido ped = (WmsPedido)this.get(pedido.getIdentificador());
            WmsStatusPedido stat = (WmsStatusPedido)this.serviceWmsStatusPedidoImpl.get(pedido.getStatusPedidoIdentificador());
            if (ped == null) continue;
            ped.setStatusPedido(stat);
            ped = this.saveOrUpdate(ped);
        }
    }

    public int atualizarSituacaoPedidos(WmsPedido pedido) {
        if (!TMethods.isWithData((Number)pedido.getIdentificador())) {
            return 0;
        }
        return ((DaoWmsPedidoImpl)this.getDao()).atualizarSituacaoPedidos(pedido);
    }

    public DTOWmsPedidoMapaSep getMapaSeparacao(Long idPedido) throws ExceptionInvalidState {
        WmsPedido ped = (WmsPedido)this.get(idPedido);
        if (ped == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1916.001", new Object[]{idPedido}));
        }
        WmsPedidoMapaSep mapa = this.getMapaSeparacao(ped);
        return this.buildToDTOGeneric(mapa, DTOWmsPedidoMapaSep.class);
    }

    public WmsPedidoMapaSep getMapaSeparacao(WmsPedido ped) throws ExceptionInvalidState {
        return this.helperWmsPedido.getMapaSeparacao(ped);
    }

    public DTOWmsPedido.DTOItemPedidoEmbalagemProduto getNovaEmbalagem(Long idEmbalagem, Long idProduto, Double quantidadeTotal) {
        Embalagem em = (Embalagem)this.serviceEmbalagemImpl.get(idEmbalagem);
        Produto prod = (Produto)this.serviceProduto.get(idProduto);
        DTOWmsPedido.DTOItemPedidoEmbalagemProduto r = new DTOWmsPedido.DTOItemPedidoEmbalagemProduto();
        r.setEmbalagemIdentificador(em.getIdentificador());
        r.setEmbalagemNome(em.getNome());
        r.setQtdePorEmbalagem(prod.getQtdVolume());
        if (prod.getQtdVolume() > 0.0) {
            r.setNrEmbalagem(Integer.valueOf(Double.valueOf(quantidadeTotal / prod.getQtdVolume()).intValue()));
        }
        return r;
    }

    public DTOWmsPedido getNovoPedido(CapsUsuario capsUsuarioLogado, CapsEmpresa capsEmpresaLogado) {
        WmsPedido entity = new WmsPedido();
        entity.setDataCadastro(new Date());
        entity.setDataSolicitacao(new Date());
        entity.setEmpresa(this.getSharedData().getEmpresa(capsEmpresaLogado.get()));
        entity.setUsuarioSolicitante((Usuario)this.serviceUsuario.get(capsUsuarioLogado.get()));
        WmsOpcoes op = this.getSharedData().getWmsOpcoes(capsEmpresaLogado.get());
        if (op != null) {
            entity.setReservarEstoque(op.getReservarEstoqueWmsPed());
            this.compStatus.setStatusPedido(op.getStatusPedidoSolicitacao(), entity);
        }
        return this.buildToDTO(entity, DTOWmsPedido.class);
    }

    public boolean isAllowedEdit(Long id) throws ExceptionObjNotFound {
        WmsPedido entity = (WmsPedido)this.getOrThrow(id);
        return entity.getWmsSeparacaoPedido() == null || !ToolMethods.isAffirmative((Number)entity.getWmsSeparacaoPedido().getConferenciaFinalizada());
    }

    private void validQuantidadeItem(WmsPedido aux) {
        WmsOpcoes wms;
        if (this.isNotNull(this.getSharedData()).booleanValue() && this.isNotNull(wms = this.getSharedData().getWmsOpcoes(aux.getEmpresa())).booleanValue() && !CompOpcoes.isAffirmative(this.helperWmsOpcoes.build(wms).getItens(), (EnumOpDinamicasInterface)EnumConstWmsOpcoesOp.NAO_PERMITE_PED_WMS_COM_QUANT_MAIOR_QUE_EST)) {
            StringBuilder sb = new StringBuilder();
            for (WmsPedidoItem item : aux.getItens()) {
                double saldoTotal = item.getGrades().stream().flatMap(grade -> this.serviceWmsSaldoEstoqueImpl.getSaldosEstoque(aux.getEmpresa(), grade.getGradeCor(), new Date()).stream()).mapToDouble(WmsSaldoEstoque::getSaldoAtual).sum();
                if (!(item.getQuantidadeTotal() > saldoTotal)) continue;
                sb.append(String.valueOf(item.getProduto())).append(". Quantidade Requisitada: ").append(ToolFormatter.formataNumero((Number)item.getQuantidadeTotal(), (int)2)).append(". Quantidade em estoque: ").append(ToolFormatter.formataNumero((Number)saldoTotal, (int)2)).append(" | ");
            }
            if (!sb.isEmpty()) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1915.003", new String[]{sb.toString()}));
            }
        }
    }

    public DTOWmsPedido atualizarCentroCustoItensPedido(Long idCentroCusto, DTOWmsPedido dto) throws ExceptionObjNotFound {
        CentroCusto centroCusto = (CentroCusto)this.serviceCentroCusto.getOrThrow(idCentroCusto);
        WmsPedido pedido = (WmsPedido)this.buildToEntity(dto);
        if (ServiceWmsPedidoImpl.isWithData(pedido.getItens())) {
            pedido.getItens().forEach(i -> i.setCentroCusto(centroCusto));
        }
        return this.buildToDTO(pedido, DTOWmsPedido.class);
    }
}

