/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.wmssaidaestoque;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.WmsEnderecoGradeCor;
import com.touchcomp.basementor.model.vo.WmsSaidaEstoque;
import com.touchcomp.basementor.model.vo.WmsSaidaEstoqueGrade;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoWmsSaidaEstoqueImpl;
import com.touchcomp.basementorservice.helpers.impl.wmssaidaprodutos.HelperWmsSaidaProdutos;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.wmsendereco.ServiceWmsEnderecoGradeCorImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.wmssaidaestoque.web.DTOWmsSaidaEstoque;
import java.util.Date;
import java.util.LinkedList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceWmsSaidaEstoqueImpl
extends ServiceGenericEntityImpl<WmsSaidaEstoque, Long, DaoWmsSaidaEstoqueImpl> {
    final ServiceGradeCorImpl serviceGradeCor;
    final ServiceProdutoImpl serviceProduto;
    final ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl;
    final ServiceWmsEnderecoGradeCorImpl serviceWmsEnderecoGradeCorImpl;
    final HelperWmsSaidaProdutos helperWmsSaidaProdutos;

    @Autowired
    public ServiceWmsSaidaEstoqueImpl(DaoWmsSaidaEstoqueImpl dao, ServiceGradeCorImpl serviceGradeCor, ServiceProdutoImpl serviceProduto, ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl, ServiceWmsEnderecoGradeCorImpl serviceWmsEnderecoGradeCorImpl, HelperWmsSaidaProdutos helperWmsSaidaProdutos) {
        super(dao);
        this.serviceGradeCor = serviceGradeCor;
        this.serviceProduto = serviceProduto;
        this.serviceLoteFabricacaoImpl = serviceLoteFabricacaoImpl;
        this.serviceWmsEnderecoGradeCorImpl = serviceWmsEnderecoGradeCorImpl;
        this.helperWmsSaidaProdutos = helperWmsSaidaProdutos;
    }

    public DTOWmsSaidaEstoque.DTOWmsSaidaEstoqueItem getNovoItemGrade(Long idGrade, Empresa empresa) {
        GradeCor gradeCor = (GradeCor)this.serviceGradeCor.get(idGrade);
        if (gradeCor == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0064.001"));
        }
        LinkedList<DTOWmsSaidaEstoque.DTOWmsSaidaEstoqueGrade> ret = new LinkedList<DTOWmsSaidaEstoque.DTOWmsSaidaEstoqueGrade>();
        ret.add(this.convertGrade(gradeCor, empresa));
        DTOWmsSaidaEstoque.DTOWmsSaidaEstoqueItem item = new DTOWmsSaidaEstoque.DTOWmsSaidaEstoqueItem();
        item.setGrades(ret);
        item.setProduto(gradeCor.getProdutoGrade().getProduto().toString());
        item.setProdutoIdentificador(gradeCor.getProdutoGrade().getProduto().getIdentificador());
        item.setProdutoUnidadeMedida(gradeCor.getProdutoGrade().getProduto().getUnidadeMedida().getSigla());
        if (ret.size() == 1) {
            item.setWmsEndereco(((DTOWmsSaidaEstoque.DTOWmsSaidaEstoqueGrade)item.getGrades().get(0)).getWmsEndereco());
            item.setWmsEnderecoIdentificador(((DTOWmsSaidaEstoque.DTOWmsSaidaEstoqueGrade)item.getGrades().get(0)).getWmsEnderecoIdentificador());
        }
        return item;
    }

    public DTOWmsSaidaEstoque.DTOWmsSaidaEstoqueGrade getNovaGrade(Long idGrade, Empresa empresa) {
        GradeCor grade = (GradeCor)this.serviceGradeCor.get(idGrade);
        if (grade == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0064.001"));
        }
        return this.convertGrade(grade, empresa);
    }

    DTOWmsSaidaEstoque.DTOWmsSaidaEstoqueGrade convertGrade(GradeCor grade, Empresa empresa) {
        LoteFabricacao lt;
        DTOWmsSaidaEstoque.DTOWmsSaidaEstoqueGrade gr = new DTOWmsSaidaEstoque.DTOWmsSaidaEstoqueGrade();
        gr.setDataSaida(Long.valueOf(new Date().getTime()));
        gr.setGradeCor(grade.toString());
        gr.setGradeCorIdentificador(grade.getIdentificador());
        if (this.isAffimative(grade.getProdutoGrade().getProduto().getLoteUnico()) && (lt = this.serviceLoteFabricacaoImpl.findLoteUnico(grade)) != null) {
            gr.setLoteFabricacao(lt.toString());
            gr.setLoteFabricacaoIdentificador(lt.getIdentificador());
            gr.setLoteFabricacaoDataFabricacao(lt.getDataFabricacao() != null ? Long.valueOf(lt.getDataFabricacao().getTime()) : null);
            gr.setLoteFabricacaoDataValidade(lt.getDataValidade() != null ? Long.valueOf(lt.getDataValidade().getTime()) : null);
        }
        gr.setEmpresa(empresa.toString());
        gr.setEmpresaIdentificador(empresa.getIdentificador());
        WmsEnderecoGradeCor end = this.serviceWmsEnderecoGradeCorImpl.getFirstByGradeCor(grade);
        if (end != null) {
            gr.setWmsEndereco(end.getWmsEndereco().toString());
            gr.setWmsEnderecoIdentificador(end.getWmsEndereco().getIdentificador());
        }
        return gr;
    }

    @Override
    public WmsSaidaEstoque beforeSave(WmsSaidaEstoque aux) {
        aux.getItens().forEach(i -> {
            boolean gradeU = i.getGrades().size() == 1;
            for (WmsSaidaEstoqueGrade grade : i.getGrades()) {
                grade.setWmsSaidaEstoqueItem(i);
                grade.setDataSaida(aux.getDataSaida());
                grade.setEmpresa(aux.getEmpresa());
                if (gradeU && !ToolMethods.isWithData((Number)grade.getQuantidade())) {
                    grade.setQuantidade(i.getQuantidadeTotal());
                }
                if (ToolMethods.isNull((Object)grade.getWmsEndereco()).booleanValue()) {
                    grade.setWmsEndereco(i.getWmsEndereco());
                }
                if (!gradeU || ToolMethods.isEquals((Object)grade.getWmsEndereco(), (Object)i.getWmsEndereco())) continue;
                i.setWmsEndereco(grade.getWmsEndereco());
            }
            i.setWmsSaidaEstoque(aux);
        });
        this.helperWmsSaidaProdutos.build(aux).calculaTotalizadores();
        return aux;
    }

    public boolean isAllowedEdit(Long id) throws ExceptionObjNotFound {
        WmsSaidaEstoque w = (WmsSaidaEstoque)this.getOrThrow(id);
        return w.getWmsSeparacaoPedido() == null;
    }

    @Override
    public boolean deleteOnly(WmsSaidaEstoque entity) {
        entity.getWmsSeparacaoPedido().setWmsSaidaEstoque(null);
        entity.getWmsSeparacaoPedido().setConferenciaFinalizada(Short.valueOf((short)0));
        entity.setWmsSeparacaoPedido(null);
        return super.deleteOnly(entity);
    }
}

