/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.wmssaldoestoque;

import com.touchcomp.basementor.constants.enums.saldoestoquewms.EnumConstSaldoWMSTipoSaldoQtde;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.wmssaldoestoque.ServiceWmsSaldoEstoqueImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.wmssaldoestoque.web.DTOWmsSaldoEstoque;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceWmsConsultaPosicaoEstoque
extends ServiceGenericImpl {
    @Autowired
    private ServiceProdutoImpl serviceProduto;
    @Autowired
    private ServiceWmsSaldoEstoqueImpl serviceWmsSaldoEstoque;

    public WebDTOResult consultaPosicaoEstoque(Long idEmpresaLogada, Long idProduto, Short exibirInfSomenteEmpresaLogada, Short exibirSaldoMaiorQueZero) throws ExceptionObjNotFound, ExceptionReflection {
        Optional<DTOWmsSaldoEstoque> opt;
        WebDTOResult result = new WebDTOResult();
        Produto produto = (Produto)this.serviceProduto.getOrThrow(idProduto);
        List<GradeCor> grades = this.serviceProduto.getGradeCoresAtivas(idProduto);
        EnumConstSaldoWMSTipoSaldoQtde tipoSaldoQtde = this.isAffimative(exibirSaldoMaiorQueZero) ? EnumConstSaldoWMSTipoSaldoQtde.TIPO_SALDO_QTQ_MAIOR_0 : EnumConstSaldoWMSTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO;
        Long idEmpresaInicial = ToolMethods.isAffirmative((Number)exibirInfSomenteEmpresaLogada) ? idEmpresaLogada : 0L;
        Long idEmpresaFinal = ToolMethods.isAffirmative((Number)exibirInfSomenteEmpresaLogada) ? idEmpresaLogada : 99999L;
        Optional<GradeCor> gradeCorInicial = grades.stream().min(Comparator.comparingLong(GradeCor::getIdentificador));
        Optional<GradeCor> gradeCorFinal = grades.stream().max(Comparator.comparingLong(GradeCor::getIdentificador));
        List<DTOWmsSaldoEstoque> saldos = this.serviceWmsSaldoEstoque.consultaPosicaoEstoque(idEmpresaInicial, idEmpresaFinal, produto.getIdentificador(), gradeCorInicial.isPresent() ? gradeCorInicial.get().getIdentificador() : 0L, gradeCorFinal.isPresent() ? gradeCorFinal.get().getIdentificador() : 0L, new Date(), tipoSaldoQtde, DTOWmsSaldoEstoque.class);
        if (ServiceWmsConsultaPosicaoEstoque.isWithData(saldos) && (opt = saldos.stream().filter(i -> this.isNotNull(i.getSaldoAtual()) != false && i.getSaldoAtual() < 0.0).findAny()).isPresent()) {
            result.addWarning("M.ERP.2034.001");
        }
        result.setResult(saldos);
        return result;
    }
}

