/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.wmssaldoestoque;

import com.touchcomp.basementor.constants.enums.opcoesestoque.EnumConstOpEstoqueEstrategia;
import com.touchcomp.basementor.constants.enums.saldoestoquewms.EnumConstSaldoWMSTipoDisp;
import com.touchcomp.basementor.constants.enums.saldoestoquewms.EnumConstSaldoWMSTipoSaldo;
import com.touchcomp.basementor.constants.enums.saldoestoquewms.EnumConstSaldoWMSTipoSaldoQtde;
import com.touchcomp.basementor.constants.enums.saldoestoquewms.EnumConstSaldoWMSTipoStatEnd;
import com.touchcomp.basementor.constants.enums.wmsopcoes.EnumConstOpEstMultiEstrategia;
import com.touchcomp.basementor.model.impl.WmsEstatisticasEndereco;
import com.touchcomp.basementor.model.impl.WmsSaldoEstoque;
import com.touchcomp.basementor.model.interfaces.InterfaceEstoqueDispMult;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.WmsEndereco;
import com.touchcomp.basementor.model.vo.WmsOpcoes;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.components.estoquepeps.CompEstoqueDisponibilidade;
import com.touchcomp.basementorservice.components.estoquepeps.CompEstoqueMultipleDisp;
import com.touchcomp.basementorservice.components.estoquepeps.multi.EstoqueDisponivelMult;
import com.touchcomp.basementorservice.components.estoquepeps.single.EstoqueDisponivel;
import com.touchcomp.basementorservice.dao.impl.DaoWmsSaldoEstoque;
import com.touchcomp.basementorservice.helpers.impl.opcoes.wmsopcoes.HelperWmsOpcoes;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.wmssaldoestoque.EstatisticasWmsParams;
import com.touchcomp.basementorservice.service.impl.wmssaldoestoque.SaldoEstoqueWmsParams;
import com.touchcomp.basementorservice.service.impl.wmssaldoestoque.disponibilidade.AnaliseRegraDisponibilidade;
import com.touchcomp.basementorservice.service.impl.wmssaldoestoque.disponibilidade.AnaliseRegraPeso;
import com.touchcomp.basementorservice.service.impl.wmssaldoestoque.disponibilidade.AnaliseRegraVolume;
import com.touchcomp.basementortools.tools.dtotransfer.ToolDTOBuilder;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceWmsSaldoEstoqueImpl
extends ServiceGenericImpl {
    @Autowired
    HelperWmsOpcoes helperWmsOpcoes;
    @Autowired
    DaoWmsSaldoEstoque dao;
    @Autowired
    CompEstoqueDisponibilidade compEstoqueDisponibilidade;
    @Autowired
    CompEstoqueMultipleDisp compDisponibilidadeEnderecos;

    public List<WmsSaldoEstoque> getSaldosEstoque(Empresa empresa, GradeCor gradeCor, Date dataConsulta) {
        Long idGradeCor = gradeCor != null ? gradeCor.getIdentificador() : null;
        Long idEmpresa = empresa != null ? empresa.getIdentificador() : null;
        return this.getSaldosEstoque(idEmpresa, idGradeCor, dataConsulta);
    }

    public List<WmsSaldoEstoque> getSaldosEstoque(Long idEmpresa, Long idGradeCor, Date dataConsulta) {
        SaldoEstoqueWmsParams params = new SaldoEstoqueWmsParams();
        params.setDataSaldo(dataConsulta);
        params.setGradeCor(idGradeCor).setEmpresa(idEmpresa).setTipoSaldo(EnumConstSaldoWMSTipoSaldo.TIPO_SALDO_LOTE_FABRICACAO).setTipoSaldoQtd(EnumConstSaldoWMSTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO);
        return this.dao.findSaldoWMS(params);
    }

    public <Z> List<Z> findLotesDisponiveis(Long idEmpresa, Long idGradeCor, Date dataConsulta, Class<Z> to) throws ExceptionReflection {
        SaldoEstoqueWmsParams params = new SaldoEstoqueWmsParams();
        params.setDataSaldo(dataConsulta);
        params.setGradeCor(idGradeCor).setEmpresa(idEmpresa).setTipoSaldo(EnumConstSaldoWMSTipoSaldo.TIPO_SALDO_LOTE_FABRICACAO).setTipoSaldoQtd(EnumConstSaldoWMSTipoSaldoQtde.TIPO_SALDO_QTQ_MAIOR_0);
        List<WmsSaldoEstoque> ret = this.dao.findSaldoWMS(params);
        return new ToolDTOBuilder(WmsSaldoEstoque.class, to).toDTO(ret);
    }

    public <Z> List<Z> getEnderecosDisponiveisLote(Long idEmpresa, Long idGradeCor, Long idLoteFabricacao, Date dataConsulta, Class<Z> to) throws ExceptionReflection {
        List<WmsSaldoEstoque> ret = this.findSaldoWMSBasico(dataConsulta, null, null, idGradeCor, idGradeCor, null, null, null, null, null, null, idEmpresa, idEmpresa, idLoteFabricacao, null, EnumConstSaldoWMSTipoSaldoQtde.TIPO_SALDO_QTQ_MAIOR_0, EnumConstSaldoWMSTipoSaldo.TIPO_SALDO_LOTE_FABRICACAO);
        return new ToolDTOBuilder(WmsSaldoEstoque.class, to).toDTO(ret);
    }

    public <Z> List<Z> consultaPosicaoEstoque(Long idEmpresaInicial, Long idEmpresaFinal, Long idProduto, Long idGradeInicial, Long idGradeFinal, Date dataConsulta, EnumConstSaldoWMSTipoSaldoQtde tipoSaldoQtde, Class<Z> to) throws ExceptionReflection {
        List<WmsSaldoEstoque> ret = this.findSaldoWMSBasico(dataConsulta, idProduto, idProduto, idGradeInicial, idGradeFinal, null, null, null, null, null, null, idEmpresaInicial, idEmpresaFinal, null, null, tipoSaldoQtde, EnumConstSaldoWMSTipoSaldo.TIPO_SALDO_GRADE);
        return new ToolDTOBuilder(WmsSaldoEstoque.class, to).toDTO(ret);
    }

    public List<WmsEstatisticasEndereco> findSaldoWMSEstatisticas(Date dataSaldo, Long idEmpresaIn, Long idEmpresaFim, String codEndWmsIn, String codEndWmsFim, EnumConstSaldoWMSTipoStatEnd tipoStat, EnumConstSaldoWMSTipoDisp tipodisp) {
        EstatisticasWmsParams params = new EstatisticasWmsParams();
        params.setEmpresa(idEmpresaIn, idEmpresaFim).setDataSaldo(dataSaldo).setEnderecoWms(codEndWmsIn, codEndWmsFim).setTipoStat(tipoStat).setTipodisp(tipodisp);
        return this.findSaldoWMSEstatisticas(params);
    }

    public List<WmsEstatisticasEndereco> findSaldoWMSEstatisticas(EstatisticasWmsParams params) {
        return this.dao.findSaldoWMSEstatisticas(params);
    }

    public <Z> List<Z> findSaldoWMSEstatisticas(Date dataSaldo, Long idEmpresaIn, Long idEmpresaFim, String codEndWmsIn, String codEndWmsFim, EnumConstSaldoWMSTipoStatEnd tipoStat, EnumConstSaldoWMSTipoDisp tipodisp, Class<Z> to) throws ExceptionReflection {
        List<WmsEstatisticasEndereco> aux = this.findSaldoWMSEstatisticas(dataSaldo, idEmpresaIn, idEmpresaFim, codEndWmsIn, codEndWmsFim, tipoStat, tipodisp);
        return new ToolDTOBuilder(WmsEstatisticasEndereco.class, to).toDTO(aux);
    }

    public List<EstoqueDisponivel<WmsSaldoEstoque>> getSaldosEstoque(Empresa empresa, GradeCor gradeCor, Date dataConsulta, Double quantidadeSolicitada, CompEstoqueDisponibilidade.OpcaoSaldoParcial opcaoSaldoParcial, CompEstoqueDisponibilidade.OpcaoTotalmenteSemSaldo opcaoSemSaldo) throws ExceptionInvalidState {
        Long idGradeCor = gradeCor != null ? gradeCor.getIdentificador() : null;
        Long idEmpresa = empresa != null ? empresa.getIdentificador() : null;
        SaldoEstoqueWmsParams params = new SaldoEstoqueWmsParams();
        params.setDataSaldo(dataConsulta).setEmpresa(idEmpresa, idEmpresa).setGradeCor(idGradeCor).setTipoSaldo(EnumConstSaldoWMSTipoSaldo.TIPO_SALDO_LOTE_FABRICACAO).setTipoSaldoQtd(EnumConstSaldoWMSTipoSaldoQtde.TIPO_SALDO_QTQ_MAIOR_0);
        List<WmsSaldoEstoque> ret = this.dao.findSaldoWMS(params);
        return this.compEstoqueDisponibilidade.getDisponibilidades(ret, quantidadeSolicitada, gradeCor, EnumConstOpEstoqueEstrategia.get((Object)this.getSharedData().getWmsOpcoes(idEmpresa).getEstrategiaBuscaSaldos()), opcaoSaldoParcial, opcaoSemSaldo);
    }

    public List<EstoqueDisponivel<WmsSaldoEstoque>> getSaldosEstoque(Empresa empresa, GradeCor gradeCor, Date dataConsulta, Double quantidadeSolicitada, CompEstoqueDisponibilidade.OpcaoSaldoParcial opcaoSaldoParcial, CompEstoqueDisponibilidade.OpcaoTotalmenteSemSaldo opcaoSemSaldo, EnumConstSaldoWMSTipoSaldoQtde tipoDisponibilidade) throws ExceptionInvalidState {
        Long idGradeCor = gradeCor != null ? gradeCor.getIdentificador() : null;
        Long idEmpresa = empresa != null ? empresa.getIdentificador() : null;
        SaldoEstoqueWmsParams params = new SaldoEstoqueWmsParams();
        params.setDataSaldo(dataConsulta).setEmpresa(idEmpresa, idEmpresa).setGradeCor(idGradeCor).setTipoSaldo(EnumConstSaldoWMSTipoSaldo.TIPO_SALDO_LOTE_FABRICACAO).setTipoSaldoQtd(tipoDisponibilidade);
        List<WmsSaldoEstoque> ret = this.dao.findSaldoWMS(params);
        return this.compEstoqueDisponibilidade.getDisponibilidades(ret, quantidadeSolicitada, gradeCor, EnumConstOpEstoqueEstrategia.get((Object)this.getSharedData().getWmsOpcoes(idEmpresa).getEstrategiaBuscaSaldos()), opcaoSaldoParcial, opcaoSemSaldo);
    }

    public List<WmsSaldoEstoque> findSaldoWMSBasico(Date dataSaldo, Long idProdutoIn, Long idProdutoFim, Long idGradeCorIn, Long idGradeCorFim, Long idEspecieIn, Long idEspecieFim, Long idSubespecieIn, Long idSubespecieFim, Long idFabricanteIn, Long idFabricanteFim, Long idEmpresaIn, Long idEmpresaFim, Long idLoteFabricacao, String codEndWms, EnumConstSaldoWMSTipoSaldoQtde tipoSaldoQtd, EnumConstSaldoWMSTipoSaldo tipoSaldo) {
        String codEndWmsIn = null;
        String codEndWmsFim = null;
        if (!this.isNull(codEndWms).booleanValue()) {
            codEndWmsIn = codEndWms;
            codEndWmsFim = ToolString.completaCaracter((String)ToolString.removeEndWhileExists((String)codEndWms, (char)'0'), (String)"9", (int)codEndWms.length(), (boolean)false);
        }
        SaldoEstoqueWmsParams params = new SaldoEstoqueWmsParams();
        params.setDataSaldo(dataSaldo).setProduto(idProdutoIn, idProdutoFim).setGradeCor(idGradeCorIn, idGradeCorFim).setEspecie(idEspecieIn, idEspecieFim).setSubEspecie(idSubespecieIn, idSubespecieFim).setFabricante(idFabricanteIn, idFabricanteFim).setEmpresa(idEmpresaIn, idEmpresaFim).setIdLoteFabricacao(idLoteFabricacao).setEnderecoWms(codEndWmsIn, codEndWmsFim).setTipoSaldo(tipoSaldo).setTipoSaldoQtd(tipoSaldoQtd);
        return this.dao.findSaldoWMS(params);
    }

    public <Z> Z findSaldoWMSBasico(Long idEmpresa, String codEnderecoWms, Long idGradeCor, Long idLoteFabricacao, Date dataConsulta, Class<Z> aClass) throws ExceptionReflection {
        List<WmsSaldoEstoque> ret = this.findSaldoWMSBasico(dataConsulta, null, null, idGradeCor, idGradeCor, null, null, null, null, null, null, idEmpresa, idEmpresa, idLoteFabricacao, codEnderecoWms, EnumConstSaldoWMSTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoWMSTipoSaldo.TIPO_SALDO_LOTE_FABRICACAO);
        WmsSaldoEstoque found = new WmsSaldoEstoque();
        if (!ret.isEmpty()) {
            found = ret.get(0);
        }
        return (Z)new ToolDTOBuilder(WmsSaldoEstoque.class, aClass).toDTO((Object)found);
    }

    public List<Map<String, Object>> findSaldoWMSMap(Date dataSaldo, Long idProdutoIn, Long idProdutoFim, Long idGradeCorIn, Long idGradeCorFim, Long idEspecieIn, Long idEspecieFim, Long idSubespecieIn, Long idSubespecieFim, Long idFabricanteIn, Long idFabricanteFim, Long idEmpresaIn, Long idEmpresaFim, Long idLoteFabricacao, String codEndWms, EnumConstSaldoWMSTipoSaldoQtde tipoSaldoQtd, EnumConstSaldoWMSTipoSaldo tipoSaldo) {
        String codEndWmsIn = null;
        String codEndWmsFim = null;
        if (!this.isNull(codEndWms).booleanValue()) {
            codEndWmsIn = codEndWms;
            codEndWmsFim = ToolString.completaCaracter((String)ToolString.removeEndWhileExists((String)codEndWms, (char)'0'), (String)"9", (int)codEndWms.length(), (boolean)false);
        }
        SaldoEstoqueWmsParams params = new SaldoEstoqueWmsParams();
        params.setDataSaldo(dataSaldo).setProduto(idProdutoIn, idProdutoFim).setGradeCor(idGradeCorIn, idGradeCorFim).setEspecie(idEspecieIn, idEspecieFim).setSubEspecie(idSubespecieIn, idSubespecieFim).setFabricante(idFabricanteIn, idFabricanteFim).setEmpresa(idEmpresaIn, idEmpresaFim).setIdLoteFabricacao(idLoteFabricacao).setEnderecoWms(codEndWmsIn, codEndWmsFim).setTipoSaldo(tipoSaldo).setTipoSaldoQtd(tipoSaldoQtd);
        return this.dao.findSaldoWMSMap(params);
    }

    public List<WmsSaldoEstoque> findSaldoWMS(SaldoEstoqueWmsParams params) {
        return this.dao.findSaldoWMS(params);
    }

    public List<Map<String, Object>> findSaldoWMSMap(SaldoEstoqueWmsParams params) {
        return this.dao.findSaldoWMSMap(params);
    }

    public List<EstoqueDisponivelMult<WmsEstatisticasEndereco>> getSugestaoEndereco(List<WmsEstatisticasEndereco> stats, Empresa emp, GradeCor gradeCor, Double quantidadeSolicitada) throws ExceptionInvalidState {
        WmsOpcoes opcoes = this.getSharedData().getWmsOpcoes(emp);
        final AnaliseRegraDisponibilidade rule = new AnaliseRegraDisponibilidade(gradeCor, opcoes, this.helperWmsOpcoes);
        LinkedList<1> disps = new LinkedList<1>();
        for (final WmsEstatisticasEndereco stat : stats) {
            AnaliseRegraPeso sPeso = new AnaliseRegraPeso(stat, gradeCor);
            AnaliseRegraVolume sVolume = new AnaliseRegraVolume(stat, gradeCor);
            final LinkedList<Object> sources = new LinkedList<Object>();
            sources.add(sPeso);
            sources.add(sVolume);
            disps.add(new InterfaceEstoqueDispMult(){

                public Object getSource() {
                    return stat;
                }

                public List getSourcesAvaliacao() {
                    return sources;
                }

                public Double getScore() {
                    return stat.getScoreEndereco();
                }

                public List getRulesAvaliacao() {
                    return Arrays.asList(rule);
                }
            });
        }
        return this.compDisponibilidadeEnderecos.getDisponibilidades(disps, quantidadeSolicitada, gradeCor, EnumConstOpEstMultiEstrategia.MENOR_SCORE, CompEstoqueMultipleDisp.OpcaoSaldoParcial.SETAR_QTD_ULT_ITEM, CompEstoqueMultipleDisp.OpcaoTotalmenteSemSaldo.ESTOQUE_SEM_DADOS, true);
    }

    public List<WmsEstatisticasEndereco> find(GradeCor gradeCor, WmsEndereco wmsEnderecoVinc, Empresa emp, Double quantidadeSolicitada) throws ExceptionInvalidState {
        EstatisticasWmsParams params = new EstatisticasWmsParams();
        params.setCarregarCaractVincEndereco(Boolean.TRUE);
        params.setDataSaldo(new Date());
        params.setEmpresa(emp.getIdentificador());
        params.setTipoStat(EnumConstSaldoWMSTipoStatEnd.AMBOS);
        params.setTipodisp(EnumConstSaldoWMSTipoDisp.DISPONIVEL);
        return this.dao.findSaldoWMSEstatisticas(params);
    }
}

