/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.wmssaldoestoque.disponibilidade;

import com.touchcomp.basementor.constants.enums.wmsopcoes.EnumConstTipoEnderecamentoWms;
import com.touchcomp.basementor.constants.enums.wmsopcoes.EnumConstWmsOpcoesOp;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.impl.WmsEstatisticasEndereco;
import com.touchcomp.basementor.model.interfaces.InterfaceEstoqueDispMult;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.WmsOpcoes;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.helpers.impl.opcoes.wmsopcoes.HelperWmsOpcoes;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class AnaliseRegraDisponibilidade
implements InterfaceEstoqueDispMult.Rule<WmsEstatisticasEndereco> {
    private final GradeCor gradeCor;
    private final WmsOpcoes opcoesWms;
    private final Short tipoEnderecamento;

    public AnaliseRegraDisponibilidade(GradeCor gradeCor, WmsOpcoes opcoesWms, HelperWmsOpcoes helperWmsOpcoes) {
        this.gradeCor = gradeCor;
        this.opcoesWms = opcoesWms;
        this.tipoEnderecamento = (Short)CompOpcoes.getOption(helperWmsOpcoes.build(opcoesWms).getItens(), (EnumOpDinamicasInterface)EnumConstWmsOpcoesOp.TIPO_ENDERECAMENTO, Short.class);
    }

    public boolean isValid(WmsEstatisticasEndereco source, Double aValue) {
        if (this.tipoEnderecamento == null || ToolMethods.isEqualsNumber((Number)this.tipoEnderecamento, (Number)EnumConstTipoEnderecamentoWms.ENDERECO_GENERICO.getValue()) && !source.getIdGradesCoresVinculadas().contains(this.gradeCor.getIdentificador())) {
            return true;
        }
        return ToolMethods.isEqualsNumber((Number)this.tipoEnderecamento, (Number)EnumConstTipoEnderecamentoWms.ENDERECO_POR_PRODUTO.getValue()) && source.getIdGradesCoresVinculadas().contains(this.gradeCor.getIdentificador());
    }
}

