/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.wmssaldoestoque.disponibilidade;

import com.touchcomp.basementor.model.impl.WmsEstatisticasEndereco;
import com.touchcomp.basementor.model.interfaces.InterfaceEstoqueDispMult;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class AnaliseRegraPeso
implements InterfaceEstoqueDispMult.Source {
    private final WmsEstatisticasEndereco stats;
    private final GradeCor gradeCor;

    public AnaliseRegraPeso(WmsEstatisticasEndereco stats, GradeCor gradeCor) {
        this.stats = stats;
        this.gradeCor = gradeCor;
    }

    public Double getQuantidadeAvaliacao() {
        double pesoUnit = this.gradeCor.getProdutoGrade().getProduto().getPesoUnitario() + this.gradeCor.getProdutoGrade().getProduto().getPesoEmbalagem();
        if (!ToolMethods.isWithData((Number)pesoUnit)) {
            return 0.0;
        }
        double qtd = this.getPesoDisponivel() / pesoUnit;
        if (ToolMethods.isAffirmative((Number)this.gradeCor.getProdutoGrade().getProduto().getQtdeNaoFracionada())) {
            qtd = (int)qtd;
        }
        return qtd;
    }

    public void setQuantidadeAvaliacao(Double qtdProdutos) {
        double peso = qtdProdutos * (this.gradeCor.getProdutoGrade().getProduto().getPesoUnitario() + this.gradeCor.getProdutoGrade().getProduto().getPesoEmbalagem());
        this.setPesoDisponivel(peso);
    }

    private void setPesoDisponivel(double peso) {
        this.stats.setPesoUtilizado(Double.valueOf(this.stats.getPesoUtilizado() + peso));
        this.stats.setPesoDisponivel(Double.valueOf(this.stats.getPesoDisponivel() - peso));
    }

    private double getPesoDisponivel() {
        return this.stats.getPesoDisponivel();
    }
}

