/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.wmssaldoestoque.disponibilidade;

import com.touchcomp.basementor.model.impl.WmsEstatisticasEndereco;
import com.touchcomp.basementor.model.interfaces.InterfaceEstoqueDispMult;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class AnaliseRegraVolume
implements InterfaceEstoqueDispMult.Source {
    private final WmsEstatisticasEndereco stats;
    private final GradeCor gradeCor;

    public AnaliseRegraVolume(WmsEstatisticasEndereco stats, GradeCor gradeCor) {
        this.stats = stats;
        this.gradeCor = gradeCor;
    }

    public Double getQuantidadeAvaliacao() {
        double volumeUnit = this.gradeCor.getProdutoGrade().getProduto().getVolume();
        if (!ToolMethods.isWithData((Number)volumeUnit)) {
            return 0.0;
        }
        double qtd = this.getVolumeDisponivel() / volumeUnit;
        if (ToolMethods.isAffirmative((Number)this.gradeCor.getProdutoGrade().getProduto().getQtdeNaoFracionada())) {
            qtd = (int)qtd;
        }
        return qtd;
    }

    public void setQuantidadeAvaliacao(Double qtdProdutos) {
        double volume = qtdProdutos * this.gradeCor.getProdutoGrade().getProduto().getVolume();
        this.setVolumeDisponivel(volume);
    }

    private void setVolumeDisponivel(double volume) {
        this.stats.setVolumeUtilizado(Double.valueOf(this.stats.getVolumeUtilizado() + volume));
        this.stats.setVolumeDisponivel(Double.valueOf(this.stats.getVolumeDisponivel() - volume));
    }

    private double getVolumeDisponivel() {
        return this.stats.getVolumeDisponivel();
    }
}

