/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.wmsseparacaopedido;

import com.touchcomp.basementor.constants.enums.opcoesestoque.EnumConstOpEstoqueEstrategia;
import com.touchcomp.basementor.model.interfaces.InterfaceEstoqueDisp;
import com.touchcomp.basementor.model.vo.WmsPedidoMapaSep;
import com.touchcomp.basementor.model.vo.WmsPedidoMapaSepItem;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedido;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedidoEmb;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedidoGrConf;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.CompTotaisItemGradesAdp;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.model.TotalItemGrade;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorservice.components.estoquepeps.CompEstoqueDisponibilidade;
import com.touchcomp.basementorservice.components.estoquepeps.single.EstoqueDisponivel;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class AuxWmsSeparacaoMapa {
    CompTotaisItemGradesAdp compTotalizadoresItem;
    CompEstoqueDisponibilidade compEstoqueDisponibilidade;

    public AuxWmsSeparacaoMapa(CompTotaisItemGradesAdp compTotalizadoresItem, CompEstoqueDisponibilidade compEstoqueDisponibilidade) {
        this.compTotalizadoresItem = compTotalizadoresItem;
        this.compEstoqueDisponibilidade = compEstoqueDisponibilidade;
    }

    void aplicarMapaSeparacao(WmsSeparacaoPedido sep) throws ExceptionInvalidState {
        if (sep.getEmbalagens() == null) {
            sep.setEmbalagens(new LinkedList());
        }
        for (WmsSeparacaoPedidoEmb emb : sep.getEmbalagens()) {
            if (emb.getGradesConf() == null) {
                emb.setGradesConf(new LinkedList());
            }
            for (WmsSeparacaoPedidoGrConf g : emb.getGradesConf()) {
                g.setLoteFabricacao(null);
                g.setWmsEndereco(null);
            }
        }
        List<InterfaceEstoqueDisp> disponibilidadesMapa = this.getDisponibilidades(sep.getMapaSeparacao());
        for (WmsSeparacaoPedidoEmb embalagem : sep.getEmbalagens()) {
            List grades = this.compTotalizadoresItem.getTotaisGrades(embalagem);
            for (TotalItemGrade grade : grades) {
                List est = this.compEstoqueDisponibilidade.getDisponibilidades(disponibilidadesMapa, grade.getQuantidadeTotal(), grade.getGradeCor(), EnumConstOpEstoqueEstrategia.PEPS_MAIS_ANTIGO, CompEstoqueDisponibilidade.OpcaoSaldoParcial.SETAR_QTD_ULT_ITEM, CompEstoqueDisponibilidade.OpcaoTotalmenteSemSaldo.LISTA_EST_VAZIA);
                embalagem.getGradesConf().clear();
                for (EstoqueDisponivel estoqueDisponivel : est) {
                    if (!ToolMethods.isWithData((Number)estoqueDisponivel.getQuantidade())) continue;
                    WmsSeparacaoPedidoGrConf w = new WmsSeparacaoPedidoGrConf();
                    w.setLoteFabricacao(((WmsPedidoMapaSepItem)estoqueDisponivel.getEstoque().getSource()).getLoteFabricacao());
                    w.setQuantidadeConf(estoqueDisponivel.getQuantidade());
                    w.setSeparacaoPedidoEmb(embalagem);
                    w.setWmsEndereco(((WmsPedidoMapaSepItem)estoqueDisponivel.getEstoque().getSource()).getWmsEndereco());
                    w.setGradeCor(grade.getGradeCor());
                    embalagem.getGradesConf().add(w);
                }
            }
        }
    }

    private List<InterfaceEstoqueDisp> getDisponibilidades(WmsPedidoMapaSep mapa) {
        LinkedList<InterfaceEstoqueDisp> ret = new LinkedList<InterfaceEstoqueDisp>();
        for (final WmsPedidoMapaSepItem item : mapa.getItensMapa()) {
            InterfaceEstoqueDisp estoque = new InterfaceEstoqueDisp(){

                public WmsPedidoMapaSepItem getSource() {
                    return item;
                }

                public Double getQuantidadeAvaliacao() {
                    return item.getQuantidade();
                }

                public void setQuantidadeAvaliacao(Double aValue) {
                    item.setQuantidade(aValue);
                }

                public Date getDataAvaliacao() {
                    return item.getLoteFabricacao() != null && item.getLoteFabricacao().getDataFabricacao() != null ? item.getLoteFabricacao().getDataFabricacao() : new Date();
                }
            };
            ret.add(estoque);
        }
        return ret;
    }
}

