/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.wmsseparacaopedido;

import com.touchcomp.basementor.constants.enums.opcoesrelatoriosbi.EnumConstOpcoesRelatoriosBI;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistema;
import com.touchcomp.basementor.constants.enums.wmsopcoes.EnumConstWmsOpcoesOp;
import com.touchcomp.basementor.constants.enums.wmspedido.EnumConstTipoMovimentacaoWMS;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.vo.Embalagem;
import com.touchcomp.basementor.model.vo.EmbalagemProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.ItemEmbalagemProduto;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.WmsEndereco;
import com.touchcomp.basementor.model.vo.WmsOpcoes;
import com.touchcomp.basementor.model.vo.WmsPedido;
import com.touchcomp.basementor.model.vo.WmsPedidoItem;
import com.touchcomp.basementor.model.vo.WmsPedidoMapaSepItem;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedido;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedidoEmb;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedidoGrConf;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.CompTotaisItemGradesAdp;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidDataRuntime;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacaoctbrequisicao.ExceptionParamCtbRequisicao;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.components.businessintelligence.CompBIDefaultParams;
import com.touchcomp.basementorservice.components.estoquepeps.CompEstoqueDisponibilidade;
import com.touchcomp.basementorservice.components.wmspedido.CompWmsPedidoStatus;
import com.touchcomp.basementorservice.dao.impl.DaoWmsSeparacaoPedidoImpl;
import com.touchcomp.basementorservice.helpers.impl.opcoes.wmsopcoes.HelperWmsOpcoes;
import com.touchcomp.basementorservice.helpers.impl.produto.HelperProduto;
import com.touchcomp.basementorservice.helpers.impl.requisicao.HelperRequisicao;
import com.touchcomp.basementorservice.helpers.impl.wmssaidaprodutos.HelperWmsSaidaProdutos;
import com.touchcomp.basementorservice.helpers.impl.wmsseparacaopedido.HelperWmsSeparacaoPedido;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataParamsBIUser;
import com.touchcomp.basementorservice.service.impl.embalagem.ServiceEmbalagemImpl;
import com.touchcomp.basementorservice.service.impl.embalagemproducao.ServiceEmbalagemProducaoImpl;
import com.touchcomp.basementorservice.service.impl.embalagemproduto.ServiceItemEmbalagemProdutoImpl;
import com.touchcomp.basementorservice.service.impl.expedicao.ServiceExpedicaoImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.opcoesrelatoriosbi.ServiceBuildOpcoesRelatoriosBI;
import com.touchcomp.basementorservice.service.impl.pedido.ServicePedidoImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.wmsendereco.ServiceWmsEnderecoImpl;
import com.touchcomp.basementorservice.service.impl.wmspedido.ServiceWmsPedidoImpl;
import com.touchcomp.basementorservice.service.impl.wmsseparacaopedido.AuxWmsSeparacaoMapa;
import com.touchcomp.basementortools.tools.clone.ToolClone;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import com.touchcomp.basementorvalidator.entities.ValidExtraData;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.ValidMessages;
import com.touchcomp.touchvomodel.vo.embalagemproduto.web.DTOEmbalagemProduto;
import com.touchcomp.touchvomodel.vo.wmsseparacaopedido.web.DTOResumoEmbalagensProduto;
import com.touchcomp.touchvomodel.vo.wmsseparacaopedido.web.DTOWmsSeparacaoPedPedido;
import com.touchcomp.touchvomodel.vo.wmsseparacaopedido.web.DTOWmsSeparacaoPedido;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class ServiceWmsSeparacaoPedidoImpl
extends ServiceGenericEntityImpl<WmsSeparacaoPedido, Long, DaoWmsSeparacaoPedidoImpl>
implements ValidExtraData<WmsSeparacaoPedido> {
    final ServiceWmsPedidoImpl serviceWmsPedido;
    final ServiceEmbalagemImpl serviceEmbalagemImpl;
    final ServiceBuildOpcoesRelatoriosBI serviceBuildOpcoesRelatoriosBI;
    final HelperProduto helperProduto;
    final HelperWmsSaidaProdutos helperWmsSaidaProdutos;
    final CompWmsPedidoStatus compStatusPedido;
    final HelperWmsSeparacaoPedido helperWmsSeparacaoPedido;
    final HelperWmsOpcoes helperWmsOpcoes;
    final ServiceEmbalagemProducaoImpl serviceEmbalagemProducaoImpl;
    final ServiceWmsEnderecoImpl serviceWmsEnderecoImpl;
    final CompTotaisItemGradesAdp compTotalizadoresItem;
    final CompEstoqueDisponibilidade compEstoqueDisponibilidade;
    final ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl;
    final ServiceGradeCorImpl serviceGradeCorImpl;
    final HelperRequisicao helperRequisicao;
    final ServicePedidoImpl servicePedidoImpl;
    final ServiceExpedicaoImpl serviceExpedicaoImpl;
    final ServiceItemEmbalagemProdutoImpl serviceItemEmbalagemProdutoImpl;
    final ServiceProdutoImpl serviceProdutoImpl;

    public ServiceWmsSeparacaoPedidoImpl(DaoWmsSeparacaoPedidoImpl dao, ServiceWmsPedidoImpl serviceWmsSolcitacaoProdutos, HelperProduto helperProduto, ServiceEmbalagemImpl serviceEmbalagemImpl, ServiceBuildOpcoesRelatoriosBI serviceBuildOpcoesRelatoriosBI, HelperWmsSaidaProdutos helperWmsSaidaProdutos, HelperWmsSeparacaoPedido helperWmsSeparacaoPedido, CompWmsPedidoStatus compStatusPedido, ServiceEmbalagemProducaoImpl serviceEmbalagemProducaoImpl, ServiceWmsEnderecoImpl serviceWmsEnderecoImpl, CompTotaisItemGradesAdp compTotalizadoresItem, CompEstoqueDisponibilidade compEstoqueDisponibilidade, HelperRequisicao helperRequisicao, ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl, ServiceGradeCorImpl serviceGradeCorImpl, ServicePedidoImpl servicePedidoImpl, ServiceExpedicaoImpl serviceExpedicaoImpl, HelperWmsOpcoes helperWmsOpcoes, ServiceItemEmbalagemProdutoImpl serviceItemEmbalagemProdutoImpl, ServiceProdutoImpl serviceProdutoImpl) {
        super(dao);
        this.serviceWmsPedido = serviceWmsSolcitacaoProdutos;
        this.helperProduto = helperProduto;
        this.serviceEmbalagemImpl = serviceEmbalagemImpl;
        this.serviceBuildOpcoesRelatoriosBI = serviceBuildOpcoesRelatoriosBI;
        this.helperWmsSaidaProdutos = helperWmsSaidaProdutos;
        this.compStatusPedido = compStatusPedido;
        this.helperWmsSeparacaoPedido = helperWmsSeparacaoPedido;
        this.serviceEmbalagemProducaoImpl = serviceEmbalagemProducaoImpl;
        this.serviceWmsEnderecoImpl = serviceWmsEnderecoImpl;
        this.compTotalizadoresItem = compTotalizadoresItem;
        this.compEstoqueDisponibilidade = compEstoqueDisponibilidade;
        this.serviceLoteFabricacaoImpl = serviceLoteFabricacaoImpl;
        this.serviceGradeCorImpl = serviceGradeCorImpl;
        this.helperRequisicao = helperRequisicao;
        this.servicePedidoImpl = servicePedidoImpl;
        this.serviceExpedicaoImpl = serviceExpedicaoImpl;
        this.helperWmsOpcoes = helperWmsOpcoes;
        this.serviceItemEmbalagemProdutoImpl = serviceItemEmbalagemProdutoImpl;
        this.serviceProdutoImpl = serviceProdutoImpl;
    }

    public DTOWmsSeparacaoPedPedido getPedidoWms(Long idSolicitacao, Grupo grupoUsuarios) throws ExceptionInvalidState {
        WmsPedido vo = this.serviceWmsPedido.get(idSolicitacao, grupoUsuarios);
        if (vo == null) {
            throw new ExceptionInvalidState("E.ERP.1916.001", new Object[]{idSolicitacao, grupoUsuarios});
        }
        DTOWmsSeparacaoPedPedido dto = this.serviceWmsPedido.buildToDTO(vo, DTOWmsSeparacaoPedPedido.class);
        dto.getItens().forEach(it -> {
            Optional<WmsPedidoItem> p = vo.getItens().stream().filter(i -> this.isEquals(i.getProduto().getIdentificador(), it.getProdutoIdentificador())).findFirst();
            if (p.isPresent()) {
                this.helperProduto.build(p.get().getProduto());
                List<String> codigosBarras = this.helperProduto.getCodigosBarrasAtivos();
                it.setCodigosBarras(codigosBarras);
            }
        });
        return dto;
    }

    public DTOWmsSeparacaoPedido.DTOWmsSeparacaoProdutosEmb getNovaEmbalagem(Long idEmbalagem) {
        Embalagem em = (Embalagem)this.serviceEmbalagemImpl.get(idEmbalagem);
        DTOWmsSeparacaoPedido.DTOWmsSeparacaoProdutosEmb dto = new DTOWmsSeparacaoPedido.DTOWmsSeparacaoProdutosEmb();
        dto.setCapacidadePeso(em.getCapacidadePeso());
        dto.setCapacidadeVolume(em.getCapacidadeVolume());
        dto.setEmbalagem(em.toString());
        dto.setEmbalagemIdentificador(em.getIdentificador());
        return dto;
    }

    @Override
    public WmsSeparacaoPedido beforeSave(WmsSeparacaoPedido aux) {
        for (WmsSeparacaoPedidoEmb emb : aux.getEmbalagens()) {
            for (WmsSeparacaoPedidoGrConf grade : emb.getGradesConf()) {
                grade.setSeparacaoPedidoEmb(emb);
            }
            emb.setSeparacaoPedido(aux);
        }
        if (aux.getMapaSeparacao() != null) {
            for (WmsPedidoMapaSepItem item : aux.getMapaSeparacao().getItensMapa()) {
                item.setWmsPedidoMapaSep(aux.getMapaSeparacao());
            }
        }
        this.helperWmsSeparacaoPedido.build(aux).calcularTotalizadores();
        if (aux.getPercConferido() >= 100.0) {
            aux.setConferidoIntegralmente(Short.valueOf((short)1));
        }
        if (!this.isAffimative(aux.getConferidoIntegralmente()) && this.isAffimative(aux.getConferenciaFinalizada())) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.ERP.1916.003"));
        }
        try {
            this.helperWmsSaidaProdutos.buildSaidaProdutos(aux, this.getSharedData().getWmsOpcoes(aux.getEmpresa()));
        }
        catch (ExceptionInvalidState ex) {
            this.logError(ex);
            throw new ExceptionRuntimeBase(ex.getFormattedMessage());
        }
        if (TMethods.isAffirmative((Number)aux.getConferenciaFinalizada())) {
            if (aux.getWmsSaidaEstoque() != null) {
                this.compStatusPedido.setStatusPedido(this.getSharedData().getWmsOpcoes(aux.getEmpresa()).getStatusPedidoSaida(), aux.getPedidoWms());
            } else {
                this.compStatusPedido.setStatusPedido(this.getSharedData().getWmsOpcoes(aux.getEmpresa()).getStatusPedidoConferencia(), aux.getPedidoWms());
            }
        } else {
            this.compStatusPedido.setStatusPedido(this.getSharedData().getWmsOpcoes(aux.getEmpresa()).getStatusPedidoSeparacao(), aux.getPedidoWms());
        }
        WmsPedido ped = (WmsPedido)this.serviceWmsPedido.get(aux.getPedidoWms().getIdentificador());
        if (ped.getExpedicao() != null) {
            if (ToolMethods.isAffirmative((Number)aux.getConferenciaFinalizada())) {
                this.servicePedidoImpl.atualizaSitPedido(ped.getExpedicao().getPedido(), this.getSharedData().getWmsOpcoes(aux.getEmpresa()).getSituacaoPedVendaWmsSep());
            }
            Short replicarEmb = (Short)CompOpcoes.getOption(this.helperWmsOpcoes.build(this.getSharedData().getWmsOpcoes(aux.getEmpresa())).getItens(), (EnumOpDinamicasInterface)EnumConstWmsOpcoesOp.REPLICAR_EMB_WMS_EXPEDICAO, Short.class);
            aux.getPedidoWms().setExpedicao(this.serviceExpedicaoImpl.atualizarExpedicao(ped.getExpedicao(), aux, replicarEmb));
        }
        this.helperWmsSeparacaoPedido.ordenarCaixas(aux.getEmbalagens());
        return aux;
    }

    @Override
    public WmsSeparacaoPedido afterSaveEntity(WmsSeparacaoPedido vo) {
        try {
            this.gerarRequisicao(vo);
        }
        catch (ExceptionParamCtbRequisicao ex) {
            this.logError(ex);
            throw new ExceptionRuntimeBase(ex.getFormattedMessage());
        }
        return vo;
    }

    private void gerarRequisicao(WmsSeparacaoPedido vo) throws ExceptionParamCtbRequisicao {
        if (!ToolMethods.isAffirmative((Number)vo.getConferenciaFinalizada())) {
            return;
        }
        if (this.isNull(vo.getDataSaida()).booleanValue()) {
            return;
        }
        if (this.isEquals(vo.getPedidoWms().getTipoMovimentacao(), EnumConstTipoMovimentacaoWMS.TIPO_MOVIMENTACAO_BAIXA_EFETIVA.getEnumId())) {
            Requisicao requisicao = this.helperRequisicao.gerarRequisicaoWmsSaidaEstoque(vo);
            vo.getWmsSaidaEstoque().setBaixaEfetiva(requisicao);
        }
    }

    public DTOWmsSeparacaoPedido getSeparacaoPedidoWms(Long idPedidoWms, Grupo grupoUsuarios) {
        WmsSeparacaoPedido sep = ((DaoWmsSeparacaoPedidoImpl)this.getDao()).getSeparacaoPedidosWms(idPedidoWms, grupoUsuarios);
        if (sep != null) {
            return this.buildToDTO(sep, DTOWmsSeparacaoPedido.class);
        }
        return null;
    }

    public File gerarEtiquetas(DTOWmsSeparacaoPedido separacao, Empresa empresa, Usuario usuario, Grupo grupoUsuarios) throws ExceptionBuildBI, ExceptionInvalidData, ExceptionIO {
        WmsSeparacaoPedido separacaoPedido = (WmsSeparacaoPedido)this.buildToEntity(separacao);
        return this.serviceBuildOpcoesRelatoriosBI.getBIFile(EnumConstOpcoesRelatoriosBI.BI_ETIQUETA_SEPARACAO_PED_WMS, CompBIDefaultParams.getDefParamsMap(empresa, usuario, grupoUsuarios, separacaoPedido), EnumConstTipoSistema.WEB);
    }

    public File gerarEtiquetas(DTOWmsSeparacaoPedido separacao, Empresa empresa, Usuario usuario, Grupo grupoUsuarios, Long idEtiqueta) throws ExceptionBuildBI, ExceptionInvalidData {
        WmsSeparacaoPedido separacaoPedido = (WmsSeparacaoPedido)this.buildToEntity(separacao);
        DataParamsBIUser data = new DataParamsBIUser();
        data.setItOutros("ID_ETIQUETA", idEtiqueta);
        return this.serviceBuildOpcoesRelatoriosBI.getBIFile(EnumConstOpcoesRelatoriosBI.BI_ETIQUETA_SEPARACAO_PED_WMS, CompBIDefaultParams.getDefParamsMap(empresa, usuario, grupoUsuarios, separacaoPedido), EnumConstTipoSistema.WEB, data);
    }

    public List<DTOWmsSeparacaoPedido.DTOWmsSeparacaoProdutosEmb> getSugestaoEmbalagens(Long idPedidoWms) throws ExceptionInvalidState {
        WmsPedido vo = (WmsPedido)this.serviceWmsPedido.get(idPedidoWms);
        if (vo == null) {
            throw new ExceptionInvalidState("E.ERP.1916.001", new Object[]{idPedidoWms});
        }
        WmsOpcoes opcoes = null;
        if (this.getSharedData() != null) {
            opcoes = this.getSharedData().getWmsOpcoes(vo.getEmpresa());
        }
        List<WmsSeparacaoPedidoEmb> ret = this.helperWmsSeparacaoPedido.getSugestaoEmbalagens(vo, opcoes);
        return this.buildToDTOGeneric(ret, DTOWmsSeparacaoPedido.DTOWmsSeparacaoProdutosEmb.class);
    }

    @Override
    public WmsSeparacaoPedido saveOrUpdateOnly(WmsSeparacaoPedido entity) {
        this.serviceWmsPedido.atualizarSituacaoPedidos(entity.getPedidoWms());
        return super.saveOrUpdateOnly(entity);
    }

    public DTOWmsSeparacaoPedido.DTOWmsSeparacaoProdutosEmb getEmbalagemPorCodigoBarras(String codigoBarras, Long idWmsEndereco, Long idWmsPedido, Empresa loggedEmpresa) throws ExceptionInvalidState, ExceptionObjNotFound {
        EmbalagemProducao emb = this.serviceEmbalagemProducaoImpl.getEmbalagemProducaoByCodigoBarras(codigoBarras, loggedEmpresa);
        WmsEndereco end = (WmsEndereco)this.serviceWmsEnderecoImpl.getOrThrow(idWmsEndereco);
        WmsPedido wms = (WmsPedido)this.serviceWmsPedido.getOrThrow(idWmsPedido);
        WmsSeparacaoPedidoEmb wemb = this.helperWmsSeparacaoPedido.getEmbalagem(emb, end, wms);
        return this.buildToDTOGeneric(wemb, DTOWmsSeparacaoPedido.DTOWmsSeparacaoProdutosEmb.class);
    }

    public DTOWmsSeparacaoPedido aplicarMapaSeparacao(DTOWmsSeparacaoPedido input) throws ExceptionInvalidState {
        WmsSeparacaoPedido sep = (WmsSeparacaoPedido)this.buildToEntity(input);
        if (sep.getMapaSeparacao() == null) {
            this.serviceWmsPedido.getMapaSeparacao(sep.getPedidoWms());
        }
        new AuxWmsSeparacaoMapa(this.compTotalizadoresItem, this.compEstoqueDisponibilidade).aplicarMapaSeparacao(sep);
        return this.buildToDTO(sep, DTOWmsSeparacaoPedido.class);
    }

    public boolean isAllowedEdit(Long id) throws ExceptionObjNotFound {
        WmsSeparacaoPedido vo = (WmsSeparacaoPedido)this.getOrThrow(id);
        return vo.getWmsSaidaEstoque() == null || !ToolMethods.isAffirmative((Number)vo.getConferenciaFinalizada());
    }

    public DTOWmsSeparacaoPedido substituirProdutoWms(Long idGradeCor, Long idEnderecoWms, Long idLote, Long idEmbalagem, Long idEnderecoWmsNovo, Long idLoteNovo, Long idEmbalagemNovo, Double qtdProdutos, Double qtdEmbalagens, DTOWmsSeparacaoPedido dto) throws ExceptionInvalidData, ExceptionInvalidData, ExceptionObjNotFound {
        if (!ToolMethods.isWithData((Number)qtdEmbalagens)) {
            throw new ExceptionInvalidData("E.ERP.1912.003", new Object[]{qtdEmbalagens});
        }
        WmsSeparacaoPedido separacao = (WmsSeparacaoPedido)this.buildToEntity(dto);
        double qtdProdutosNovos = qtdProdutos;
        for (WmsSeparacaoPedidoEmb emb : separacao.getEmbalagens()) {
            for (WmsSeparacaoPedidoGrConf grConf : emb.getGradesConf()) {
                Long idGradeSep = grConf.getGradeCor() != null ? grConf.getGradeCor().getIdentificador() : 0L;
                Long idLoteSep = grConf.getLoteFabricacao() != null ? grConf.getLoteFabricacao().getIdentificador() : 0L;
                Long idEnderecoSep = grConf.getWmsEndereco() != null ? grConf.getWmsEndereco().getIdentificador() : 0L;
                Long idEmbalagemSep = emb.getEmbalagem() != null ? emb.getEmbalagem().getIdentificador() : 0L;
                if (!ToolMethods.isEqualsNumber((Number)idGradeCor, (Number)idGradeSep) || !ToolMethods.isEqualsNumber((Number)idEnderecoWms, (Number)idEnderecoSep) || !ToolMethods.isEqualsNumber((Number)idEmbalagem, (Number)idEmbalagemSep) || !ToolMethods.isEqualsNumber((Number)idLote, (Number)idLoteSep)) continue;
                if (grConf.getQuantidadeConf() < qtdProdutos) {
                    qtdProdutos = qtdProdutos - grConf.getQuantidadeConf();
                    grConf.setQuantidadeConf(Double.valueOf(0.0));
                    continue;
                }
                grConf.setQuantidadeConf(Double.valueOf(grConf.getQuantidadeConf() - qtdProdutos));
                qtdProdutos = 0.0;
            }
        }
        if (qtdProdutos > 0.0) {
            throw new ExceptionInvalidData("E.ERP.1912.001", new Object[]{qtdProdutos});
        }
        for (WmsSeparacaoPedidoEmb emb : separacao.getEmbalagens()) {
            emb.getGradesConf().removeIf(i -> ToolFormatter.arrredondarNumero((Double)i.getQuantidadeConf(), (int)6) <= 0.0);
        }
        separacao.getEmbalagens().removeIf(i -> i.getGradesConf().isEmpty());
        int i2 = 0;
        while ((double)i2 < qtdEmbalagens) {
            WmsSeparacaoPedidoEmb w = new WmsSeparacaoPedidoEmb();
            w.setEmbalagem((Embalagem)this.serviceEmbalagemImpl.getOrThrow(idEmbalagemNovo));
            w.setCapacidadePeso(w.getEmbalagem().getCapacidadePeso());
            w.setCapacidadeVolume(w.getEmbalagem().getCapacidadeVolume());
            WmsSeparacaoPedidoGrConf gf = new WmsSeparacaoPedidoGrConf();
            gf.setGradeCor((GradeCor)this.serviceGradeCorImpl.getOrThrow(idGradeCor));
            gf.setLoteFabricacao((LoteFabricacao)this.serviceLoteFabricacaoImpl.getOrThrow(idLoteNovo));
            gf.setWmsEndereco((WmsEndereco)this.serviceWmsEnderecoImpl.getOrThrow(idEnderecoWmsNovo));
            gf.setQuantidadeConf(Double.valueOf(qtdProdutosNovos / qtdEmbalagens));
            w.setQuantidadeItens(Double.valueOf(w.getQuantidadeItens() + gf.getQuantidadeConf()));
            w.getGradesConf().add(gf);
            separacao.getEmbalagens().add(w);
            ++i2;
        }
        long i22 = 1L;
        for (WmsSeparacaoPedidoEmb emb : separacao.getEmbalagens()) {
            emb.setNumeroCaixa(Long.valueOf(i22));
            ++i22;
        }
        this.helperWmsSeparacaoPedido.ordenarCaixas(separacao.getEmbalagens());
        this.helperWmsSeparacaoPedido.build(separacao).calcularTotalizadores();
        return this.buildToDTO(separacao, DTOWmsSeparacaoPedido.class);
    }

    public DTOResumoEmbalagensProduto resumirEmbalagens(List<DTOWmsSeparacaoPedido.DTOWmsSeparacaoProdutosEmb> input) throws ExceptionReflection {
        this.helperWmsSeparacaoPedido.setNumeroCaixasSeNecessario(input);
        LinkedList<DTOResumoEmbalagensProduto.DTOProduto> ret = new LinkedList<DTOResumoEmbalagensProduto.DTOProduto>();
        for (DTOWmsSeparacaoPedido.DTOWmsSeparacaoProdutosEmb emb : input) {
            for (DTOWmsSeparacaoPedido.DTOWmsSeparacaoProdutosGrConf grConf : emb.getGradesConf()) {
                DTOResumoEmbalagensProduto.DTOProduto temp;
                Long idGrade = grConf.getGradeCorIdentificador();
                Long idEndereco = ToolNumber.asZeroIfNullSLong((Number)grConf.getWmsEnderecoIdentificador());
                Long idLote = ToolNumber.asZeroIfNullSLong((Number)grConf.getLoteFabricacaoIdentificador());
                Optional<DTOResumoEmbalagensProduto.DTOProduto> found = ret.stream().filter(i -> ToolMethods.isEqualsNumber((Number)idLote, (Number)ToolNumber.asZeroIfNullSLong((Number)i.getLoteFabricacaoIdentificador())) && ToolMethods.isEqualsNumber((Number)idEndereco, (Number)ToolNumber.asZeroIfNullSLong((Number)i.getWmsEnderecoIdentificador())) && ToolMethods.isEqualsNumber((Number)idGrade, (Number)i.getGradeCorIdentificador())).findFirst();
                if (found.isPresent()) {
                    temp = found.get();
                } else {
                    temp = new DTOResumoEmbalagensProduto.DTOProduto();
                    ToolClone.merge((Object)grConf, (Object)temp);
                    temp.setQuantidadeTotal(Double.valueOf(0.0));
                    ret.add(temp);
                }
                DTOResumoEmbalagensProduto.DTOProdutoGradeConf item = new DTOResumoEmbalagensProduto.DTOProdutoGradeConf();
                item.setGradeConf(grConf);
                item.setNumeroCaixa(emb.getNumeroCaixa());
                item.setEmbalagem(emb.getEmbalagem());
                temp.getItensConf().add(item);
                temp.setQuantidadeTotal(Double.valueOf(temp.getQuantidadeTotal() + grConf.getQuantidadeConf()));
            }
        }
        DTOResumoEmbalagensProduto a = new DTOResumoEmbalagensProduto();
        a.setEmbalagens(input);
        a.setProdutos(ret);
        return a;
    }

    public DTOResumoEmbalagensProduto aplicarEmbalagensReumo(DTOResumoEmbalagensProduto input) throws ExceptionReflection {
        for (DTOWmsSeparacaoPedido.DTOWmsSeparacaoProdutosEmb emb : input.getEmbalagens()) {
            emb.getGradesConf().clear();
        }
        for (DTOResumoEmbalagensProduto.DTOProduto produto : input.getProdutos()) {
            for (DTOResumoEmbalagensProduto.DTOProdutoGradeConf gr : produto.getItensConf()) {
                gr.getGradeConf().setLoteFabricacaoIdentificador(produto.getLoteFabricacaoIdentificador());
                gr.getGradeConf().setLoteFabricacao(produto.getLoteFabricacao());
                gr.getGradeConf().setWmsEndereco(produto.getWmsEndereco());
                gr.getGradeConf().setWmsEnderecoCodigo(produto.getWmsEnderecoCodigo());
                gr.getGradeConf().setWmsEnderecoIdentificador(produto.getWmsEnderecoIdentificador());
                Optional<DTOWmsSeparacaoPedido.DTOWmsSeparacaoProdutosEmb> found = input.getEmbalagens().stream().filter(i -> ToolMethods.isEqualsNumber((Number)i.getNumeroCaixa(), (Number)gr.getNumeroCaixa())).findFirst();
                if (!found.isPresent()) continue;
                found.get().getGradesConf().add(gr.getGradeConf());
            }
        }
        return this.resumirEmbalagens(input.getEmbalagens());
    }

    public List<DTOEmbalagemProduto.DTOItemEmbalagemProduto> getEmbalagensProduto(Long idProduto, Long idEmpresa) throws ExceptionObjNotFound {
        Produto prod = (Produto)this.serviceProdutoImpl.getOrThrow(idProduto);
        Short validarEmbProd = (Short)CompOpcoes.getOption(this.helperWmsOpcoes.build(this.getSharedData().getWmsOpcoes(idEmpresa)).getItens(), (EnumOpDinamicasInterface)EnumConstWmsOpcoesOp.VALIDAR_EMBALAGENS_PRODUTO, Short.class);
        if (this.isAffimative(validarEmbProd)) {
            return this.serviceItemEmbalagemProdutoImpl.getEmbalagensProduto(idProduto);
        }
        List<Embalagem> embalagens = this.serviceEmbalagemImpl.getEmbalagensAtivas();
        LinkedList<DTOEmbalagemProduto.DTOItemEmbalagemProduto> ret = new LinkedList<DTOEmbalagemProduto.DTOItemEmbalagemProduto>();
        for (Embalagem emb : embalagens) {
            DTOEmbalagemProduto.DTOItemEmbalagemProduto n = new DTOEmbalagemProduto.DTOItemEmbalagemProduto();
            n.setEmbalagem(emb.getNome());
            n.setEmbalagemIdentificador(emb.getIdentificador());
            n.setQuantidade(this.helperProduto.build(prod).getQuantidadeMax(prod, emb.getCapacidadePeso(), emb.getCapacidadeVolume()));
            ret.add(n);
        }
        return ret;
    }

    public void valid(ValidGenericEntitiesImpl validador, WmsSeparacaoPedido vo) {
        Short validarEmbProd = (Short)CompOpcoes.getOption(this.helperWmsOpcoes.build(this.getSharedData().getWmsOpcoes(vo.getEmpresa())).getItens(), (EnumOpDinamicasInterface)EnumConstWmsOpcoesOp.VALIDAR_EMBALAGENS_PRODUTO, Short.class);
        if (!this.isAffimative(validarEmbProd)) {
            return;
        }
        HashMap<Produto, HashSet<Embalagem>> idEmbProd = new HashMap<Produto, HashSet<Embalagem>>();
        for (WmsSeparacaoPedidoEmb emb : vo.getEmbalagens()) {
            for (WmsSeparacaoPedidoGrConf gr : emb.getGradesConf()) {
                HashSet<Embalagem> embs = (HashSet<Embalagem>)idEmbProd.get(gr.getGradeCor().getProdutoGrade().getProduto());
                if (embs == null) {
                    embs = new HashSet<Embalagem>();
                    idEmbProd.put(gr.getGradeCor().getProdutoGrade().getProduto(), embs);
                }
                embs.add(emb.getEmbalagem());
            }
        }
        Set prods = idEmbProd.keySet();
        for (Produto prod : prods) {
            HashSet embs = (HashSet)idEmbProd.get(prod);
            for (Embalagem emb : embs) {
                ItemEmbalagemProduto item = this.serviceItemEmbalagemProdutoImpl.getEmbalagemProduto(emb, prod);
                if (item != null) continue;
                validador.addError(new ValidMessages.Code("V.ERP.1916.033", new Object[]{prod, emb}), (Object)vo);
            }
        }
    }
}

