/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.wmstransfestoque;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.WmsEnderecoGradeCor;
import com.touchcomp.basementor.model.vo.WmsTransfEstoque;
import com.touchcomp.basementor.model.vo.WmsTransfEstoqueGrade;
import com.touchcomp.basementor.model.vo.WmsTransfEstoqueItem;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoWmsTransfEstoqueImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.wmsendereco.ServiceWmsEnderecoGradeCorImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.wmstransfestoque.web.DTOWmsTransfEstoque;
import java.util.Date;
import java.util.LinkedList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceWmsTransfEstoqueImpl
extends ServiceGenericEntityImpl<WmsTransfEstoque, Long, DaoWmsTransfEstoqueImpl> {
    final ServiceGradeCorImpl serviceGradeCor;
    final ServiceProdutoImpl serviceProduto;
    final ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl;
    final ServiceWmsEnderecoGradeCorImpl serviceWmsEnderecoGradeCorImpl;

    @Autowired
    public ServiceWmsTransfEstoqueImpl(DaoWmsTransfEstoqueImpl dao, ServiceGradeCorImpl serviceGradeCor, ServiceProdutoImpl serviceProduto, ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl, ServiceWmsEnderecoGradeCorImpl serviceWmsEnderecoGradeCorImpl) {
        super(dao);
        this.serviceGradeCor = serviceGradeCor;
        this.serviceProduto = serviceProduto;
        this.serviceLoteFabricacaoImpl = serviceLoteFabricacaoImpl;
        this.serviceWmsEnderecoGradeCorImpl = serviceWmsEnderecoGradeCorImpl;
    }

    public DTOWmsTransfEstoque.DTOWmsTransfEstoqueItem getNovoItemGrade(Long idGrade, Empresa empresa) {
        GradeCor gradeCor = (GradeCor)this.serviceGradeCor.get(idGrade);
        if (gradeCor == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0064.001"));
        }
        LinkedList<DTOWmsTransfEstoque.DTOWmsTransfEstoqueGrade> ret = new LinkedList<DTOWmsTransfEstoque.DTOWmsTransfEstoqueGrade>();
        ret.add(this.convertGrade(gradeCor, empresa));
        DTOWmsTransfEstoque.DTOWmsTransfEstoqueItem item = new DTOWmsTransfEstoque.DTOWmsTransfEstoqueItem();
        item.setGrades(ret);
        item.setProduto(gradeCor.getProdutoGrade().getProduto().toString());
        item.setProdutoIdentificador(gradeCor.getProdutoGrade().getProduto().getIdentificador());
        item.setProdutoUnidadeMedida(gradeCor.getProdutoGrade().getProduto().getUnidadeMedida().getSigla());
        if (ret.size() == 1) {
            item.setWmsEnderecoOrigem(((DTOWmsTransfEstoque.DTOWmsTransfEstoqueGrade)item.getGrades().get(0)).getWmsEnderecoOrigem());
            item.setWmsEnderecoOrigemIdentificador(((DTOWmsTransfEstoque.DTOWmsTransfEstoqueGrade)item.getGrades().get(0)).getWmsEnderecoOrigemIdentificador());
            item.setWmsEnderecoDestino(((DTOWmsTransfEstoque.DTOWmsTransfEstoqueGrade)item.getGrades().get(0)).getWmsEnderecoDestino());
            item.setWmsEnderecoDestinoIdentificador(((DTOWmsTransfEstoque.DTOWmsTransfEstoqueGrade)item.getGrades().get(0)).getWmsEnderecoDestinoIdentificador());
        }
        return item;
    }

    public DTOWmsTransfEstoque.DTOWmsTransfEstoqueGrade getNovaGrade(Long idGrade, Empresa empresa) {
        GradeCor grade = (GradeCor)this.serviceGradeCor.get(idGrade);
        if (grade == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0064.001"));
        }
        return this.convertGrade(grade, empresa);
    }

    DTOWmsTransfEstoque.DTOWmsTransfEstoqueGrade convertGrade(GradeCor grade, Empresa empresa) {
        LoteFabricacao lt;
        DTOWmsTransfEstoque.DTOWmsTransfEstoqueGrade gr = new DTOWmsTransfEstoque.DTOWmsTransfEstoqueGrade();
        gr.setDataTransferencia(Long.valueOf(new Date().getTime()));
        gr.setGradeCor(grade.toString());
        gr.setGradeCorIdentificador(grade.getIdentificador());
        if (this.isAffimative(grade.getProdutoGrade().getProduto().getLoteUnico()) && (lt = this.serviceLoteFabricacaoImpl.findLoteUnico(grade)) != null) {
            gr.setLoteFabricacao(lt.toString());
            gr.setLoteFabricacaoIdentificador(lt.getIdentificador());
            gr.setLoteFabricacaoDataFabricacao(lt.getDataFabricacao() != null ? Long.valueOf(lt.getDataFabricacao().getTime()) : null);
            gr.setLoteFabricacaoDataValidade(lt.getDataValidade() != null ? Long.valueOf(lt.getDataValidade().getTime()) : null);
        }
        gr.setEmpresa(empresa.toString());
        gr.setEmpresaIdentificador(empresa.getIdentificador());
        WmsEnderecoGradeCor end = this.serviceWmsEnderecoGradeCorImpl.getFirstByGradeCor(grade);
        if (end != null) {
            gr.setWmsEnderecoOrigem(end.getWmsEndereco().toString());
            gr.setWmsEnderecoOrigemIdentificador(end.getWmsEndereco().getIdentificador());
        }
        return gr;
    }

    @Override
    public WmsTransfEstoque beforeSave(WmsTransfEstoque aux) {
        double qtdTotalTransf = 0.0;
        double qtdPesoTransf = 0.0;
        double qtdVolumeTransf = 0.0;
        for (WmsTransfEstoqueItem item : aux.getItens()) {
            double qtdTotal = 0.0;
            double pesoTotal = 0.0;
            double volumeTotal = 0.0;
            boolean gradeU = item.getGrades().size() == 1;
            for (WmsTransfEstoqueGrade grade : item.getGrades()) {
                grade.setWmsTransfEstoqueItem(item);
                grade.setDataTransferencia(aux.getDataTransferencia());
                grade.setEmpresa(aux.getEmpresa());
                if (gradeU && !ToolMethods.isWithData((Number)grade.getQuantidade())) {
                    grade.setQuantidade(item.getQuantidadeTotal());
                }
                if (ToolMethods.isNull((Object)grade.getWmsEnderecoOrigem()).booleanValue()) {
                    grade.setWmsEnderecoOrigem(item.getWmsEnderecoOrigem());
                }
                if (ToolMethods.isNull((Object)grade.getWmsEnderecoDestino()).booleanValue()) {
                    grade.setWmsEnderecoDestino(item.getWmsEnderecoDestino());
                }
                if (gradeU && !ToolMethods.isEquals((Object)grade.getWmsEnderecoOrigem(), (Object)item.getWmsEnderecoOrigem())) {
                    item.setWmsEnderecoOrigem(grade.getWmsEnderecoOrigem());
                }
                if (gradeU && !ToolMethods.isEquals((Object)grade.getWmsEnderecoDestino(), (Object)item.getWmsEnderecoDestino())) {
                    item.setWmsEnderecoDestino(grade.getWmsEnderecoDestino());
                }
                grade.setPesoTotal(Double.valueOf(grade.getQuantidade() * item.getProduto().getPesoUnitario()));
                grade.setVolumeTotal(Double.valueOf(grade.getQuantidade() * item.getProduto().getVolume()));
                qtdTotal += grade.getQuantidade().doubleValue();
                pesoTotal += grade.getPesoTotal().doubleValue();
                volumeTotal += grade.getVolumeTotal().doubleValue();
                qtdTotalTransf += grade.getQuantidade().doubleValue();
                qtdPesoTransf += grade.getQuantidade() * item.getProduto().getPesoUnitario();
                qtdVolumeTransf += grade.getQuantidade() * item.getProduto().getVolume();
            }
            item.setQuantidadeTotal(Double.valueOf(qtdTotal));
            item.setWmsTransfEstoque(aux);
            item.setVolumeTotal(Double.valueOf(volumeTotal));
            item.setPesoTotal(Double.valueOf(pesoTotal));
        }
        aux.setQuantidadeTotal(Double.valueOf(qtdTotalTransf));
        aux.setPesoTotal(Double.valueOf(qtdPesoTransf));
        aux.setVolumeTotal(Double.valueOf(qtdVolumeTransf));
        return aux;
    }
}

