/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.workspacebanco;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTipoTitulo;
import com.touchcomp.basementor.constants.enums.workspacebanco.EnumConstWorkspaceAuthSections;
import com.touchcomp.basementor.constants.enums.workspacebanco.EnumConstWorkspaceOpSections;
import com.touchcomp.basementor.constants.enums.workspacebanco.santander.EnumConstSantanderAuthOp;
import com.touchcomp.basementor.constants.enums.workspacebanco.santander.pagamento.EnumConstWorkspaceSantanderPagOp;
import com.touchcomp.basementor.constants.enums.workspacebanco.santander.recebimento.EnumConstWorkspaceSantanderRecOp;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.interfaces.EnumOpSectionDinamicasInterface;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.WorkspaceBanco;
import com.touchcomp.basementor.model.vo.WorkspaceBancoAuthOp;
import com.touchcomp.basementor.model.vo.WorkspaceBancoOp;
import com.touchcomp.basementorbanks.constants.BanksType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.exceptions.BankNotSupportedException;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorrules.opcoesdinamicas.model.DTOOpcoesDinamicas;
import com.touchcomp.basementorservice.dao.impl.DaoWorkspaceBancoImpl;
import com.touchcomp.basementorservice.helpers.impl.workspacebanco.HelperWorkspaceBanco;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.components.banksapi.SCompBanksSincWorkspaces;
import com.touchcomp.basementorservice.service.impl.carteiracobranca.ServiceCarteiraCobrancaImpl;
import com.touchcomp.basementorservice.service.impl.configuracaocertificado.ServiceConfiguracaoCertificadoImpl;
import com.touchcomp.basementorservice.service.impl.instituicaovalores.ServiceInstituicaoValoresImpl;
import com.touchcomp.touchvomodel.vo.workspacebanco.web.DTOWorkspaceBancoRes;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.LinkedList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceWorkspaceBancoImpl
extends ServiceGenericEntityImpl<WorkspaceBanco, Long, DaoWorkspaceBancoImpl> {
    @Autowired
    ServiceCarteiraCobrancaImpl serviceCarteiraCobrancaImpl;
    @Autowired
    ServiceConfiguracaoCertificadoImpl serviceConfiguracaoCertificadoImpl;
    @Autowired
    ServiceInstituicaoValoresImpl serviceInstituicaoValoresImpl;
    @Autowired
    private HelperWorkspaceBanco helperWorkspace;

    @Autowired
    public ServiceWorkspaceBancoImpl(DaoWorkspaceBancoImpl dao) {
        super(dao);
    }

    @Override
    public WorkspaceBanco beforeDeleteEntity(WorkspaceBanco entity) {
        for (WorkspaceBancoAuthOp op : entity.getOpcoesAuthOp()) {
            op.setWorkspaceBanco(entity);
        }
        for (WorkspaceBancoAuthOp op : entity.getOpcoesOp()) {
            op.setWorkspaceBanco(entity);
        }
        return entity;
    }

    public DTOOpcoesDinamicas getOptions(Long idInstituicaoValores, Long idWorkspace, Short pagRec) throws ExceptionObjNotFound {
        InstituicaoValores inst = (InstituicaoValores)this.serviceInstituicaoValoresImpl.getOrThrow(idInstituicaoValores);
        BanksType type = BanksType.get((String)inst.getNrBanco());
        Object[] options = new EnumOpDinamicasInterface[]{};
        if (type != null) {
            switch (type) {
                case SANTANDER: {
                    options = this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO.getValue()) ? EnumConstWorkspaceSantanderPagOp.values() : EnumConstWorkspaceSantanderRecOp.values();
                }
            }
        }
        WorkspaceBanco opcoes = (WorkspaceBanco)this.get(idWorkspace);
        LinkedList<WorkspaceBancoOp> aux = new LinkedList();
        if (opcoes != null) {
            aux = opcoes.getOpcoesOp();
        }
        return CompOpcoes.getAllOptions(this.helperWorkspace.build(opcoes).getItens(aux), (EnumOpSectionDinamicasInterface[])EnumConstWorkspaceOpSections.values(), (EnumOpDinamicasInterface[])options);
    }

    public DTOOpcoesDinamicas getAuthOptions(Long idInstituicaoValores, Long idWorkspace) throws ExceptionObjNotFound {
        InstituicaoValores inst = (InstituicaoValores)this.serviceInstituicaoValoresImpl.getOrThrow(idInstituicaoValores);
        BanksType type = BanksType.get((String)inst.getNrBanco());
        EnumOpDinamicasInterface[] options = new EnumOpDinamicasInterface[]{};
        if (type != null) {
            switch (type) {
                case SANTANDER: {
                    options = EnumConstSantanderAuthOp.values();
                }
            }
        }
        WorkspaceBanco opcoes = (WorkspaceBanco)this.get(idWorkspace);
        LinkedList<WorkspaceBancoAuthOp> aux = new LinkedList();
        if (opcoes != null) {
            aux = opcoes.getOpcoesAuthOp();
        }
        return CompOpcoes.getAllOptions(this.helperWorkspace.build(opcoes).getAuthItens(aux), (EnumOpSectionDinamicasInterface[])EnumConstWorkspaceAuthSections.values(), (EnumOpDinamicasInterface[])options);
    }

    public void sincronizarWorkspacesBanco(CapsEmpresa idEmpresa, DTOWorkspaceBancoRes data, WebDTOResult result) throws ExceptionObjNotFound, BankException, BankNotSupportedException {
        InstituicaoValores inst = (InstituicaoValores)this.serviceInstituicaoValoresImpl.getOrThrow(data.getInstituicaoValoresIdentificador());
        ConfiguracaoCertificado conf = this.serviceConfiguracaoCertificadoImpl.getByEmpresaOrThrow(this.getSharedData().getEmpresa(idEmpresa.get()));
        SCompBanksSincWorkspaces sinc = new SCompBanksSincWorkspaces(this, this.serviceCarteiraCobrancaImpl, this.helperWorkspace, result);
        sinc.sincronizarWorkspaces(data, conf, inst, this.getSharedData().getEmpresa(idEmpresa.get()));
    }

    public WorkspaceBanco getByWorkspaceId(String id) {
        return ((DaoWorkspaceBancoImpl)this.getDao()).getByWorkspaceId(id);
    }

    public void atualizarInserirWorkspaceBanco(CapsEmpresa idEmpresa, String idWorkspace, WebDTOResult result) throws ExceptionObjNotFound, BankException, BankNotSupportedException {
        WorkspaceBanco workspace = (WorkspaceBanco)this.getOrThrow(idWorkspace);
        SCompBanksSincWorkspaces sinc = new SCompBanksSincWorkspaces(this, this.serviceCarteiraCobrancaImpl, this.helperWorkspace, result);
        sinc.sincronizarWorkspaces(workspace, this.getSharedData().getEmpresa(idEmpresa.get()));
    }

    public void deletarWorkspaceBanco(CapsEmpresa idEmpresa, String idWorkspace, WebDTOResult result) throws ExceptionObjNotFound, BankException, BankNotSupportedException {
        WorkspaceBanco workspace = (WorkspaceBanco)this.getOrThrow(idWorkspace);
        SCompBanksSincWorkspaces sinc = new SCompBanksSincWorkspaces(this, this.serviceCarteiraCobrancaImpl, this.helperWorkspace, result);
        sinc.deleteWorkspace(workspace, this.getSharedData().getEmpresa(idEmpresa.get()));
    }

    @Override
    public WorkspaceBanco beforeSaveEntity(WorkspaceBanco aux) {
        for (WorkspaceBancoAuthOp op : aux.getOpcoesAuthOp()) {
            op.setWorkspaceBanco(aux);
        }
        for (WorkspaceBancoAuthOp op : aux.getOpcoesOp()) {
            op.setWorkspaceBanco(aux);
        }
        if (aux.getCarteiraPrincipal() != null && aux.getCarteiraPrincipal().getContaValor() != null && aux.getCarteiraPrincipal().getContaValor().getAgenciaValor() != null) {
            aux.setInstituicaoValores(aux.getCarteiraPrincipal().getContaValor().getAgenciaValor().getInstituicaoValor());
        }
        return aux;
    }
}

