/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.xml;

import com.touchcomp.basementor.constants.enums.namespaces.ConstEnumNamespace;
import com.touchcomp.basementor.model.vo.NFCe;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.VersaoNFe;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionJDom;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.jdom.ToolJdom;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorxml.model.XMLNFCe;
import com.touchcomp.basementorxml.model.XMLNfePropria;
import com.touchcomp.basementorxml.service.impl.xmlnfce.ServiceXMLNFCeImpl;
import com.touchcomp.basementorxml.service.impl.xmlnfepropria.ServiceXMLNFePropriaImpl;
import java.io.File;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.springframework.stereotype.Service;

@Service
public class SCompXmlDocumentosNFeNFCeImpl
extends ServiceGenericImpl {
    ServiceXMLNFePropriaImpl serviceXMLNFe;
    ServiceXMLNFCeImpl serviceXMLNFce;
    private static final String SUFFIX_NFCe = "-procNFCe.xml";
    private static final String SUFFIX_NFe = "-procNFe.xml";

    public SCompXmlDocumentosNFeNFCeImpl(ServiceXMLNFePropriaImpl serviceXMLNFe, ServiceXMLNFCeImpl serviceXMLNFce) {
        this.serviceXMLNFe = serviceXMLNFe;
        this.serviceXMLNFce = serviceXMLNFce;
    }

    public String exportToString(NotaFiscalPropria nf) throws ExceptionInvalidData, ExceptionJDom {
        if (nf == null) {
            throw new ExceptionInvalidData("E.ERP.0228.008", new Object[0]);
        }
        XMLNfePropria xmlNF = this.serviceXMLNFe.getXMlNfePropria(nf.getIdentificador());
        if (xmlNF == null || !ToolMethods.isStrWithData((String)xmlNF.getConteudoXML())) {
            throw new ExceptionInvalidData("E.ERP.0228.008", new Object[]{nf.getIdentificador()});
        }
        if (!ToolMethods.isStrWithData((String)xmlNF.getConteudoAprovacao())) {
            throw new ExceptionInvalidData("E.ERP.0228.009", new Object[]{nf.getIdentificador()});
        }
        String xml = xmlNF.getConteudoXML();
        String xmlAutorizacao = xmlNF.getConteudoAprovacao();
        VersaoNFe versao = nf.getVersaoNfe();
        return this.getXML(xml, xmlAutorizacao, versao);
    }

    public File exportToFile(NotaFiscalPropria nf) throws ExceptionInvalidData, ExceptionJDom {
        return this.exportToFile(nf, null);
    }

    public File exportToFile(NotaFiscalPropria nf, String destDir) throws ExceptionInvalidData, ExceptionJDom {
        if (nf == null) {
            throw new ExceptionInvalidData("E.ERP.0228.008", new Object[0]);
        }
        XMLNfePropria xmlNF = this.serviceXMLNFe.getXMlNfePropria(nf.getIdentificador());
        if (xmlNF == null || !ToolMethods.isStrWithData((String)xmlNF.getConteudoXML())) {
            throw new ExceptionInvalidData("E.ERP.0228.008", new Object[]{nf.getIdentificador()});
        }
        if (!ToolMethods.isStrWithData((String)xmlNF.getConteudoAprovacao())) {
            throw new ExceptionInvalidData("E.ERP.0228.009", new Object[]{nf.getIdentificador()});
        }
        String xml = xmlNF.getConteudoXML();
        String xmlAutorizacao = xmlNF.getConteudoAprovacao();
        String chaveNFE = nf.getChaveNFE();
        VersaoNFe versao = nf.getVersaoNfe();
        return this.getFile(xml, xmlAutorizacao, chaveNFE, versao, destDir, SUFFIX_NFe);
    }

    public String exportToString(NFCe nf) throws ExceptionInvalidData, ExceptionJDom {
        if (nf == null) {
            throw new ExceptionInvalidData("E.ERP.0228.008", new Object[0]);
        }
        XMLNFCe xmlNF = this.serviceXMLNFce.getXMLNFCe(nf.getIdentificador());
        if (xmlNF == null || !ToolMethods.isStrWithData((String)xmlNF.getConteudoXML())) {
            throw new ExceptionInvalidData("E.ERP.0228.008", new Object[]{nf.getIdentificador()});
        }
        if (!ToolMethods.isStrWithData((String)xmlNF.getConteudoAprovacao())) {
            throw new ExceptionInvalidData("E.ERP.0228.009", new Object[]{nf.getIdentificador()});
        }
        String xml = xmlNF.getConteudoXML();
        String xmlAutorizacao = xmlNF.getConteudoAprovacao();
        VersaoNFe versao = nf.getVersaoNfe();
        return this.getXML(xml, xmlAutorizacao, versao);
    }

    public File exportToFile(NFCe nf) throws ExceptionInvalidData, ExceptionJDom {
        return this.exportToFile(nf, null);
    }

    public File exportToFile(NFCe nf, String destDir) throws ExceptionInvalidData, ExceptionJDom {
        if (nf == null) {
            throw new ExceptionInvalidData("E.ERP.0228.008", new Object[0]);
        }
        XMLNFCe xmlNF = this.serviceXMLNFce.getXMLNFCe(nf.getIdentificador());
        if (xmlNF == null || !ToolMethods.isStrWithData((String)xmlNF.getConteudoXML())) {
            throw new ExceptionInvalidData("E.ERP.0228.008", new Object[]{nf.getIdentificador()});
        }
        if (!ToolMethods.isStrWithData((String)xmlNF.getConteudoAprovacao())) {
            throw new ExceptionInvalidData("E.ERP.0228.009", new Object[]{nf.getIdentificador()});
        }
        String xml = xmlNF.getConteudoXML();
        String xmlAutorizacao = xmlNF.getConteudoAprovacao();
        String chaveNFE = nf.getChaveNFCe();
        VersaoNFe versao = nf.getVersaoNfe();
        return this.getFile(xml, xmlAutorizacao, chaveNFE, versao, destDir, SUFFIX_NFCe);
    }

    private Document getDocument(String xml, String xmlAutorizacao, VersaoNFe versao) throws ExceptionJDom {
        xml = xml.replace("&#xD;", "").replace("&#xA;", "");
        Document dXML = ToolJdom.getDocument((String)xml);
        Element rootXml = dXML.detachRootElement();
        Document dAutorizacao = ToolJdom.getDocument((String)xmlAutorizacao);
        Element rootAutorizacao = dAutorizacao.detachRootElement();
        Document doc = new Document();
        Element nfeProc = new Element("nfeProc");
        Attribute at = new Attribute("versao", versao.getCodigo());
        nfeProc.setAttribute(at);
        nfeProc.setNamespace(Namespace.getNamespace((String)ConstEnumNamespace.NAMESPACE_NFE.namespace));
        nfeProc.addContent((Content)rootXml);
        nfeProc.addContent((Content)rootAutorizacao);
        doc.setRootElement(nfeProc);
        return doc;
    }

    private String getXML(String xml, String xmlAutorizacao, VersaoNFe versao) throws ExceptionJDom {
        return ToolJdom.getXML((Document)this.getDocument(xml, xmlAutorizacao, versao), (String)"ISO-8859-1");
    }

    private File getFile(String xml, String xmlAutorizacao, String chaveNFE, VersaoNFe versao, String destDir, String suffix) throws ExceptionJDom {
        Document doc = this.getDocument(xml, xmlAutorizacao, versao);
        String fileName = File.separator + chaveNFE + suffix;
        File file = ToolMethods.isStrWithData((String)destDir) ? new File(destDir + File.separator + fileName) : ToolFile.createTempFile((String)fileName);
        ToolJdom.writeXML((Document)doc, (File)file, (String)"ISO-8859-1");
        return file;
    }
}

