/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.tasks;

import com.touchcomp.basementorservice.tasks.TaskMonitor;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class TaskCreator {
    public static <T> TaskAsync<T> supplyAsync(String descricao, Supplier<T> supplier, TaskProgress progress) {
        TaskAsync<T> task = TaskCreator.supplyAsync(descricao, supplier);
        task.setTaskProgress(progress);
        return task;
    }

    public static <T> TaskAsync<T> supplyAsync(String descricao, Supplier<T> supplier) {
        final ExecutorService executorService = Executors.newFixedThreadPool(1);
        AtomicReference taskThread = new AtomicReference();
        CompletableFuture cf = new CompletableFuture<T>(){
            AtomicReference<Thread> interruptThread = new AtomicReference();

            @Override
            public boolean complete(T value) {
                if (!executorService.isShutdown()) {
                    executorService.shutdownNow();
                }
                return super.complete(value);
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (!this.interruptThread.compareAndSet(null, Thread.currentThread()) && mayInterruptIfRunning) {
                    this.interruptThread.get().interrupt();
                }
                executorService.shutdownNow();
                return super.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean completeExceptionally(Throwable ex) {
                if (this.isDone()) {
                    return false;
                }
                executorService.shutdownNow();
                return super.completeExceptionally(ex);
            }
        };
        executorService.submit(() -> {
            taskThread.set(Thread.currentThread());
            try {
                Object result = supplier.get();
                cf.complete(result);
            }
            catch (Throwable ex) {
                cf.completeExceptionally(ex);
            }
            finally {
                executorService.shutdown();
            }
        });
        return new TaskAsync(cf, descricao);
    }

    public static <T> TaskAsync<T> supplyAsync(String descricao, CompletableFuture<T> ret) {
        return new TaskAsync<T>(ret, descricao);
    }

    public static class TaskAsync<T> {
        private TaskProgress taskProgress;
        private CompletableFuture<T> completableFuture;
        private String descricao;

        public TaskAsync(TaskProgress taskProgress, CompletableFuture<T> completableFuture, String descricao) {
            this.taskProgress = taskProgress;
            this.completableFuture = completableFuture;
            this.descricao = descricao;
        }

        public TaskAsync(CompletableFuture<T> completableFuture, String descricao) {
            this.completableFuture = completableFuture;
            this.descricao = descricao;
        }

        public TaskProgress getTaskProgress() {
            return this.taskProgress;
        }

        public void setTaskProgress(TaskProgress taskProgress) {
            this.taskProgress = taskProgress;
        }

        public CompletableFuture<T> getCompletableFuture() {
            return this.completableFuture;
        }

        public void setCompletableFuture(CompletableFuture<T> completableFuture) {
            this.completableFuture = completableFuture;
        }

        public boolean isDone() {
            return this.getCompletableFuture().isDone();
        }

        public boolean cancel(boolean b) {
            return this.getCompletableFuture().cancel(b);
        }

        public boolean isCancelled() {
            return this.getCompletableFuture().isCancelled();
        }

        public boolean isCompletedExceptionally() {
            return this.getCompletableFuture().isCompletedExceptionally();
        }

        public T get() throws InterruptedException, ExecutionException {
            T ret = this.getCompletableFuture().get();
            return ret;
        }

        public String getDescricao() {
            return this.descricao;
        }

        public void setDescricao(String descricao) {
            this.descricao = descricao;
        }
    }

    public static class TaskProgress {
        private double progress = -1.0;
        private double maxCountAux = 0.0;
        private double currentCountAux = 0.0;
        private String taskId;
        private List<TaskMonitor> monitors = new LinkedList<TaskMonitor>();
        public static final double INDERTERMINATED = -1.0;

        public double getProgress() {
            return ToolFormatter.arrredondarNumero((Double)this.progress, (int)2);
        }

        public TaskProgress setProgress(Double progress) {
            if (progress == null) {
                progress = -1.0;
            }
            this.progress = progress;
            this.monitors.forEach(monitor -> monitor.updateProgress(this.taskId, this.getProgress()));
            return this;
        }

        public void onProgress(double from, double max) {
            double temp = -1.0;
            if (from <= max && max > 0.0) {
                temp = from / max * 100.0;
            } else if (from > max) {
                temp = 100.0;
            }
            this.setProgress(temp);
        }

        public void countIt() {
            this.currentCountAux += 1.0;
            this.onProgress(this.currentCountAux, this.maxCountAux);
        }

        public void countIt(double toCount) {
            this.currentCountAux += toCount;
            this.onProgress(this.currentCountAux, this.maxCountAux);
        }

        public void setMaxCount(double count) {
            this.maxCountAux = count;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public void addMonitor(TaskMonitor monitor) {
            if (monitor == null) {
                return;
            }
            this.monitors.add(monitor);
        }
    }
}

