/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorspringcontext;

import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.springframework.stereotype.Component;

@Component
public class ToolDynamicClassSessionFactory {
    public static Class<?>[] getAnnotatedClassFrom(Collection<Class> temp, Class ... inputClass) {
        LinkedList<Class> data = new LinkedList<Class>();
        data.addAll(temp);
        for (Class input : inputClass) {
            data.add(input);
            ToolDynamicClassSessionFactory.getAnnotatedClazzFrom(input, data);
        }
        return data.toArray(new Class[0]);
    }

    public static Class<?>[] getAnnotatedClassFrom(Class ... inputClass) {
        return ToolDynamicClassSessionFactory.getAnnotatedClassFrom(new LinkedList<Class>(), inputClass);
    }

    private static void getAnnotatedClazzFrom(Class inputClass, List<Class> data) {
        List getters = ToolReflections.getGetMethods((Class)inputClass);
        getters.forEach(i -> {
            try {
                ToolDynamicClassSessionFactory.checkType(i, data);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        });
    }

    private static void checkType(Method i, List<Class> data) throws ClassNotFoundException {
        if (Collection.class.isAssignableFrom(i.getReturnType())) {
            ToolDynamicClassSessionFactory.addClassOneToMany(i, data);
            ToolDynamicClassSessionFactory.addClassManyToMany(i, data);
            ToolDynamicClassSessionFactory.addGeneryType(i, data);
        } else {
            ToolDynamicClassSessionFactory.addClassManyToOne(i, data);
            ToolDynamicClassSessionFactory.addClassOneToOne(i, data);
            ToolDynamicClassSessionFactory.addClass(i.getReturnType(), data);
        }
    }

    private static void addGeneryType(Method i, List<Class> data) throws ClassNotFoundException {
        Type t = i.getGenericReturnType();
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            for (Type taux : pt.getActualTypeArguments()) {
                String str = taux.getTypeName();
                ToolDynamicClassSessionFactory.addClass(Class.forName(str), data);
            }
        } else {
            ToolDynamicClassSessionFactory.addClass(i.getReturnType(), data);
        }
    }

    private static void addClassOneToMany(Method i, List<Class> data) {
        OneToMany oneToMany = i.getAnnotation(OneToMany.class);
        if (oneToMany != null && oneToMany.targetEntity() != null && !oneToMany.targetEntity().equals(Void.TYPE)) {
            ToolDynamicClassSessionFactory.addClass(oneToMany.targetEntity(), data);
        }
    }

    private static void addClassManyToMany(Method i, List<Class> data) {
        ManyToMany manyToMany = i.getAnnotation(ManyToMany.class);
        if (manyToMany != null && manyToMany.targetEntity() != null && !manyToMany.targetEntity().equals(Void.TYPE)) {
            ToolDynamicClassSessionFactory.addClass(manyToMany.targetEntity(), data);
        }
    }

    private static void addClassManyToOne(Method i, List<Class> data) {
        ManyToOne manyToOne = i.getAnnotation(ManyToOne.class);
        if (manyToOne != null && manyToOne.targetEntity() != null && !manyToOne.targetEntity().equals(Void.TYPE)) {
            ToolDynamicClassSessionFactory.addClass(manyToOne.targetEntity(), data);
        }
    }

    private static void addClassOneToOne(Method i, List<Class> data) {
        OneToOne oneToOne = i.getAnnotation(OneToOne.class);
        if (oneToOne != null && oneToOne.targetEntity() != null && !oneToOne.targetEntity().equals(Void.TYPE)) {
            ToolDynamicClassSessionFactory.addClass(oneToOne.targetEntity(), data);
        }
    }

    private static void addClass(Class temp, List<Class> data) {
        if (data.contains(temp)) {
            return;
        }
        if (temp.getAnnotation(Entity.class) == null) {
            return;
        }
        data.add(temp);
        ToolDynamicClassSessionFactory.getAnnotatedClazzFrom(temp, data);
    }
}

