/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.converter;

import com.touchcomp.basementortools.tools.converter.impl.BigIntegerOpFinder;
import com.touchcomp.basementortools.tools.converter.impl.DateOpFinder;
import com.touchcomp.basementortools.tools.converter.impl.DoubleOpFinder;
import com.touchcomp.basementortools.tools.converter.impl.FloatOpFinder;
import com.touchcomp.basementortools.tools.converter.impl.IntegerOpFinder;
import com.touchcomp.basementortools.tools.converter.impl.LongOpFinder;
import com.touchcomp.basementortools.tools.converter.impl.ObjectOpFinder;
import com.touchcomp.basementortools.tools.converter.impl.OpFinder;
import com.touchcomp.basementortools.tools.converter.impl.ShortOpFinder;
import com.touchcomp.basementortools.tools.converter.impl.StringOpFinder;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

public class CompRestrictionsFactory {
    private static final String DD_MM_YYYY_HH_MM = "dd/MM/yyyy HH:mm";

    public static OpFinder getRestrictions(String classe, String mask) {
        if (classe == null) {
            return new StringOpFinder();
        }
        if (classe.equals(String.class.getCanonicalName())) {
            return new StringOpFinder();
        }
        if (classe.equals(BigInteger.class.getCanonicalName())) {
            return new BigIntegerOpFinder();
        }
        if (classe.equals(Long.class.getCanonicalName())) {
            return new LongOpFinder();
        }
        if (classe.equals(Short.class.getCanonicalName())) {
            return new ShortOpFinder();
        }
        if (classe.equals(Integer.class.getCanonicalName())) {
            return new IntegerOpFinder();
        }
        if (classe.equals(BigInteger.class.getCanonicalName())) {
            return new BigIntegerOpFinder();
        }
        if (classe.equals(Double.class.getCanonicalName())) {
            return new DoubleOpFinder();
        }
        if (classe.equals(Float.class.getCanonicalName())) {
            return new FloatOpFinder();
        }
        if (classe.equals(java.util.Date.class.getCanonicalName()) || classe.equals(Date.class.getCanonicalName()) || classe.equals(Time.class.getCanonicalName()) || classe.equals(Timestamp.class.getCanonicalName())) {
            if (mask != null) {
                return new DateOpFinder(new SimpleDateFormat(mask));
            }
            return new DateOpFinder();
        }
        if (classe.equals(Timestamp.class.getCanonicalName())) {
            return new DateOpFinder(new SimpleDateFormat(DD_MM_YYYY_HH_MM));
        }
        return new ObjectOpFinder();
    }

    public static OpFinder getRestrictions(String classe) {
        return CompRestrictionsFactory.getRestrictions(classe, null);
    }

    public static OpFinder getRestrictions(Class classe) {
        return CompRestrictionsFactory.getRestrictions(classe.getCanonicalName(), null);
    }

    public static OpFinder getRestrictions(Class classe, String mask) {
        return CompRestrictionsFactory.getRestrictions(classe.getCanonicalName(), mask);
    }
}

