/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.dadosextenso;

import com.touchcomp.basementortools.tools.date.ToolDate;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class ToolDadosExtenso {
    private ArrayList nro;
    private BigInteger num;
    private String[][] Qualificadores = new String[][]{{"centavo", "centavos"}, {"", ""}, {"mil", "mil"}, {"milh\u00e3o", "milh\u00f5es"}, {"bilh\u00e3o", "bilh\u00f5es"}, {"trilh\u00e3o", "trilh\u00f5es"}, {"quatrilh\u00e3o", "quatrilh\u00f5es"}, {"quintilh\u00e3o", "quintilh\u00f5es"}, {"sextilh\u00e3o", "sextilh\u00f5es"}, {"septilh\u00e3o", "septilh\u00f5es"}};
    private String[][] Numeros = new String[][]{{"zero", "um", "dois", "tr\u00eas", "quatro", "cinco", "seis", "sete", "oito", "nove", "dez", "onze", "doze", "treze", "quatorze", "quinze", "desesseis", "desessete", "dezoito", "desenove"}, {"vinte", "trinta", "quarenta", "cinquenta", "sessenta", "setenta", "oitenta", "noventa"}, {"cem", "cento", "duzentos", "trezentos", "quatrocentos", "quinhentos", "seiscentos", "setecentos", "oitocentos", "novecentos"}};

    public ToolDadosExtenso() {
        this.nro = new ArrayList();
    }

    public ToolDadosExtenso(BigDecimal dec) {
        this();
        this.setNumber(dec);
    }

    public ToolDadosExtenso(double dec) {
        this();
        this.setNumber(dec);
    }

    public void setNumber(BigDecimal dec) {
        this.num = dec.setScale(2, 4).multiply(BigDecimal.valueOf(100L)).toBigInteger();
        this.nro.clear();
        if (this.num.equals(BigInteger.ZERO)) {
            this.nro.add(0);
            this.nro.add(0);
        } else {
            this.addRemainder(100);
            while (!this.num.equals(BigInteger.ZERO)) {
                this.addRemainder(1000);
            }
        }
    }

    public void setNumber(double dec) {
        this.setNumber(new BigDecimal(dec));
    }

    public void show() {
        Iterator valores = this.nro.iterator();
        while (valores.hasNext()) {
            System.out.println((Integer)valores.next());
        }
        System.out.println(this.toString());
    }

    public String numeroPorExtensoInternal(Integer numero) {
        StringBuffer buf = new StringBuffer();
        for (int ct = this.nro.size() - 1; ct > 0; --ct) {
            if (buf.length() > 0 && !this.ehGrupoZero(ct)) {
                buf.append(" e ");
            }
            buf.append(this.numToString((Integer)this.nro.get(ct), ct));
        }
        return buf.toString();
    }

    public static String numeroPorExtenso(Number numero) {
        ToolDadosExtenso ext = new ToolDadosExtenso(numero.doubleValue());
        return ext.numeroPorExtensoInternal(numero.intValue());
    }

    public static String numeroPorExtensoReais(Number number) {
        ToolDadosExtenso ext = new ToolDadosExtenso(number.doubleValue());
        return ext.toString();
    }

    public static String dataPorExtenso(Date data) {
        String dia = ToolDate.getDayInMonthDescription(data);
        String mes = ToolDate.dateToStr(data, "MMMM");
        String ano = ToolDate.dateToStr(data, "yyyy");
        ano = ToolDadosExtenso.numeroPorExtenso(Integer.valueOf(ano));
        mes = mes.toLowerCase();
        String retorno = null;
        retorno = dia.equalsIgnoreCase("um") ? dia + " dia do m\u00eas de " + mes + " do ano de " + ano : dia + " dias do m\u00eas de " + mes + " do ano de " + ano;
        return retorno;
    }

    public static String dataPorExtensoSomenteMes(Date data) {
        String dia = ToolDate.dateToStr(data, "dd");
        String mes = ToolDate.dateToStr(data, "MMMM");
        String ano = ToolDate.dateToStr(data, "yyyy");
        String retorno = null;
        retorno = dia.equalsIgnoreCase("um") ? dia + " de " + mes + " de " + ano : dia + " de " + mes + " de " + ano;
        return retorno;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int numero = (Integer)this.nro.get(0);
        for (int ct = this.nro.size() - 1; ct > 0; --ct) {
            if (buf.length() > 0 && !this.ehGrupoZero(ct)) {
                buf.append(" e ");
            }
            buf.append(this.numToString((Integer)this.nro.get(ct), ct));
        }
        if (buf.length() > 0) {
            if (this.ehUnicoGrupo()) {
                buf.append(" de ");
            }
            while (buf.toString().endsWith(" ")) {
                buf.setLength(buf.length() - 1);
            }
            if (this.ehPrimeiroGrupoUm()) {
                buf.insert(0, "h");
            }
            if (this.nro.size() == 2 && (Integer)this.nro.get(1) == 1) {
                buf.append(" real");
            } else {
                buf.append(" reais");
            }
            if ((Integer)this.nro.get(0) != 0) {
                buf.append(" e ");
            }
        }
        if ((Integer)this.nro.get(0) != 0) {
            buf.append(this.numToString((Integer)this.nro.get(0), 0));
        }
        return buf.toString();
    }

    private boolean ehPrimeiroGrupoUm() {
        return (Integer)this.nro.get(this.nro.size() - 1) == 1;
    }

    private void addRemainder(int divisor) {
        BigInteger[] newNum = this.num.divideAndRemainder(BigInteger.valueOf(divisor));
        this.nro.add(newNum[1].intValue());
        this.num = newNum[0];
    }

    private boolean temMaisGrupos(int ps) {
        while (ps > 0) {
            if ((Integer)this.nro.get(ps) != 0) {
                return true;
            }
            --ps;
        }
        return false;
    }

    private boolean ehUltimoGrupo(int ps) {
        return ps > 0 && (Integer)this.nro.get(ps) != 0 && !this.temMaisGrupos(ps - 1);
    }

    private boolean ehUnicoGrupo() {
        if (this.nro.size() <= 3) {
            return false;
        }
        if (!this.ehGrupoZero(1) && !this.ehGrupoZero(2)) {
            return false;
        }
        boolean hasOne = false;
        for (int i = 3; i < this.nro.size(); ++i) {
            if ((Integer)this.nro.get(i) == 0) continue;
            if (hasOne) {
                return false;
            }
            hasOne = true;
        }
        return true;
    }

    boolean ehGrupoZero(int ps) {
        if (ps <= 0 || ps >= this.nro.size()) {
            return true;
        }
        return (Integer)this.nro.get(ps) == 0;
    }

    private String numToString(int numero, int escala) {
        int unidade = numero % 10;
        int dezena = numero % 100;
        int centena = numero / 100;
        StringBuffer buf = new StringBuffer();
        if (numero != 0) {
            if (centena != 0) {
                if (dezena == 0 && centena == 1) {
                    buf.append(this.Numeros[2][0]);
                } else {
                    buf.append(this.Numeros[2][centena]);
                }
            }
            if (buf.length() > 0 && dezena != 0) {
                buf.append(" e ");
            }
            if (dezena > 19) {
                buf.append(this.Numeros[1][(dezena /= 10) - 2]);
                if (unidade != 0) {
                    buf.append(" e ");
                    buf.append(this.Numeros[0][unidade]);
                }
            } else if (centena == 0 || dezena != 0) {
                buf.append(this.Numeros[0][dezena]);
            }
            buf.append(" ");
            if (numero == 1) {
                buf.append(this.Qualificadores[escala][0]);
            } else {
                buf.append(this.Qualificadores[escala][1]);
            }
        }
        return buf.toString();
    }
}

