/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.database;

import com.touchcomp.basementortools.tools.exception.ToolException;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ToolDatabase {
    public static String extractForeignKeyName(String sql) {
        if (!ToolMethods.isStrWithData(sql)) {
            return null;
        }
        sql = sql.toUpperCase();
        String regex = "(?i)CONSTRAINT\\s+(\\w+)\\s+FOREIGN\\s+KEY";
        Matcher matcher = Pattern.compile(regex).matcher(sql);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String extractPrimaryKeyName(String sql) {
        if (!ToolMethods.isStrWithData(sql)) {
            return null;
        }
        sql = sql.toUpperCase();
        String regex = "(?i)CONSTRAINT\\s+(\\w+)\\s+PRIMARY\\s+KEY";
        Matcher matcher = Pattern.compile(regex).matcher(sql);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String extractUniqueKeyName(String sql) {
        if (!ToolMethods.isStrWithData(sql)) {
            return null;
        }
        sql = sql.toUpperCase();
        String regex = "(?i)CONSTRAINT\\s+(\\w+)\\s+UNIQUE";
        Matcher matcher = Pattern.compile(regex).matcher(sql);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String extractTableName(String sql) {
        if (!ToolMethods.isStrWithData(sql)) {
            return null;
        }
        sql = sql.toUpperCase();
        String regex = "(?i)CREATE\\s+TABLE\\s+(\\w+)";
        Matcher matcher = Pattern.compile(regex).matcher(sql);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String extractGeneratorName(String sql) {
        if (!ToolMethods.isStrWithData(sql)) {
            return null;
        }
        sql = sql.toUpperCase();
        String regex = "(?i)CREATE\\s+(?:GENERATOR|SEQUENCE)\\s+(\\w+)";
        Matcher matcher = Pattern.compile(regex).matcher(sql);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static EnumConstQueryStatus getDatabaseErrorMessage(Exception ex) {
        for (EnumConstQueryStatus val : EnumConstQueryStatus.values()) {
            if (!ToolException.findMessage(ex, val.errorStr).booleanValue()) continue;
            return val;
        }
        return EnumConstQueryStatus.QUERY_PROBLEMA_DESCONHECIDO_ERRO;
    }

    public static EnumConstQueryStatus getDatabaseErrorMessage(String stackTrace) {
        for (EnumConstQueryStatus val : EnumConstQueryStatus.values()) {
            if (!ToolException.findMessage(stackTrace, val.errorStr).booleanValue()) continue;
            return val;
        }
        return EnumConstQueryStatus.QUERY_PROBLEMA_DESCONHECIDO_ERRO;
    }

    public static Integer getConstraintLength(String query) {
        if (!ToolMethods.isStrWithData(query)) {
            return 0;
        }
        String constraint = ToolDatabase.extractForeignKeyName(query);
        if (ToolMethods.isStrWithData(constraint)) {
            return constraint.length();
        }
        constraint = ToolDatabase.extractGeneratorName(query);
        if (ToolMethods.isStrWithData(constraint)) {
            return constraint.length();
        }
        constraint = ToolDatabase.extractPrimaryKeyName(query);
        if (ToolMethods.isStrWithData(constraint)) {
            return constraint.length();
        }
        constraint = ToolDatabase.extractUniqueKeyName(query);
        if (ToolMethods.isStrWithData(constraint)) {
            return constraint.length();
        }
        constraint = ToolDatabase.extractTableName(query);
        if (ToolMethods.isStrWithData(constraint)) {
            return constraint.length();
        }
        return 0;
    }

    public static enum EnumConstQueryStatus {
        QUERY_FIELD_ALREADY_EXISTS(5, "Campo ja existe", "already exists"),
        QUERY_DUPLICATE_VALUE(6, "Valor ja existe", "duplicate value"),
        QUERY_VIOLATION_PRIMARY(7, "Campo ja existe", "violation of PRIMARY or UNIQUE KEY constraint"),
        QUERY_NOT_FOUND(8, "Exclusao de Campo/Procedure/Trigger que nao existe ou ja foi excluido", "not found"),
        QUERY_NOT_EXISTS(9, "Exclusao de Campo/Procedure/Trigger que nao existe ou ja foi excluido", "not exist"),
        QUERY_PROBLEMA_DESCONHECIDO_ERRO(3, "Avaliar Erro", ""),
        QUERY_OK(1, "", "");

        private final short value;
        private final String descricao;
        private final String errorStr;

        private EnumConstQueryStatus(short valor, String descricao, String errorStr) {
            this.value = valor;
            this.descricao = descricao;
            this.errorStr = errorStr;
        }

        public short getValue() {
            return this.value;
        }

        public static EnumConstQueryStatus get(Object value) {
            for (EnumConstQueryStatus value1 : EnumConstQueryStatus.values()) {
                if (!String.valueOf(value).equalsIgnoreCase(String.valueOf(value1.value))) continue;
                return value1;
            }
            return QUERY_PROBLEMA_DESCONHECIDO_ERRO;
        }

        public String toString() {
            return this.getDescricao();
        }

        public String getDescricao() {
            return this.descricao;
        }

        public String getErrorStr() {
            return this.errorStr;
        }
    }
}

