/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.date;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.touchcomp.basementortools.tools.cleardata.ToolClearData;
import com.touchcomp.basementortools.tools.date.FeriadoInterface;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;

public class ToolDate {
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String DD_MM_YYYY = "dd-MM-yyyy";
    public static final String DD_MM_YY = "dd-MM-yy";
    public static final String YY_MM = "yyMM";
    public static final String DD_MM_YYYY_HH_MM_SS = "dd/MM/yyyy hh:mm:ss";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD_HH_MM_SS_S = "yyyy-MM-dd HH:mm:ss.S";
    public static final String YYYY_MM_DD_HH_MM_SS_SSS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DD_MM_YYYY_HH_MM_SS_SSS_SQL = "dd.MM.yyyy, HH:mm:ss.SSS";
    public static final String DD_MM_YYYY_HH_MM_SS_SSS = "dd-MM-yyyy HH:mm:ss.SSS";
    public static final String DD_MM_YYYY_HH_MM = "dd/MM/yyyy hh:mm";
    public static final String DD_MM_YYYY__HH_MM = "dd/MM/yyyy-HH:mm";
    public static final String DD_MM_YYYY_HH_MM_SS_FILENAME = "dd_MM_yyyy_HH_mm_ss";
    public static final String YYYY_MM_DD_CLASSIC = "yyyy/MM/dd";
    public static final String DD_MM_YYYY_CLASSIC = "dd/MM/yyyy";
    public static final String DD_MM_YY_CLASSIC = "dd/MM/yy";
    public static final String DD_MM_YYYY_DOT_SEPARATOR = "dd.MM.yyyy";
    public static final String DD_MM_YY_DOT_SEPARATOR = "dd.MM.yy";
    public static final String DDMMYYYY_NOT_SEPARATOR = "ddMMyyyy";
    public static final String YYYYMMDD_NOT_SEPARATOR = "yyyyMMdd";
    public static final String ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String ISO_FORMAT_OFFSET = "yyyy-MM-dd'T'HH:mm:ssXXX";
    public static final String DD_MM = "ddMM";
    public static final String YYYYMM_NOT_SEPARATOR = "yyyyMM";
    public static final long oneDay = 86400000L;
    public static final long oneHour = 3600000L;
    public static final int MIL_SEG_EM_UM_DIA = 86400000;
    public static final String DD_MM_YYYY_HH_MM_SS_HIFEN = "dd/MM/yyyy HH:mm:ss";
    public static final String HH_MM = "HH:mm";
    public static final String HH_MM_SS = "HH:mm:ss";

    public static double difBetweenDatesInHoursNumber(java.util.Date dataIn, java.util.Date dataFim) {
        if (dataIn == null || dataFim == null) {
            return 0.0;
        }
        Long d1 = dataIn.getTime();
        Long d2 = dataFim.getTime();
        long dif = (d2 - d1) / 1000L;
        return (double)dif / 3600.0;
    }

    public static long difBetweenDatesInDays(java.util.Date dataIn, java.util.Date dataFim) {
        if (dataIn == null || dataFim == null) {
            return 0L;
        }
        java.util.Date dateInAux = new java.util.Date(dataIn.getTime());
        java.util.Date dateFimAux = new java.util.Date(dataFim.getTime());
        LocalDateTime ldt1 = LocalDateTime.ofInstant(dateInAux.toInstant(), ZoneId.systemDefault());
        LocalDateTime ldt2 = LocalDateTime.ofInstant(dateFimAux.toInstant(), ZoneId.systemDefault());
        return java.time.Duration.between(ldt1, ldt2).toDays();
    }

    public static long difBetweenDatesInMinutes(java.util.Date dataIn, java.util.Date dataFim) {
        if (dataIn == null || dataFim == null) {
            return 0L;
        }
        java.util.Date dateInAux = new java.util.Date(dataIn.getTime());
        java.util.Date dateFimAux = new java.util.Date(dataFim.getTime());
        LocalDateTime ldt1 = LocalDateTime.ofInstant(dateInAux.toInstant(), ZoneId.systemDefault());
        LocalDateTime ldt2 = LocalDateTime.ofInstant(dateFimAux.toInstant(), ZoneId.systemDefault());
        return java.time.Duration.between(ldt1, ldt2).toMinutes();
    }

    public static long difBetweenDatesInSeconds(java.util.Date dataIn, java.util.Date dataFim) {
        if (dataIn == null || dataFim == null) {
            return 0L;
        }
        java.util.Date dateInAux = new java.util.Date(dataIn.getTime());
        java.util.Date dateFimAux = new java.util.Date(dataFim.getTime());
        LocalDateTime ldt1 = LocalDateTime.ofInstant(dateInAux.toInstant(), ZoneId.systemDefault());
        LocalDateTime ldt2 = LocalDateTime.ofInstant(dateFimAux.toInstant(), ZoneId.systemDefault());
        return java.time.Duration.between(ldt1, ldt2).toMillis() / 1000L;
    }

    public static long difBetweenDatesInMiliseconds(java.util.Date dataIn, java.util.Date dataFim) {
        if (dataIn == null || dataFim == null) {
            return 0L;
        }
        java.util.Date dateInAux = new java.util.Date(dataIn.getTime());
        java.util.Date dateFimAux = new java.util.Date(dataFim.getTime());
        LocalDateTime ldt1 = LocalDateTime.ofInstant(dateInAux.toInstant(), ZoneId.systemDefault());
        LocalDateTime ldt2 = LocalDateTime.ofInstant(dateFimAux.toInstant(), ZoneId.systemDefault());
        return java.time.Duration.between(ldt1, ldt2).toMillis();
    }

    public static Integer diferenceDayBetweenDates(java.util.Date dataInicial, java.util.Date dataFinal) {
        if (dataInicial == null || dataFinal == null) {
            return 0;
        }
        return Days.daysBetween((ReadableInstant)ToolDate.toDateTime(dataInicial), (ReadableInstant)ToolDate.toDateTime(dataFinal)).getDays();
    }

    public static Integer daysBetweenInclusive(java.util.Date dataInicial, java.util.Date dataFinal) {
        if (dataInicial == null || dataFinal == null) {
            return 0;
        }
        dataInicial = ToolDate.dataSemHora(dataInicial);
        dataFinal = ToolDate.dataSemHora(dataFinal);
        DateTime ld1 = ToolDate.toDateTime(dataInicial);
        DateTime ld2 = ToolDate.toDateTime(dataFinal);
        if (dataInicial.equals(dataFinal)) {
            return 0;
        }
        return Days.daysBetween((ReadableInstant)ld1, (ReadableInstant)ld2).getDays() + 1;
    }

    public static Integer diferenceDayBetweenDatesExclusive(java.util.Date dataInicial, java.util.Date dataFinal) {
        if (dataInicial == null || dataFinal == null) {
            return 0;
        }
        return ToolDate.diferenceDayBetweenDates(dataInicial, dataFinal);
    }

    @Deprecated
    public static Integer diferenceDayBetweenDatesUseJodaDays(java.util.Date dataInicial, java.util.Date dataFinal) {
        return ToolDate.diferenceDayBetweenDatesExclusive(dataInicial, dataFinal);
    }

    public static java.util.Date getCurrentDate() {
        return ToolDate.strToDate(ToolDate.dateToStr(new java.util.Date(), DD_MM_YYYY_CLASSIC));
    }

    public static boolean diferenceMonths(java.util.Date data1, java.util.Date data2) {
        int m2;
        if (data1 == null || data2 == null) {
            return false;
        }
        int m1 = Integer.parseInt(ToolDate.dateToStr(data1, "MM"));
        return m1 != (m2 = Integer.parseInt(ToolDate.dateToStr(data2, "MM")));
    }

    public static int getLastDayOnMonth(int year, int month) {
        DateTime d = new DateTime(year, ++month, 1, 0, 0);
        return d.dayOfMonth().getMaximumValue();
    }

    public static int getLastDayOnMonth(java.util.Date data) {
        int year = ToolDate.getYearFromDate(data);
        int monthOfYear = ToolDate.getMonthFromDate(data) + 1;
        int dayOfMonth = ToolDate.getDayOnMonth(data);
        int hourOfDay = 0;
        int minuteOfHour = 0;
        DateTime d = new DateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, DateTimeZone.getDefault());
        return d.dayOfMonth().getMaximumValue();
    }

    public static DateTime toDateTime(java.util.Date data) {
        int year = ToolDate.getYearFromDate(data);
        int monthOfYear = ToolDate.getMonthFromDate(data) + 1;
        int dayOfMonth = ToolDate.getDayOnMonth(data);
        int hourOfDay = 0;
        int minuteOfHour = 0;
        DateTime d = new DateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, DateTimeZone.getDefault());
        return d;
    }

    public static java.util.Date getLastDateOnMonth(java.util.Date data) {
        DateTime d = ToolDate.toDateTime(data);
        d = d.dayOfMonth().withMaximumValue();
        return d.toDate();
    }

    public static java.util.Date getLastDateOnDay(java.util.Date data) {
        DateTime d = ToolDate.toDateTime(data);
        d = d.hourOfDay().withMaximumValue();
        d = d.minuteOfHour().withMaximumValue();
        d = d.secondOfMinute().withMaximumValue();
        return d.toDate();
    }

    public static java.util.Date getFirtDateOnMonth(java.util.Date data) {
        DateTime d = ToolDate.toDateTime(data);
        d = d.dayOfMonth().withMinimumValue();
        return d.toDate();
    }

    public static java.util.Date strToDate(String strDate) {
        return ToolDate.strToDate(strDate, DD_MM_YYYY_CLASSIC);
    }

    public static java.util.Date strToDate(String strDate, String pattern) {
        try {
            if (strDate != null) {
                SimpleDateFormat d = new SimpleDateFormat(pattern);
                java.util.Date tempDate = d.parse(strDate);
                if (!d.format(tempDate).equals(strDate)) {
                    throw new ParseException("", 5);
                }
                return tempDate;
            }
            return null;
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new RuntimeException("N\u00e3o foi poss\u00edvel converter o texto " + strDate + " em data");
        }
    }

    public static String dateToStr(java.util.Date date) {
        return ToolDate.dateToStr(date, DD_MM_YYYY_CLASSIC);
    }

    public static java.util.Date strToDate(String strDate, int dateFormat) {
        try {
            if (strDate != null) {
                java.util.Date tempDate;
                DateFormat d = DateFormat.getDateInstance(dateFormat);
                if (!d.format(tempDate = d.parse(strDate)).equals(strDate)) {
                    throw new ParseException("", 5);
                }
                return tempDate;
            }
            return null;
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new RuntimeException("N\u00e3o foi poss\u00edvel converter o texto " + strDate + " em data");
        }
    }

    public static String dateToStr(java.util.Date date, int dateFormat) {
        if (date != null) {
            return DateFormat.getDateInstance(dateFormat).format(date);
        }
        return null;
    }

    public static java.util.Date formatDate(java.util.Date d, int dateFormat) {
        try {
            if (d != null) {
                String strHoje = ToolDate.dateToStr(d);
                java.util.Date hoje = DateFormat.getDateInstance(dateFormat).parse(strHoje);
                return hoje;
            }
            return null;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return d;
        }
    }

    public static java.util.Date formatDate(java.util.Date date) {
        return ToolDate.formatDate(date, 2);
    }

    public static String dateToStr(java.util.Date date, String pattern) {
        if (date != null) {
            SimpleDateFormat sd = new SimpleDateFormat(pattern);
            return sd.format(date);
        }
        return "";
    }

    public static boolean comparaMesAno(String data1, String data2) {
        String data1Str = data1.substring(data1.indexOf("/") + 1);
        String data2Str = data2.substring(data2.indexOf("/") + 1);
        return data1Str.equals(data2Str);
    }

    public static java.util.Date nextDays(java.util.Date dataAtual, int numDias) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(dataAtual);
        g.add(5, numDias);
        return g.getTime();
    }

    public static java.util.Date nextDays(java.util.Date dataAtual, double numHoras) {
        java.util.Date date = new java.util.Date(dataAtual.getTime() + (long)(numHoras * 60.0 * 60.0 * 1000.0));
        return date;
    }

    public static java.util.Date nextDateCronExp(String cronExpression, java.util.Date base) {
        CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)parser.parse(cronExpression));
        Optional nextExec = executionTime.nextExecution(ToolDate.dateToZonedDateTime(base));
        if (!nextExec.isPresent()) {
            return null;
        }
        return ToolDate.asDate((ZonedDateTime)nextExec.get());
    }

    public static java.util.Date nextDaySameTime(java.util.Date dataAtual, java.util.Date dataTimeBase, double numHoras) {
        if (dataAtual == null) {
            return null;
        }
        if (dataTimeBase == null) {
            return null;
        }
        java.util.Date dataProxima = new java.util.Date(dataAtual.getTime() + (long)(numHoras * 60.0 * 60.0 * 1000.0));
        GregorianCalendar gSource = new GregorianCalendar();
        GregorianCalendar gDest = new GregorianCalendar();
        gSource.setTime(dataTimeBase);
        gDest.setTime(dataProxima);
        gDest.set(11, gSource.get(11));
        gDest.set(12, gSource.get(12));
        gDest.set(13, gSource.get(13));
        return gDest.getTime();
    }

    public static java.util.Date nextMonth(java.util.Date dataAtual, int mes) {
        if (dataAtual == null) {
            return null;
        }
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(dataAtual);
        g.add(2, mes);
        return g.getTime();
    }

    public static java.util.Date nextYear(java.util.Date data, int ano) {
        if (data == null) {
            return null;
        }
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        g.add(1, ano);
        return g.getTime();
    }

    public static java.util.Date previousDays(java.util.Date dataAtual, int numDias) {
        if (dataAtual == null) {
            return null;
        }
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(dataAtual);
        g.add(5, numDias * -1);
        return g.getTime();
    }

    public static Date toSQLDate(java.util.Date data) {
        if (data == null) {
            return null;
        }
        try {
            long dataLong = data.getTime();
            return new Date(dataLong);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Timestamp toTimestamp(java.util.Date data, java.util.Date time) {
        if (data == null) {
            return null;
        }
        if (time == null) {
            return null;
        }
        Calendar dateCalendar = ToolDate.toCalendar(data);
        Calendar timeCalendar = ToolDate.toCalendar(time);
        dateCalendar.set(11, timeCalendar.get(11));
        dateCalendar.set(12, timeCalendar.get(12));
        dateCalendar.set(13, timeCalendar.get(13));
        return new Timestamp(dateCalendar.getTime().getTime());
    }

    public static Timestamp toTimestamp(java.util.Date data) {
        if (data == null) {
            return null;
        }
        long dataLong = data.getTime();
        return new Timestamp(dataLong);
    }

    public static Calendar toCalendar(java.util.Date data) {
        if (data == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(data);
        return calendar;
    }

    public static java.util.Date toTime(java.util.Date data) {
        if (data == null) {
            return null;
        }
        long dataLong = data.getTime();
        Time time = new Time(dataLong);
        return new Date(time.getTime());
    }

    public static String getDayInMonthDescription(java.util.Date data) {
        if (data == null) {
            return null;
        }
        String dia = ToolDate.dateToStr(data, "dd");
        return ToolDate.getDayInMonthDescription(dia);
    }

    public static String getDayInMonthDescription(String dia) {
        if (dia == null) {
            return null;
        }
        if (Integer.parseInt(dia) > 31 || Integer.parseInt(dia) <= 0) {
            throw new IllegalArgumentException("Dia inv\u00e1lido");
        }
        HashMap<String, String> dias = new HashMap<String, String>();
        dias.put("01", "um");
        dias.put("02", "dois");
        dias.put("03", "tr\u00eas");
        dias.put("04", "quatro");
        dias.put("05", "cinco");
        dias.put("06", "seis");
        dias.put("07", "sete");
        dias.put("08", "oito");
        dias.put("09", "nove");
        dias.put("10", "dez");
        dias.put("11", "onze");
        dias.put("12", "doze");
        dias.put("13", "treze");
        dias.put("14", "quatorze");
        dias.put("16", "dezesseis");
        dias.put("17", "dezessete");
        dias.put("18", "dezoito");
        dias.put("19", "dezenove");
        dias.put("20", "vinte");
        dias.put("21", "vinte e um");
        dias.put("22", "vinte e dois");
        dias.put("23", "vinte e tr\u00eas");
        dias.put("24", "vinte e quatro");
        dias.put("25", "vinte e cinco");
        dias.put("26", "vinte e seis");
        dias.put("27", "vinte e sete");
        dias.put("28", "vinte e oito");
        dias.put("29", "vinte e nove");
        dias.put("30", "trinta");
        dias.put("31", "trinta e um");
        return (String)dias.get(dia);
    }

    public static Integer yearFromDate(Object obj) {
        return Integer.valueOf(new SimpleDateFormat("yyyy").format(obj));
    }

    public static Integer monthFromDate(java.util.Date obj) {
        return Integer.valueOf(new SimpleDateFormat("MM").format(obj));
    }

    public static Integer dayFromDate(java.util.Date obj) {
        return Integer.valueOf(new SimpleDateFormat("dd").format(obj));
    }

    public static Integer hourFromDate(java.util.Date obj) {
        return Integer.valueOf(new SimpleDateFormat("HH").format(obj));
    }

    public static Integer minutesFromDate(java.util.Date obj) {
        return Integer.valueOf(new SimpleDateFormat("mm").format(obj));
    }

    public static java.util.Date getDataInicial(java.util.Date anoMes) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(anoMes);
        g.set(5, 1);
        return g.getTime();
    }

    public static java.util.Date getDataFinal(java.util.Date anoMes) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(anoMes);
        g.set(5, ToolDate.getLastDayOnMonth(g.get(1), g.get(2)));
        return g.getTime();
    }

    public static java.util.Date intToDate(Integer ano, Integer mes, Integer dia) {
        try {
            String strDate = dia + "-" + mes + "-" + ano;
            SimpleDateFormat sd = new SimpleDateFormat(DD_MM_YYYY);
            if ("".equals(ToolClearData.refina(strDate))) {
                return null;
            }
            java.util.Date tempDate = sd.parse(strDate);
            return tempDate;
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Erro ao converter a Data");
        }
    }

    public static Double calcularDifHoras(java.util.Date dtAber, java.util.Date dtEnce) {
        if (dtAber == null || dtEnce == null) {
            return 0.0;
        }
        Duration duration = new Duration(dtAber.getTime(), dtEnce.getTime());
        double d = (double)duration.getStandardSeconds() / 60.0 / 60.0;
        return d;
    }

    public static Integer calcularDifMinutos(java.util.Date dtAber, java.util.Date dtEnce) {
        if (dtAber == null || dtEnce == null) {
            return 0;
        }
        Duration duration = new Duration(dtAber.getTime(), dtEnce.getTime());
        Double d = (double)duration.getStandardSeconds() / 60.0;
        return d.intValue();
    }

    public static java.util.Date dataSemHora(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return ToolDate.strToDate(ToolDate.dateToStr(date, DD_MM_YYYY), DD_MM_YYYY);
    }

    public static Double getHorasEmNumero(java.util.Date base) {
        if (base == null) {
            return 0.0;
        }
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(base);
        int h = g.get(11);
        int m = g.get(12);
        int s = g.get(13);
        double aux = (double)s / 60.0;
        double aux1 = (aux + (double)m) / 60.0;
        return (double)h + aux1;
    }

    public static java.util.Date mergeDateWithHour(Long date, Long time) {
        java.util.Date dateObj = new java.util.Date();
        java.util.Date timeObj = new java.util.Date();
        if (date != null) {
            dateObj = new java.util.Date(date);
        }
        if (time != null) {
            timeObj = new java.util.Date(time);
        }
        return ToolDate.mergeDateWithHour(dateObj, timeObj);
    }

    public static java.util.Date mergeDateWithHour(java.util.Date date, java.util.Date time) {
        GregorianCalendar calendarDate = new GregorianCalendar();
        GregorianCalendar calendarTime = new GregorianCalendar();
        calendarDate.setTime(date != null ? date : new java.util.Date());
        calendarTime.setTime(time != null ? time : new java.util.Date());
        calendarDate.set(11, calendarTime.get(11));
        calendarDate.set(12, calendarTime.get(12));
        calendarDate.set(13, calendarTime.get(13));
        return calendarDate.getTime();
    }

    public static Boolean dateBetween(java.util.Date date, java.util.Date inicialTarget, java.util.Date finalTarget) {
        return !(!date.equals(inicialTarget) && !date.after(inicialTarget) || !date.equals(finalTarget) && !date.before(finalTarget));
    }

    public static Integer getMesesEntreDatas(java.util.Date dataInicial, java.util.Date dataFinal, Boolean ignoraMesDasDatas) {
        Calendar cIni = Calendar.getInstance();
        cIni.setTime(dataInicial);
        Calendar cFIm = Calendar.getInstance();
        cFIm.setTime(dataFinal);
        int difMes = cFIm.get(2) - cIni.get(2);
        int difAno = (cFIm.get(1) - cIni.get(1)) * 12;
        int total = difAno + difMes;
        if (ignoraMesDasDatas.booleanValue()) {
            return total - 1;
        }
        return total;
    }

    public static java.util.Date getCurrentDateTime() {
        return new java.util.Date();
    }

    public static java.util.Date lowDateTime(java.util.Date date) {
        Calendar aux = Calendar.getInstance();
        aux.setTime(date);
        ToolDate.toOnlyDate(aux);
        return aux.getTime();
    }

    public static java.util.Date highDateTime(java.util.Date date) {
        Calendar aux = Calendar.getInstance();
        aux.setTime(date);
        ToolDate.toOnlyDate(aux);
        aux.roll(11, false);
        aux.roll(12, false);
        aux.roll(13, false);
        aux.roll(14, false);
        return aux.getTime();
    }

    public static void toOnlyDate(Calendar date) {
        date.set(11, 0);
        date.set(12, 0);
        date.set(13, 0);
        date.set(14, 0);
    }

    public static int differenceYearsBetweenDates(java.util.Date first, java.util.Date last) {
        Calendar a = ToolDate.getCalendar(first);
        Calendar b = ToolDate.getCalendar(last);
        int diff = b.get(1) - a.get(1);
        if (a.get(2) > b.get(2) || a.get(2) == b.get(2) && a.get(5) > b.get(5)) {
            --diff;
        }
        return diff;
    }

    public static Calendar getCalendar(java.util.Date date) {
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(date);
        return cal;
    }

    public static Integer getDaysOnMonth(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Integer numeroDias = calendar.getActualMaximum(5);
        return numeroDias;
    }

    public static int getMonthFromDate(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Integer numeroMes = calendar.get(2);
        return numeroMes;
    }

    public static int getYearFromDate(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Integer numeroYear = calendar.get(1);
        return numeroYear;
    }

    public static int getDayFromDate(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static Boolean comparePeriodFromDates(java.util.Date date1, java.util.Date date2) {
        if (date1 == null || date2 == null) {
            return Boolean.FALSE;
        }
        Integer ano1 = ToolDate.yearFromDate(date1);
        Integer mes1 = ToolDate.monthFromDate(date1);
        Integer ano2 = ToolDate.yearFromDate(date2);
        Integer mes2 = ToolDate.monthFromDate(date2);
        if (mes1.equals(mes2) && ano1.equals(ano2)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static java.util.Date addMonthToDate(java.util.Date date, Integer numberMonth) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, numberMonth);
        return c.getTime();
    }

    public static String diaDaSemanaTexto(java.util.Date data) {
        if (data == null) {
            return null;
        }
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        switch (g.get(7)) {
            case 1: {
                return "Domingo";
            }
            case 2: {
                return "Segunda";
            }
            case 3: {
                return "Ter\u00e7a";
            }
            case 4: {
                return "Quarta";
            }
            case 5: {
                return "Quinta";
            }
            case 6: {
                return "Sexta";
            }
            case 7: {
                return "S\u00e1bado";
            }
        }
        return null;
    }

    public static String diaDaSemanaTextoSemAcentuacao(java.util.Date data) {
        if (data == null) {
            return null;
        }
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        switch (g.get(7)) {
            case 1: {
                return "Domingo";
            }
            case 2: {
                return "Segunda";
            }
            case 3: {
                return "Terca";
            }
            case 4: {
                return "Quarta";
            }
            case 5: {
                return "Quinta";
            }
            case 6: {
                return "Sexta";
            }
            case 7: {
                return "Sabado";
            }
        }
        return null;
    }

    public static java.util.Date getDateFirstMonthDay(java.util.Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        return c.getTime();
    }

    public static java.util.Date getDateLastMonthDay(java.util.Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, ToolDate.getDaysOnMonth(date));
        return c.getTime();
    }

    public static String getMonthDescription(int mes) {
        switch (mes) {
            case 0: {
                return "Janeiro";
            }
            case 1: {
                return "Fevereiro";
            }
            case 2: {
                return "Mar\u00e7o";
            }
            case 3: {
                return "Abril";
            }
            case 4: {
                return "Maio";
            }
            case 5: {
                return "Junho";
            }
            case 6: {
                return "Julho";
            }
            case 7: {
                return "Agosto";
            }
            case 8: {
                return "Setembro";
            }
            case 9: {
                return "Outubro";
            }
            case 10: {
                return "Novembro";
            }
            case 11: {
                return "Dezembro";
            }
        }
        return null;
    }

    public static String getMonthDescriptionCompacted(int mes) {
        switch (mes) {
            case 0: {
                return "Jan";
            }
            case 1: {
                return "Fev";
            }
            case 2: {
                return "Mar";
            }
            case 3: {
                return "Abr";
            }
            case 4: {
                return "Mai";
            }
            case 5: {
                return "Jun";
            }
            case 6: {
                return "Jul";
            }
            case 7: {
                return "Ago";
            }
            case 8: {
                return "Set";
            }
            case 9: {
                return "Out";
            }
            case 10: {
                return "Nov";
            }
            case 11: {
                return "Dez";
            }
        }
        return null;
    }

    public static java.util.Date dataSemSegundos(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Integer diaDaSemana(java.util.Date data) {
        if (data == null) {
            return null;
        }
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        return g.get(7);
    }

    public static Boolean compareDate(java.util.Date date1, java.util.Date date2) {
        if (date1 == null || date2 == null) {
            return Boolean.FALSE;
        }
        Integer ano1 = ToolDate.yearFromDate(date1);
        Integer mes1 = ToolDate.monthFromDate(date1);
        Integer dia1 = ToolDate.dayFromDate(date1);
        Integer ano2 = ToolDate.yearFromDate(date2);
        Integer mes2 = ToolDate.monthFromDate(date2);
        Integer dia2 = ToolDate.dayFromDate(date2);
        if (mes1.equals(mes2) && ano1.equals(ano2) && dia1.equals(dia2)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean compareDateHourAndMinute(java.util.Date date1, java.util.Date date2) {
        if (date1 == null || date2 == null) {
            return Boolean.FALSE;
        }
        Integer ano1 = ToolDate.yearFromDate(date1);
        Integer mes1 = ToolDate.monthFromDate(date1);
        Integer dia1 = ToolDate.dayFromDate(date1);
        Integer hour1 = ToolDate.hourFromDate(date1);
        Integer minutes1 = ToolDate.minutesFromDate(date1);
        Integer ano2 = ToolDate.yearFromDate(date2);
        Integer mes2 = ToolDate.monthFromDate(date2);
        Integer dia2 = ToolDate.dayFromDate(date2);
        Integer hour2 = ToolDate.hourFromDate(date2);
        Integer minutes2 = ToolDate.minutesFromDate(date2);
        if (mes1.equals(mes2) && ano1.equals(ano2) && dia1.equals(dia2) && hour1.equals(hour2) && minutes1.equals(minutes2)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Double diffHorasPorData(java.util.Date data, Double horaInicio, Double horaFinal) {
        java.util.Date dataInicio = ToolDate.getDataComHoras(data, horaInicio);
        java.util.Date dataFinal = ToolDate.getDataComHoras(data, horaFinal);
        return ToolDate.calcularDifHoras(dataInicio, dataFinal);
    }

    private static java.util.Date getDataComHoras(java.util.Date data, Double hora) {
        GregorianCalendar g = new GregorianCalendar();
        hora = ToolFormatter.arrredondarNumero(hora, 2);
        Integer inteira = hora.intValue();
        Integer decimal = (int)Math.round((hora - (double)hora.intValue()) * 100.0);
        g.setTime(data);
        g.set(10, inteira);
        g.set(12, decimal);
        g.set(13, 0);
        return g.getTime();
    }

    public static String formatDateAnoMes(java.util.Date data) {
        Integer ano = ToolDate.getYearFromDate(data);
        Integer mes = ToolDate.getMonthFromDate(data) + 1;
        if (mes <= 9) {
            return ano + "-0" + mes;
        }
        return ano + "-" + mes;
    }

    public static String formatDateAnoMesDia(java.util.Date data) {
        Integer ano = ToolDate.getYearFromDate(data);
        Integer mes = ToolDate.getMonthFromDate(data) + 1;
        Integer dia = ToolDate.getDayOnMonth(data);
        String mesTexto = mes <= 9 ? "-0" + mes : "-" + mes;
        String diaTexto = dia <= 9 ? "-0" + dia : "-" + dia;
        return ano + mesTexto + diaTexto;
    }

    public static java.util.Date nextDays(java.util.Date data, int fieldType, int numero) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        g.set(fieldType, g.get(fieldType) + numero);
        return g.getTime();
    }

    public static java.util.Date nextDays(java.util.Date data, int days, FeriadoInterface feriadoInterface) {
        if (days == 0) {
            return data;
        }
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        int interno = 1;
        do {
            g.set(5, g.get(5) + 1);
            if (feriadoInterface.isFeriado(g.getTime())) continue;
            ++interno;
        } while (interno <= days);
        return g.getTime();
    }

    public static java.util.Date previousDays(java.util.Date data, int fieldType, int numero) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        g.set(fieldType, g.get(fieldType) + numero);
        return g.getTime();
    }

    public static boolean isHorarioVerao() {
        Calendar c = Calendar.getInstance(TimeZone.getDefault());
        c.setTime(new java.util.Date());
        int offset = c.get(16);
        return offset != 0;
    }

    public static boolean isSunday(java.util.Date data) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        return g.get(7) == 1;
    }

    public static boolean isSaturday(java.util.Date data) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        return g.get(7) == 7;
    }

    public static java.util.Date dataUltHora(java.util.Date data) {
        if (data == null) {
            return null;
        }
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        g.set(11, 23);
        g.set(12, 59);
        g.set(13, 59);
        g.set(14, 999);
        return g.getTime();
    }

    public static java.util.Date dataPrimHora(java.util.Date data) {
        if (data == null) {
            return null;
        }
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        g.set(11, 0);
        g.set(12, 0);
        g.set(13, 0);
        g.set(14, 0);
        return g.getTime();
    }

    public static java.util.Date colocarHorasEmData(java.util.Date data, int horas, int minutos, int segundos) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        g.set(11, horas);
        g.set(12, minutos);
        g.set(13, segundos);
        g.set(14, 999);
        return g.getTime();
    }

    public static Boolean isWeekend(java.util.Date data) {
        if (data == null) {
            return null;
        }
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        switch (g.get(7)) {
            case 1: {
                return true;
            }
            case 7: {
                return true;
            }
        }
        return false;
    }

    private static int getDayOnMonth(java.util.Date data) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(data);
        Integer numeroMes = calendar.get(5);
        return numeroMes;
    }

    public static java.util.Date asDate(LocalDateTime dataColeta) {
        return ToolDate.asDate(dataColeta, ZoneId.systemDefault());
    }

    public static java.util.Date asDate(LocalDateTime dataColeta, ZoneId zoneId) {
        if (dataColeta == null) {
            return null;
        }
        return java.util.Date.from(dataColeta.atZone(zoneId).toInstant());
    }

    public static java.util.Date asDate(LocalDate dataColeta) {
        return ToolDate.asDate(dataColeta, ZoneId.systemDefault());
    }

    public static java.util.Date asDate(LocalDate dataColeta, ZoneId zoneId) {
        if (dataColeta == null) {
            return null;
        }
        return java.util.Date.from(dataColeta.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static int compareTo(java.util.Date dataInicial, java.util.Date dataFinal) {
        if (dataInicial == null) {
            dataInicial = new java.util.Date(0L);
        }
        if (dataFinal == null) {
            dataFinal = new java.util.Date(0L);
        }
        return dataInicial.compareTo(dataFinal);
    }

    public static ZonedDateTime dateToZonedDateTime(java.util.Date date) {
        return ToolDate.dateToZonedDateTime(date, null);
    }

    public static ZonedDateTime dateToZonedDateTime(java.util.Date date, String zonedId) {
        if (date == null) {
            return null;
        }
        ZoneId zone = null;
        if (ToolMethods.isStrWithData(zonedId)) {
            zone = ZoneId.of(zonedId);
        }
        if (zone == null) {
            zone = ZoneId.systemDefault();
        }
        return ZonedDateTime.ofInstant(date.toInstant(), zone);
    }

    public static LocalDate formatarLocalDate(java.util.Date data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Date) {
            data = new java.util.Date(data.getTime());
        }
        return data.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime formatarLocalDateTime(java.util.Date data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Date) {
            data = new java.util.Date(data.getTime());
        }
        return data.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static List<java.util.Date[]> splitInMonths(java.util.Date dataIn, java.util.Date dataFim) {
        LinkedList<java.util.Date[]> periodos = new LinkedList<java.util.Date[]>();
        while (dataIn.before(dataFim)) {
            java.util.Date[] temp = new java.util.Date[2];
            periodos.add(temp);
            GregorianCalendar d0 = new GregorianCalendar();
            d0.setTime(dataIn);
            d0.set(5, d0.getMinimum(5));
            temp[0] = d0.getTime();
            d0.set(5, ToolDate.getLastDayOnMonth(dataIn));
            temp[1] = d0.getTime();
            d0.set(5, d0.get(5) + 1);
            dataIn = d0.getTime();
        }
        return periodos;
    }

    public static java.util.Date asDate(ZonedDateTime param) {
        if (param == null) {
            return null;
        }
        return java.util.Date.from(param.toInstant());
    }

    public static Long getEpochDate(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().getEpochSecond();
    }

    public static int dataDiff(java.util.Date dataLow, java.util.Date dataHigh) {
        GregorianCalendar startTime = new GregorianCalendar();
        GregorianCalendar endTime = new GregorianCalendar();
        GregorianCalendar curTime = new GregorianCalendar();
        GregorianCalendar baseTime = new GregorianCalendar();
        startTime.setTime(dataLow);
        endTime.setTime(dataHigh);
        int dif_multiplier = 1;
        if (dataLow.compareTo(dataHigh) < 0) {
            baseTime.setTime(dataHigh);
            curTime.setTime(dataLow);
            dif_multiplier = 1;
        } else {
            baseTime.setTime(dataLow);
            curTime.setTime(dataHigh);
            dif_multiplier = -1;
        }
        int result_years = 0;
        int result_months = 0;
        int result_days = 0;
        while (curTime.get(1) < baseTime.get(1) || curTime.get(2) < baseTime.get(2)) {
            int max_day = curTime.getActualMaximum(5);
            result_months += max_day;
            curTime.add(2, 1);
        }
        return result_years + (result_months *= dif_multiplier) + (result_days += endTime.get(5) - startTime.get(5));
    }

    public static int get(int gregorianCalendarField, java.util.Date data) {
        GregorianCalendar gl = new GregorianCalendar();
        gl.setTime(data);
        return gl.get(gregorianCalendarField);
    }

    public static double calcularDifHorasUteis(java.util.Date inicio, java.util.Date fim, Double horaInicial, Double horaFinal, FeriadoInterface feriadoInterface) {
        return ToolDate.calcularDifHorasUteis(ToolDate.formatarLocalDateTime(inicio), ToolDate.formatarLocalDateTime(fim), horaInicial, horaFinal, feriadoInterface);
    }

    public static double calcularDifHorasUteis(LocalDateTime inicio, LocalDateTime fim, Double horaInicial, Double horaFinal, FeriadoInterface feriadoInterface) {
        if (inicio == null || fim == null || fim.isBefore(inicio)) {
            return 0.0;
        }
        if (Objects.equals(ToolDate.dataSemHora(ToolDate.asDate(inicio)), ToolDate.dataSemHora(ToolDate.asDate(fim)))) {
            double horasUteisDataIn = ToolDate.calcularDifHorasUteis(inicio, fim, horaInicial, horaFinal);
            if (feriadoInterface != null && feriadoInterface.isFeriado(ToolDate.asDate(inicio))) {
                return 0.0;
            }
            return horasUteisDataIn;
        }
        LocalDate dataAtual = inicio.toLocalDate();
        double horasUteisEntreDatas = 0.0;
        while (!dataAtual.isAfter(fim.toLocalDate())) {
            boolean ehFeriadoDiaUtil;
            boolean bl = ehFeriadoDiaUtil = feriadoInterface != null && feriadoInterface.isFeriado(java.util.Date.from(dataAtual.atStartOfDay(ZoneId.systemDefault()).toInstant()));
            if (!ehFeriadoDiaUtil) {
                LocalDateTime fimPeriodo;
                LocalDateTime inicioDia = dataAtual.atTime(horaInicial.intValue(), 0);
                LocalDateTime fimDia = dataAtual.atTime(horaFinal.intValue(), 0);
                LocalDateTime inicioPeriodo = inicio.isAfter(inicioDia) ? inicio : inicioDia;
                LocalDateTime localDateTime = fimPeriodo = fim.isBefore(fimDia) ? fim : fimDia;
                if (!fimPeriodo.isBefore(inicioPeriodo)) {
                    java.time.Duration duracao = java.time.Duration.between(inicioPeriodo, fimPeriodo);
                    horasUteisEntreDatas += (double)duracao.toMinutes() / 60.0;
                }
            }
            dataAtual = dataAtual.plusDays(1L);
        }
        return horasUteisEntreDatas;
    }

    private static double calcularDifHorasUteis(LocalDateTime inicio, LocalDateTime fim, Double horaInicial, Double horaFinal) {
        double minutosUteis = 0.0;
        while (inicio != null && inicio.isBefore(fim)) {
            int hora = inicio.getHour();
            if ((double)hora >= horaInicial && (double)hora < horaFinal) {
                minutosUteis += 1.0;
            }
            inicio = inicio.plusMinutes(1L);
        }
        return minutosUteis / 60.0;
    }

    public static java.util.Date asDate(XMLGregorianCalendar data) {
        return data.toGregorianCalendar().getTime();
    }

    public static java.util.Date nextDateYear(java.util.Date dataNasc, int nrAnos) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(dataNasc);
        g.set(1, g.get(1) + nrAnos);
        return g.getTime();
    }

    public static String convertToTimeStr(double decimalTime) {
        int hours = (int)decimalTime;
        int minutes = (int)((decimalTime - (double)hours) * 60.0);
        return hours + ":" + minutes;
    }

    public static java.util.Date firstDayOfYear(Integer ano) {
        LocalDate primeiroDia = LocalDate.of((int)ano, 1, 1);
        return ToolDate.asDate(primeiroDia);
    }

    public static java.util.Date lastDayOfYear(Integer ano) {
        LocalDate primeiroDia = LocalDate.of((int)ano, 12, 31);
        return ToolDate.asDate(primeiroDia);
    }

    public static Double decimalToTime(double decimalHours) {
        int hours = (int)decimalHours;
        double minutes = (decimalHours - (double)hours) * 60.0 / 100.0;
        return ToolFormatter.arrredondarNumero((double)hours + minutes, 2);
    }

    public static Double timeToDecimal(double decimalHours) {
        int hours = (int)decimalHours;
        double minutes = (decimalHours - (double)hours) * 100.0 / 60.0;
        return ToolFormatter.arrredondarNumero((double)hours + minutes, 2);
    }

    public static java.util.Date getDateWeek(java.util.Date data, int semana) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        g.add(7, semana);
        return g.getTime();
    }

    public static java.util.Date toDate(OffsetDateTime input) {
        if (input == null) {
            return null;
        }
        return java.util.Date.from(input.toInstant());
    }

    public static java.util.Date getMaxDate() {
        return ToolDate.strToDate("31/12/2500");
    }
}

