/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.dtotransfer;

import com.touchcomp.basementorexceptions.exceptions.impl.reflection.EnumReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementortools.tools.dtotransfer.FieldPair;
import com.touchcomp.basementortools.tools.dtotransfer.ToolDTOBuilder;
import com.touchcomp.basementortools.tools.dtotransfer.annotations.DTOMethod;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

class BuilderDTO<T, S> {
    private ToolDTOBuilder<T, S> builder;
    private final String TO_STRING = "toString";

    public BuilderDTO(ToolDTOBuilder<T, S> builder) {
        this.builder = builder;
    }

    public S toDTO(T data) throws ExceptionReflection {
        try {
            Object ret = this.builder.dtoClass.newInstance();
            this.toDTO(ret, data, this.builder.fieldsPair);
            return ret;
        }
        catch (InstantiationException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionReflection(ex);
        }
    }

    private Object toDTO(Class type, Object data, List<FieldPair> pairs) throws ExceptionReflection {
        try {
            Object ret = type.newInstance();
            this.toDTO(ret, data, pairs);
            return ret;
        }
        catch (InstantiationException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionReflection(ex);
        }
    }

    private Object toDTO(Object dto, Object entity, List<FieldPair> pairs) throws ExceptionReflection {
        for (FieldPair f : pairs) {
            if (f.getFieldType() == ToolDTOBuilder.FIELD_TYPE.METHOD_FIELD_TO_STRING) {
                set = this.invockeGetMethod(f.getFieldEntity(), entity);
                if (set != null) {
                    set = this.invokeMethod(set, "toString");
                    this.invockeSetMethod(f.getFieldDTO(), dto, set);
                }
            } else if (f.getFieldType() == ToolDTOBuilder.FIELD_TYPE.METHOD_TO_STRING) {
                set = this.invokeMethod(entity, "toString");
                this.invockeSetMethod(f.getFieldDTO(), dto, set);
            } else if (f.getFieldType() == ToolDTOBuilder.FIELD_TYPE.METHOD_OBJ_PATH) {
                set = this.getObjectMethodPathToSet(f, dto, entity);
                this.invockeSetMethod(f.getFieldDTO(), dto, set);
            } else {
                set = this.invockeGetMethod(f.getFieldEntity(), entity);
                if (set != null) {
                    switch (f.getFieldType()) {
                        case PRIMITIVE: {
                            this.invockeSetMethod(f.getFieldDTO(), dto, set);
                            break;
                        }
                        case OBJECT_FIELD: {
                            set = this.invockeGetMethod(f.getFieldParentEntity(), set);
                            this.invockeSetMethod(f.getFieldDTO(), dto, set);
                            break;
                        }
                        case OBJECT: {
                            if (f.getIgnoreDTOBuilder()) break;
                            if (f.getFieldEntityType() == BigInteger.class) {
                                this.invockeSetMethod(f.getFieldDTO(), dto, set);
                                break;
                            }
                            set = this.toDTO(f.getFieldDTO().getPropertyType(), set, f.getChildren());
                            this.invockeSetMethod(f.getFieldDTO(), dto, set);
                            break;
                        }
                        case OBJECT_COLLECTION: {
                            if (f.getIgnoreDTOBuilder()) break;
                            Collection collections = (Collection)set;
                            try {
                                Collection nova = this.getInternalType(f.getFieldDTOCollectionType()).newInstance();
                                for (Object child : collections) {
                                    set = this.toDTO(f.getFieldDTOType(), child, f.getChildren());
                                    nova.add(set);
                                }
                                this.invockeSetMethod(f.getFieldDTO(), dto, nova);
                                break;
                            }
                            catch (InstantiationException ex) {
                                throw new ExceptionReflection(ex);
                            }
                            catch (IllegalAccessException ex) {
                                throw new ExceptionReflection(ex);
                            }
                        }
                    }
                }
            }
        }
        return dto;
    }

    private Class<? extends Collection> getInternalType(Class<? extends Collection> fieldDTOCollectionType) {
        if (List.class.isAssignableFrom(fieldDTOCollectionType)) {
            return LinkedList.class;
        }
        if (Set.class.isAssignableFrom(fieldDTOCollectionType)) {
            return HashSet.class;
        }
        return fieldDTOCollectionType;
    }

    private Object invockeGetMethod(PropertyDescriptor fieldEntity, Object entity) throws ExceptionReflection {
        try {
            if (fieldEntity == null || entity == null) {
                return null;
            }
            return fieldEntity.getReadMethod().invoke(entity, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            System.out.println("Error: GET " + String.valueOf(fieldEntity) + " Object: " + String.valueOf(entity));
            throw new ExceptionReflection(ex);
        }
        catch (IllegalArgumentException ex) {
            System.out.println("Error: GET " + String.valueOf(fieldEntity) + " Object: " + String.valueOf(entity));
            throw new ExceptionReflection(ex);
        }
        catch (InvocationTargetException ex) {
            System.out.println("Error: GET " + String.valueOf(fieldEntity) + " Object: " + String.valueOf(entity));
            throw new ExceptionReflection(ex);
        }
        catch (Exception ex) {
            System.out.println("Error: GET " + String.valueOf(fieldEntity) + " Object: " + String.valueOf(entity));
            throw new RuntimeException(ex);
        }
    }

    private void invockeSetMethod(PropertyDescriptor fieldDTO, Object invocke, Object set) throws ExceptionReflection {
        try {
            if (fieldDTO.getWriteMethod().getParameterCount() == 1 && fieldDTO.getWriteMethod().getParameterTypes()[0].equals(Long.class) && set instanceof Date) {
                set = ((Date)set).getTime();
            }
            fieldDTO.getWriteMethod().invoke(invocke, set);
        }
        catch (IllegalAccessException ex) {
            System.out.println("Error: DTO " + String.valueOf(fieldDTO) + " Object: " + String.valueOf(set));
            throw new ExceptionReflection(ex);
        }
        catch (IllegalArgumentException ex) {
            System.out.println("Error: DTO " + String.valueOf(fieldDTO) + " Object: " + String.valueOf(set));
            throw new ExceptionReflection(ex);
        }
        catch (InvocationTargetException ex) {
            System.out.println("Error: DTO " + String.valueOf(fieldDTO) + " Object: " + String.valueOf(set));
            throw new ExceptionReflection(ex);
        }
    }

    private Object getObjectMethodPathToSet(FieldPair f, Object dto, Object entity) throws ExceptionReflection {
        if (entity == null) {
            return null;
        }
        DTOMethod m = f.getMethodPath();
        StringTokenizer sk = new StringTokenizer(m.methodPath(), ".");
        while (sk.hasMoreTokens()) {
            try {
                String token = sk.nextToken();
                PropertyDescriptor prop = this.getProperty(token, entity);
                if (prop == null) {
                    throw new ExceptionReflection(EnumReflection.NO_SUCH_FIELD, new Object[]{"Propriedade nao encontrada " + token + " em " + String.valueOf(entity.getClass())});
                }
                entity = this.invockeGetMethod(prop, entity);
            }
            catch (IntrospectionException ex) {
                throw new ExceptionReflection(ex);
            }
            if (entity != null) continue;
            break;
        }
        return entity;
    }

    private PropertyDescriptor getProperty(String token, Object entity) throws IntrospectionException {
        PropertyDescriptor[] props;
        if (entity == null) {
            return null;
        }
        BeanInfo beanDTOType = Introspector.getBeanInfo(entity.getClass());
        for (PropertyDescriptor prop : props = beanDTOType.getPropertyDescriptors()) {
            if (!prop.getName().equals(token)) continue;
            return prop;
        }
        return null;
    }

    private Object invokeMethod(Object entity, String TO_STRING) throws ExceptionReflection {
        try {
            return entity.getClass().getMethod(TO_STRING, new Class[0]).invoke(entity, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            System.out.println("Error: DTO " + String.valueOf(entity));
            throw new ExceptionReflection(ex);
        }
        catch (SecurityException ex) {
            System.out.println("Error: toString " + String.valueOf(entity));
            throw new ExceptionReflection(ex);
        }
        catch (IllegalAccessException ex) {
            System.out.println("Error: toString " + String.valueOf(entity));
            throw new ExceptionReflection(ex);
        }
        catch (IllegalArgumentException ex) {
            System.out.println("Error: toString " + String.valueOf(entity));
            throw new ExceptionReflection(ex);
        }
        catch (InvocationTargetException ex) {
            System.out.println("Error: toString " + String.valueOf(entity));
            throw new ExceptionReflection(ex);
        }
    }
}

