/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.dtotransfer;

import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementortools.tools.dtotransfer.BuilderDTO;
import com.touchcomp.basementortools.tools.dtotransfer.BuilderEntity;
import com.touchcomp.basementortools.tools.dtotransfer.FieldPair;
import com.touchcomp.basementortools.tools.dtotransfer.annotations.DTOFieldToString;
import com.touchcomp.basementortools.tools.dtotransfer.annotations.DTOIgnoreBuilder;
import com.touchcomp.basementortools.tools.dtotransfer.annotations.DTOIgnoreField;
import com.touchcomp.basementortools.tools.dtotransfer.annotations.DTOMethod;
import com.touchcomp.basementortools.tools.dtotransfer.annotations.DTOOnlyView;
import com.touchcomp.basementortools.tools.dtotransfer.annotations.DTOToString;
import com.touchcomp.basementortools.tools.dtotransfer.conversor.DTOEntityConversor;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ToolDTOBuilder<T, S> {
    protected final Class<S> dtoClass;
    protected final Class<T> entityClass;
    protected List<FieldPair> fieldsPair = new LinkedList<FieldPair>();
    protected List<FieldPair> allFieldsPair = new LinkedList<FieldPair>();
    protected BuilderDTO<T, S> builderDTO = new BuilderDTO(this);
    protected BuilderEntity<T, S> builderEntity = new BuilderEntity(this);
    protected Set<DTOEntityConversor<T, S>> conversors = new HashSet<DTOEntityConversor<T, S>>();

    public ToolDTOBuilder(Class entityClass, Class dtoClass) throws ExceptionReflection {
        this.dtoClass = dtoClass;
        this.entityClass = entityClass;
        this.builderPairs();
    }

    public ToolDTOBuilder(Class entityClass, Class dtoClass, DTOEntityConversor<T, S> conversor) throws ExceptionReflection {
        this(dtoClass, entityClass);
        this.conversors.add(conversor);
    }

    public ToolDTOBuilder(Class entityClass, Class dtoClass, boolean convertEntities) throws ExceptionReflection {
        this.dtoClass = dtoClass;
        this.entityClass = entityClass;
        this.builderPairs();
        this.builderEntity.setConvertFindEntities(convertEntities);
    }

    public ToolDTOBuilder(Class entityClass, Class dtoClass, DTOEntityConversor<T, S> conversor, boolean convertEntities) throws ExceptionReflection {
        this(dtoClass, entityClass, convertEntities);
        this.conversors.add(conversor);
    }

    public void setConvertEntities(boolean convertToEntities) {
        this.builderEntity.setConvertFindEntities(convertToEntities);
    }

    private void builderPairs() throws ExceptionReflection {
        try {
            BeanInfo bInfoEnt = Introspector.getBeanInfo(this.entityClass);
            BeanInfo bInfoDto = Introspector.getBeanInfo(this.dtoClass);
            this.fieldsPair = this.buildPairs(bInfoDto, bInfoEnt, new LinkedList<FieldPair>());
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(ToolDTOBuilder.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionReflection(ex);
        }
    }

    private List<FieldPair> buildPairs(BeanInfo dto, BeanInfo fieldsEnt, List<FieldPair> parent) throws ExceptionReflection, IntrospectionException {
        LinkedList<FieldPair> buildPairs = new LinkedList<FieldPair>();
        for (PropertyDescriptor fDTO : this.getPropertyDescriptor(dto.getPropertyDescriptors())) {
            this.processField(fDTO, dto, fieldsEnt, buildPairs, parent);
        }
        return buildPairs;
    }

    private boolean buildPrimitiveType(PropertyDescriptor fieldDTO, BeanInfo fieldsEntity, List<FieldPair> buildPairs, boolean onlyView) throws IntrospectionException {
        PropertyDescriptor fieldEntity = this.filter(fieldsEntity.getPropertyDescriptors(), fieldDTO);
        if (fieldEntity != null) {
            this.addToFields(new FieldPair(FIELD_TYPE.PRIMITIVE, fieldEntity, fieldDTO, fieldEntity.getPropertyType(), fieldDTO.getPropertyType(), onlyView), buildPairs);
            return true;
        }
        return this.deepFilter(fieldDTO, fieldsEntity, buildPairs, onlyView);
    }

    private boolean deepFilter(PropertyDescriptor fieldDTO, BeanInfo fieldsEntity, List<FieldPair> buildPairs, boolean onlyView) throws IntrospectionException {
        String name = fieldDTO.getName();
        for (PropertyDescriptor ppEnt : fieldsEntity.getPropertyDescriptors()) {
            if (!name.startsWith(ppEnt.getName()) || ToolReflections.isPrimitiveOrArray(ppEnt.getPropertyType())) continue;
            BeanInfo bean = Introspector.getBeanInfo(ppEnt.getPropertyType());
            for (PropertyDescriptor ppEntField : bean.getPropertyDescriptors()) {
                if (!name.toLowerCase().endsWith(ppEntField.getName().toLowerCase()) || !name.equalsIgnoreCase(ppEnt.getName() + ppEntField.getName())) continue;
                this.addToFields(new FieldPair(FIELD_TYPE.OBJECT_FIELD, ppEnt, ppEntField, fieldDTO, ppEnt.getPropertyType(), fieldDTO.getPropertyType(), onlyView), buildPairs);
                return true;
            }
        }
        return false;
    }

    private boolean buildCollection(PropertyDescriptor fieldDTO, BeanInfo fieldsEntity, List<FieldPair> buildPairs, List<FieldPair> buildPairsParent, boolean ignoreDTOBuilder) throws ExceptionReflection {
        PropertyDescriptor fieldEntity = this.filter(fieldsEntity.getPropertyDescriptors(), fieldDTO);
        if (fieldEntity == null) {
            return false;
        }
        if (this.existsPair(fieldDTO, fieldEntity, buildPairsParent)) {
            return false;
        }
        try {
            ParameterizedType parameterizedDTO = (ParameterizedType)fieldDTO.getReadMethod().getGenericReturnType();
            Class typeDTO = (Class)parameterizedDTO.getActualTypeArguments()[0];
            ParameterizedType parameterizedEntity = (ParameterizedType)fieldEntity.getReadMethod().getGenericReturnType();
            Class typeEntity = (Class)parameterizedEntity.getActualTypeArguments()[0];
            BeanInfo beanDTO = Introspector.getBeanInfo(typeDTO);
            BeanInfo beanEntity = Introspector.getBeanInfo(typeEntity);
            FieldPair fp = new FieldPair(FIELD_TYPE.OBJECT_COLLECTION, fieldEntity, fieldDTO, new LinkedList<FieldPair>(), typeEntity, typeDTO, ignoreDTOBuilder);
            fp.setFieldDTOCollectionType((Class)parameterizedDTO.getRawType());
            fp.setFieldDTOCollectionType((Class)parameterizedEntity.getRawType());
            this.addToFields(fp, buildPairs);
            fp.setChildren(this.buildPairs(beanDTO, beanEntity, buildPairs));
            return true;
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(ToolDTOBuilder.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionReflection(ex);
        }
    }

    private void processField(PropertyDescriptor fieldDTO, BeanInfo dto, BeanInfo fieldsEntity, List<FieldPair> buildPairs, List<FieldPair> buildPairsParent) throws ExceptionReflection, IntrospectionException {
        PropertyDescriptor fieldEntity;
        Class<?> fieldDTOType = fieldDTO.getPropertyType();
        BeanInfo beanDTOType = Introspector.getBeanInfo(fieldDTOType);
        boolean isPrimitive = ToolReflections.isPrimitiveOrArray(fieldDTOType);
        boolean isCollection = this.isCollection(fieldDTOType);
        DTOMethod methodPath = (DTOMethod)this.getAnnotation(fieldDTO, dto, DTOMethod.class);
        if (!this.isProcessField(dto.getBeanDescriptor().getBeanClass(), fieldDTO)) {
            return;
        }
        if (methodPath != null) {
            this.buildPathMethod(fieldDTO, fieldsEntity, buildPairs, methodPath);
            return;
        }
        if (this.getAnnotation(fieldDTO, dto, DTOToString.class) != null) {
            this.addToFields(new FieldPair(FIELD_TYPE.METHOD_TO_STRING, fieldDTO), buildPairs);
            return;
        }
        if (this.getAnnotation(fieldDTO, dto, DTOFieldToString.class) != null) {
            PropertyDescriptor fieldEntity2 = this.filter(fieldsEntity.getPropertyDescriptors(), fieldDTO);
            this.addToFields(new FieldPair(FIELD_TYPE.METHOD_FIELD_TO_STRING, fieldEntity2, fieldDTO), buildPairs);
            return;
        }
        if (isPrimitive) {
            boolean onlyView;
            boolean bl = onlyView = this.getAnnotation(fieldDTO, dto, DTOOnlyView.class) != null;
            if (this.buildPrimitiveType(fieldDTO, fieldsEntity, buildPairs, onlyView)) {
                return;
            }
        }
        if (isCollection) {
            boolean ignoreDTOBuilder;
            boolean bl = ignoreDTOBuilder = this.getAnnotation(fieldDTO, dto, DTOIgnoreBuilder.class) != null;
            if (this.buildCollection(fieldDTO, fieldsEntity, buildPairs, buildPairsParent, ignoreDTOBuilder)) {
                return;
            }
        }
        if ((fieldEntity = this.filter(fieldsEntity.getPropertyDescriptors(), fieldDTO)) != null && !this.existsPair(fieldDTO, fieldEntity, buildPairsParent)) {
            boolean ignoreDTOBuilder = this.getAnnotation(fieldDTO, dto, DTOIgnoreBuilder.class) != null;
            BeanInfo bean2 = Introspector.getBeanInfo(fieldEntity.getPropertyType());
            this.addToFields(new FieldPair(FIELD_TYPE.OBJECT, fieldEntity, fieldDTO, this.buildPairs(beanDTOType, bean2, buildPairs), fieldEntity.getPropertyType(), fieldDTO.getPropertyType(), ignoreDTOBuilder), buildPairs);
        }
    }

    private void addToFields(FieldPair fieldPair, List<FieldPair> buildPairs) {
        buildPairs.add(fieldPair);
        this.allFieldsPair.add(fieldPair);
    }

    private PropertyDescriptor filter(PropertyDescriptor[] fieldsList, PropertyDescriptor fEnt) {
        for (PropertyDescriptor field : fieldsList) {
            if (!Objects.equals(fEnt.getName(), field.getName())) continue;
            return field;
        }
        return null;
    }

    private boolean isCollection(Class fieldEntityType) {
        return Collection.class.isAssignableFrom(fieldEntityType);
    }

    public List<FieldPair> getFieldsPair() {
        return this.fieldsPair;
    }

    public S toDTO(T data) throws ExceptionReflection {
        return this.builderDTO.toDTO(data);
    }

    public List<S> toDTO(List<T> data) throws ExceptionReflection {
        LinkedList<S> aux = new LinkedList<S>();
        for (T t : data) {
            aux.add(this.builderDTO.toDTO(t));
        }
        return aux;
    }

    public T toEntity(S data) throws ExceptionReflection {
        return this.builderEntity.toEntity(data);
    }

    public List<T> toEntity(List<S> data) throws ExceptionReflection {
        LinkedList<T> a = new LinkedList<T>();
        for (S s : data) {
            a.add(this.builderEntity.toEntity(s));
        }
        return a;
    }

    public T toEntity(S data, T base) throws ExceptionReflection {
        return this.builderEntity.toEntity(base, data);
    }

    public void addDTOConverter(DTOEntityConversor ... conversor) {
        for (DTOEntityConversor aux : conversor) {
            this.conversors.add(aux);
        }
    }

    public void addDTOConverter(DTOEntityConversor conversor) {
        if (conversor != null) {
            this.conversors.add(conversor);
        }
    }

    public boolean removeDTOConverter(DTOEntityConversor conversor) {
        return this.conversors.remove(conversor);
    }

    private List<PropertyDescriptor> getPropertyDescriptor(PropertyDescriptor[] propertyDescriptors) {
        LinkedList<PropertyDescriptor> filter = new LinkedList<PropertyDescriptor>();
        for (PropertyDescriptor pp : propertyDescriptors) {
            if (pp.getName().equalsIgnoreCase("class")) continue;
            filter.add(pp);
        }
        return filter;
    }

    private boolean isProcessField(Class parent, PropertyDescriptor beanDTOType) {
        boolean temp;
        boolean bl = temp = beanDTOType.getReadMethod().getAnnotation(DTOIgnoreField.class) == null;
        if (!temp) {
            return temp;
        }
        String name = ToolReflections.getFieldName(beanDTOType.getReadMethod());
        Field f = ToolReflections.getField(parent, name);
        if (f == null) {
            return false;
        }
        temp = f.getAnnotation(DTOIgnoreField.class) == null;
        return temp;
    }

    private <A> A getAnnotation(PropertyDescriptor fieldDTO, BeanInfo dto, Class aClass) {
        Annotation[] ret;
        for (Annotation an : ret = fieldDTO.getReadMethod().getAnnotationsByType(aClass)) {
            if (!Objects.equals(an.annotationType(), aClass)) continue;
            return (A)an;
        }
        Class<?> bean = dto.getBeanDescriptor().getBeanClass();
        for (Field field : bean.getDeclaredFields()) {
            if (field.getAnnotation(aClass) == null || !Objects.equals(fieldDTO.getName(), field.getName())) continue;
            return (A)field.getAnnotation(aClass);
        }
        return null;
    }

    private void buildPathMethod(PropertyDescriptor fieldDTO, BeanInfo fieldsEntity, List<FieldPair> buildPairs, DTOMethod methodPath) {
        this.addToFields(new FieldPair(FIELD_TYPE.METHOD_OBJ_PATH, fieldDTO, methodPath), buildPairs);
    }

    private boolean existsPair(PropertyDescriptor fieldDTO, PropertyDescriptor fieldEntity, List<FieldPair> buildPairsParent) {
        Optional<FieldPair> found = buildPairsParent.stream().filter(i -> i.getFieldDTO().equals(fieldDTO) && i.getFieldEntity().equals(fieldEntity)).findFirst();
        return found.isPresent();
    }

    static enum FIELD_TYPE {
        PRIMITIVE,
        OBJECT,
        OBJECT_FIELD,
        OBJECT_COLLECTION,
        METHOD_TO_STRING,
        METHOD_FIELD_TO_STRING,
        METHOD_OBJ_PATH,
        IGNORE_ACCESS_BUILDER_DTO;

    }
}

