/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.excel.impl.read;

import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementortools.tools.excel.model.ExcelCellType;
import com.touchcomp.basementortools.tools.excel.model.ExcelSheet;
import com.touchcomp.basementortools.tools.excel.model.ExcelType;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelXLSXRead {
    private InputStream inputStream;
    private ExcelType type;
    private int startLine = 0;
    private NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    public static final int START_LINE_DEFAULT = 0;
    private int endLine;

    public ExcelXLSXRead(InputStream inputStream, ExcelType type) {
        this.inputStream = inputStream;
        this.type = type;
    }

    public ExcelXLSXRead(InputStream inputStream, ExcelType type, int startLine, int endLine) {
        this.inputStream = inputStream;
        this.type = type;
        this.startLine = startLine;
        this.endLine = endLine;
    }

    public ExcelXLSXRead(File file) throws FileNotFoundException {
        this.type = file.getName().toLowerCase().endsWith(ExcelType.XLS.getFileExt()) ? ExcelType.XLS : ExcelType.XLSX;
        this.inputStream = new FileInputStream(file);
    }

    public ExcelXLSXRead(String file) throws FileNotFoundException {
        this(new File(file));
    }

    public ExcelSheet read() throws IOException {
        Workbook workbook = this.getWorkBook();
        Sheet datatypeSheet = workbook.getSheetAt(0);
        ExcelSheet ex = new ExcelSheet();
        ex.setName(datatypeSheet.getSheetName());
        this.setRows(datatypeSheet, ex);
        return ex;
    }

    private void setRows(Sheet datatypeSheet, ExcelSheet ex) {
        Iterator iterator = datatypeSheet.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Row currentRow = (Row)iterator.next();
            if (this.endLine > 0 && index >= this.endLine) break;
            if (index >= this.startLine) {
                ExcelSheet.Row row = ex.newRow(currentRow.getRowNum());
                this.setCells(currentRow, row);
            }
            ++index;
        }
    }

    private void setCells(Row currentRow, ExcelSheet.Row row) {
        int nrCells = currentRow.getLastCellNum();
        for (int i = 0; i < nrCells; ++i) {
            Cell currentCell = currentRow.getCell(i);
            ExcelSheet.Cell cell = row.newCell(i);
            if (currentCell != null) {
                this.readAndSetByType(currentRow, currentCell, cell, currentCell.getCellTypeEnum());
                continue;
            }
            cell.setData("");
            cell.setType(ExcelCellType.STRING);
        }
    }

    private void readAndSetByType(Row currentRow, Cell currentCell, ExcelSheet.Cell cell, CellType cellTypeEnum) {
        switch (cellTypeEnum) {
            case BLANK: {
                cell.setData("");
                cell.setType(ExcelCellType.STRING);
                break;
            }
            case BOOLEAN: {
                cell.setData(String.valueOf(currentCell.getBooleanCellValue()));
                cell.setType(ExcelCellType.BOOLEAN);
                break;
            }
            case ERROR: {
                cell.setData("");
                cell.setType(ExcelCellType.ERROR);
                break;
            }
            case FORMULA: {
                this.readAndSetByType(currentRow, currentCell, cell, currentCell.getCachedFormulaResultTypeEnum());
                break;
            }
            case NUMERIC: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)currentCell)) {
                    Date date = HSSFDateUtil.getJavaDate((double)currentCell.getNumericCellValue());
                    cell.setDate(date);
                    cell.setType(ExcelCellType.DATE);
                    break;
                }
                Double nr = currentCell.getNumericCellValue();
                if (nr != null) {
                    if (nr - (double)nr.longValue() == 0.0) {
                        cell.setData(String.valueOf(nr.longValue()));
                    } else {
                        cell.setData(String.format("%." + ToolNumber.countDecimalPlaces(nr) + "f", nr));
                    }
                }
                cell.setType(ExcelCellType.NUMERIC);
                break;
            }
            case STRING: {
                cell.setData(currentCell.getStringCellValue());
                cell.setType(ExcelCellType.STRING);
                break;
            }
            default: {
                throw new ExceptionErroProgramacao("Tipo de dado na celula nao identificado " + currentRow.getRowNum() + currentCell.getRowIndex());
            }
        }
    }

    private Workbook getWorkBook() throws IOException {
        if (this.type == ExcelType.XLS) {
            return new HSSFWorkbook(this.inputStream);
        }
        return new XSSFWorkbook(this.inputStream);
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setStartLine(int startLine) {
        this.startLine = startLine;
    }
}

