/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.jdom;

import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionInvalidXML;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionJDom;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ToolJdom {
    public static Element getRootElement(String xml) throws ExceptionJDom {
        return ToolJdom.getRootElement(xml, EnumToolJdomEncoding.ISO_8889_1);
    }

    public static Document getDocument(String xml) throws ExceptionJDom {
        return ToolJdom.getDocument(xml, EnumToolJdomEncoding.ISO_8889_1);
    }

    public static Document getDocument(String xmlContent, EnumToolJdomEncoding encoding) throws ExceptionJDom {
        try {
            Document d;
            InputStreamReader reader;
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlContent.getBytes());){
                reader = new InputStreamReader((InputStream)inputStream, encoding.value);
                InputSource is = new InputSource(reader);
                is.setEncoding(encoding.value);
                d = new SAXBuilder().build(is);
            }
            ((Reader)reader).close();
            return d;
        }
        catch (JDOMException ex) {
            TLogger.get(ToolJdom.class).error((Throwable)ex);
            throw new ExceptionJDom(ex);
        }
        catch (IOException ex) {
            TLogger.get(ToolJdom.class).error((Throwable)ex);
            throw new ExceptionJDom(ex, "Text/XML: " + ex.getMessage());
        }
    }

    public static Document getDocumentWithRecovery(String xmlContent) throws ExceptionJDom {
        try {
            return ToolJdom.getDocument(xmlContent);
        }
        catch (ExceptionJDom ex) {
            TLogger.get(ToolJdom.class).error((Throwable)ex);
            try {
                return ToolJdom.getDocument(xmlContent, EnumToolJdomEncoding.ISO_8889_1);
            }
            catch (ExceptionJDom ex2) {
                TLogger.get(ToolJdom.class).error((Throwable)ex2);
                try {
                    xmlContent = ToolString.clearInvalidUTF8Char(xmlContent);
                    return ToolJdom.getDocument(xmlContent, EnumToolJdomEncoding.ISO_8889_1);
                }
                catch (ExceptionJDom ex3) {
                    TLogger.get(ToolJdom.class).error((Throwable)ex3);
                    try {
                        xmlContent = ToolString.removeIllegalXMLChar(xmlContent);
                        return ToolJdom.getDocument(xmlContent, EnumToolJdomEncoding.ISO_8889_1);
                    }
                    catch (ExceptionJDom ex4) {
                        TLogger.get(ToolJdom.class).error((Throwable)ex4);
                        throw ex4;
                    }
                }
            }
        }
    }

    public static Document getDocumentWithRecovery(File f) throws ExceptionJDom, ExceptionIO {
        try {
            String xmlContent = ToolFile.getConteudoArquivo(f);
            return ToolJdom.getDocumentWithRecovery(xmlContent);
        }
        catch (ExceptionIO ex) {
            TLogger.get(ToolJdom.class).error((Throwable)ex);
            throw new ExceptionIO((Exception)((Object)ex), new Object[0]);
        }
    }

    public static Element getRootElement(File xml) throws ExceptionJDom {
        return ToolJdom.getRootElement(xml, EnumToolJdomEncoding.ISO_8889_1);
    }

    public static Element getRootElement(File xml, EnumToolJdomEncoding encoding) throws ExceptionJDom {
        try {
            FileInputStream inputStream = new FileInputStream(xml);
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, encoding.value);
            InputSource is = new InputSource(reader);
            is.setEncoding(encoding.value);
            Document d = new SAXBuilder().build(is);
            ((InputStream)inputStream).close();
            ((Reader)reader).close();
            return d.getRootElement();
        }
        catch (JDOMException ex) {
            ex.printStackTrace();
            throw new ExceptionJDom(ex);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new ExceptionJDom(ex, "Text/XML: " + ex.getMessage());
        }
    }

    public static Element getRootElement(String xml, EnumToolJdomEncoding encoding) throws ExceptionJDom {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes());
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, encoding.value);
            InputSource is = new InputSource(reader);
            is.setEncoding(encoding.value);
            Document d = new SAXBuilder().build(is);
            ((InputStream)inputStream).close();
            ((Reader)reader).close();
            return d.getRootElement();
        }
        catch (JDOMException ex) {
            ex.printStackTrace();
            throw new ExceptionJDom(ex);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new ExceptionJDom(ex, "Text/XML: " + ex.getMessage());
        }
    }

    public static void validateXMLAgaintsSchema(String xml, InputStream xsd) throws ExceptionJDom, ExceptionInvalidXML {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(new StreamSource(xsd));
            Validator validator = schema.newValidator();
            StreamSource xmlFile = new StreamSource(new ByteArrayInputStream(xml.getBytes()));
            final LinkedList exceptions = new LinkedList();
            validator.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    exceptions.add(exception);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    exceptions.add(exception);
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    exceptions.add(exception);
                }
            });
            validator.validate(xmlFile);
            System.out.println("XML succesfully validated.");
            if (exceptions.size() > 0) {
                throw new ExceptionInvalidXML(exceptions, xml);
            }
        }
        catch (SAXException ex) {
            throw new ExceptionJDom(ex);
        }
        catch (IOException ex) {
            throw new ExceptionJDom(ex, "Text/XML: " + ex.getMessage());
        }
    }

    public static String toXml(Element evento) {
        XMLOutputter outputter = new XMLOutputter();
        String xmlString = outputter.outputString(evento);
        return xmlString;
    }

    public static String getContent(Element element, String pathToElement, Namespace namespace) {
        if (element == null) {
            return null;
        }
        int index = pathToElement.indexOf(".");
        if (index > 0) {
            String elementName = pathToElement.substring(0, index);
            pathToElement = pathToElement.substring(index + 1);
            Element child = element.getChild(elementName, namespace);
            if (child == null && element.getName().equals(elementName)) {
                child = element;
            }
            return ToolJdom.getContent(child, pathToElement, namespace);
        }
        if (element.getName().equalsIgnoreCase(pathToElement)) {
            return element.getText();
        }
        Element child = element.getChild(pathToElement, namespace);
        if (child != null && child.getName().equalsIgnoreCase(pathToElement)) {
            return child.getText();
        }
        return null;
    }

    public static List<String> getContents(List<Element> elements, String pathToElement, Namespace namespace) {
        int index = pathToElement.indexOf(".");
        if (index > 0) {
            String elementName = pathToElement.substring(0, index);
            pathToElement = pathToElement.substring(index + 1);
            LinkedList<Element> found = new LinkedList<Element>();
            for (Element element : elements) {
                LinkedList<Element> children = element.getChildren(elementName, namespace);
                if (children == null || children.isEmpty()) {
                    children = new LinkedList<Element>();
                    for (Element aux : elements) {
                        if (!aux.getName().equalsIgnoreCase(elementName)) continue;
                        children.add(aux);
                    }
                }
                found.addAll(children);
            }
            return ToolJdom.getContents(found, pathToElement, namespace);
        }
        LinkedList<String> found = new LinkedList<String>();
        for (Element element : elements) {
            if (!(element = element.getChild(pathToElement, namespace)).getName().equalsIgnoreCase(pathToElement)) continue;
            found.add(element.getText());
        }
        return found;
    }

    public static List<String> getContents(List<Element> elements, String pathToElement) {
        return ToolJdom.getContents(elements, pathToElement, Namespace.XML_NAMESPACE);
    }

    public static String getContent(Element element, String pathToElement) {
        return ToolJdom.getContent(element, pathToElement, Namespace.XML_NAMESPACE);
    }

    public static List<String> getContents(Element first, String path) {
        return ToolJdom.getContents(Arrays.asList(first), path, Namespace.XML_NAMESPACE);
    }

    public static List<String> getContents(Element first, String path, Namespace nameSpace) {
        return ToolJdom.getContents(Arrays.asList(first), path, nameSpace);
    }

    public static Document getDocument(File localXmlERP) throws ExceptionJDom {
        try {
            Document d = new SAXBuilder().build(localXmlERP);
            return d;
        }
        catch (JDOMException ex) {
            throw new ExceptionJDom(ex);
        }
        catch (IOException ex) {
            throw new ExceptionJDom(ex, "Text/XML: " + ex.getMessage());
        }
    }

    public static void writeXMLPretty(Document doc, File dest) throws ExceptionJDom {
        ToolJdom.writeXMLPretty(doc, dest, null);
    }

    public static void writeXMLPretty(Document doc, File dest, String enconding) throws ExceptionJDom {
        try {
            Format format = Format.getPrettyFormat();
            if (TMethods.isStrWithData(enconding)) {
                format.setEncoding(enconding);
            }
            XMLOutputter out = new XMLOutputter(format);
            out.output(doc, (OutputStream)new FileOutputStream(dest));
        }
        catch (IOException ex) {
            throw new ExceptionJDom(ex, "Text/XML: " + ex.getMessage());
        }
    }

    public static void writeXML(Document doc, File dest, String enconding) throws ExceptionJDom {
        try {
            Format format = Format.getRawFormat();
            if (TMethods.isStrWithData(enconding)) {
                format.setEncoding(enconding);
            }
            XMLOutputter out = new XMLOutputter(format);
            out.output(doc, (OutputStream)new FileOutputStream(dest));
        }
        catch (IOException ex) {
            throw new ExceptionJDom(ex, "Text/XML: " + ex.getMessage());
        }
    }

    public static String getXML(Document doc, String enconding) throws ExceptionJDom {
        try {
            Format format = Format.getRawFormat();
            if (TMethods.isStrWithData(enconding)) {
                format.setEncoding(enconding);
            }
            StringWriter stringWriter = new StringWriter();
            XMLOutputter out = new XMLOutputter(format);
            out.output(doc, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (IOException ex) {
            throw new ExceptionJDom(ex, "Text/XML: " + ex.getMessage());
        }
    }

    public static enum EnumToolJdomEncoding {
        ISO_8889_1("ISO-8859-1"),
        UTF_8("UTF-8");

        private final String value;

        private EnumToolJdomEncoding(String value) {
            this.value = value;
        }
    }
}

