/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.methods;

import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class ToolMethods {
    public static boolean isEquals(Object ob1, Object ob2) {
        return Objects.equals(ob1, ob2);
    }

    public static boolean isEqualsNumber(Number ob1, Number ob2) {
        if (ob1 == null || ob2 == null) {
            return Objects.equals(ob1, ob2);
        }
        return ob1.doubleValue() == ob2.doubleValue();
    }

    public static boolean isEqualsNumber(Number ob1, Number ob2, int dec) {
        if (ob1 == null || ob2 == null) {
            return Objects.equals(ob1, ob2);
        }
        return ToolFormatter.arrredondarNumero(ob1.doubleValue() - ob2.doubleValue(), dec) == 0.0;
    }

    public static boolean isEqualsIgnoreCase(String str1, String str2) {
        return String.valueOf(str1).equalsIgnoreCase(String.valueOf(str2));
    }

    public static String toString(List add, String separator) {
        if (add == null) {
            return null;
        }
        return ToolMethods.toString(add.toArray(), separator);
    }

    public static String toString(List add) {
        return ToolMethods.toString(add, "\n");
    }

    public static List toList(Object ... add) {
        LinkedList<Object> ret = new LinkedList<Object>();
        for (Object ob : add) {
            ret.add(ob);
        }
        return ret;
    }

    public static <T> List<T> toListT(T ... add) {
        LinkedList<T> ret = new LinkedList<T>();
        for (T ob : add) {
            ret.add(ob);
        }
        return ret;
    }

    public static List toListArray(Object[] add) {
        LinkedList<Object> ret = new LinkedList<Object>();
        for (Object ob : add) {
            ret.add(ob);
        }
        return ret;
    }

    public static String toString(Object[] add, String separator) {
        if (add == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object object : add) {
            sb.append(String.valueOf(object));
            sb.append(separator);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String toString(Object[] add) {
        return ToolMethods.toString(add, "\n");
    }

    public static boolean isStrWithData(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isStringBuilderWithData(StringBuilder str) {
        return str != null && ToolMethods.isStrWithData(str.toString());
    }

    public static boolean isStrWithDataLengthGe(String str, int length) {
        return ToolMethods.isStrWithData(str) && str.length() >= length;
    }

    public static boolean isStrWithDataLengthG(String str, int length) {
        return ToolMethods.isStrWithData(str) && str.length() > length;
    }

    public static boolean isStrWithDataLengthLe(String str, int length) {
        return ToolMethods.isStrWithData(str) && str.length() <= length;
    }

    public static boolean isStrWithDataLengthL(String str, int length) {
        return ToolMethods.isStrWithData(str) && str.length() < length;
    }

    public static boolean containsInArray(Object[] profiles, Object test) {
        if (profiles == null || profiles.length == 0) {
            return false;
        }
        for (Object profile : profiles) {
            if (!ToolMethods.isEquals(profile, test)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsInArray(String[] profiles, String test, boolean ignoreCase) {
        if (profiles == null || profiles.length == 0) {
            return false;
        }
        for (String profile : profiles) {
            if (ignoreCase && ToolMethods.isEquals((Object)String.valueOf(profile).toLowerCase(), (Object)String.valueOf(test).toLowerCase())) {
                return true;
            }
            if (!ToolMethods.isEquals((Object)String.valueOf(profile), (Object)String.valueOf(test))) continue;
            return true;
        }
        return false;
    }

    public static boolean isStrWithDataLength(String str, int length) {
        return ToolMethods.isStrWithData(str) && str.length() == length;
    }

    public static boolean isStrWithDataLengthAtLeast(String str, int length) {
        return ToolMethods.isStrWithData(str) && str.length() >= length;
    }

    public static boolean isWithData(Number numero) {
        boolean isValid = numero != null;
        Double num = isValid ? numero.doubleValue() : 0.0;
        return isValid && num > 0.0 && !num.isInfinite();
    }

    public static boolean isWithData(Collection lista) {
        return lista != null && lista.size() > 0;
    }

    public static boolean isAffirmative(Number data) {
        if (data == null) {
            return false;
        }
        return data.intValue() >= 1;
    }

    public static boolean isAffirmative(String data) {
        if (data == null || !ToolMethods.isStrWithData(ToolString.onlyNumbers(data))) {
            return false;
        }
        return Long.parseLong(ToolString.onlyNumbers(data)) >= 1L;
    }

    public static boolean isNegative(Number data) {
        if (data == null) {
            return false;
        }
        return data.intValue() == 0;
    }

    public static <E> List<E>[] splitList(List<E> fullList, int maxSizeSubList) {
        LinkedList<LinkedList<E>> chunks = new LinkedList<LinkedList<E>>();
        int size = fullList.size();
        for (int i = 0; i < size; i += maxSizeSubList) {
            int end = Math.min(size, i + maxSizeSubList);
            chunks.add(new LinkedList<E>(fullList.subList(i, end)));
        }
        return (List[])chunks.toArray(LinkedList[]::new);
    }

    public static <E> List<E>[] splitListNumberOfSubLists(List<E> fullList, int numberOfLists) {
        LinkedList<LinkedList<E>> chunks = new LinkedList<LinkedList<E>>();
        int totalSize = fullList.size();
        int baseChunkSize = totalSize / numberOfLists;
        int remainder = totalSize % numberOfLists;
        int start = 0;
        for (int i = 0; i < numberOfLists; ++i) {
            int extra = i < remainder ? 1 : 0;
            int end = start + baseChunkSize + extra;
            chunks.add(new LinkedList<E>(fullList.subList(start, Math.min(end, totalSize))));
            start = end;
        }
        return (List[])chunks.toArray(LinkedList[]::new);
    }

    public static String emptyIfNull(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static Boolean isNull(Object o) {
        if (o == null) {
            return true;
        }
        return false;
    }

    public static Boolean isNotNull(Object o) {
        if (o != null) {
            return true;
        }
        return false;
    }

    public static Double isNulThen0(Number o) {
        if (o == null) {
            return 0.0;
        }
        return o.doubleValue();
    }

    public static Short isNulThen0(Short o) {
        if (o == null) {
            return (short)0;
        }
        return o;
    }

    public static Long isNulThen0(Long o) {
        if (o == null) {
            return 0L;
        }
        return o;
    }

    public static Integer isNulThen0(Integer o) {
        if (o == null) {
            return 0;
        }
        return o;
    }

    public static <T extends Number> T isNulThen0(Number o, Class<T> returnType) {
        return ToolMethods.isNulThen(o, 0.0, returnType);
    }

    public static <T extends Number> T isNulThen(Number o, Number other, Class<T> returnType) {
        Number temp = other;
        if (o != null) {
            temp = o;
        }
        if (temp == null) {
            temp = 0.0;
        }
        if (returnType.equals(Short.class)) {
            return (T)Short.valueOf(temp.shortValue());
        }
        if (returnType.equals(Integer.class)) {
            return (T)Integer.valueOf(temp.intValue());
        }
        if (returnType.equals(Long.class)) {
            return (T)Long.valueOf(temp.longValue());
        }
        if (returnType.equals(Float.class)) {
            return (T)Float.valueOf(temp.floatValue());
        }
        return (T)((Double)o);
    }

    public static Short isNulThen(Number o, Short other) {
        if (o == null) {
            if (other == null) {
                other = 0;
            }
            return other;
        }
        return o.shortValue();
    }

    public static Double isNulThen(Number o, Double other) {
        if (o == null) {
            if (other == null) {
                other = 0.0;
            }
            return other;
        }
        return o.doubleValue();
    }

    public static Float isNulThen(Number o, Float other) {
        if (o == null) {
            if (other == null) {
                other = Float.valueOf(0.0f);
            }
            return other;
        }
        return Float.valueOf(o.floatValue());
    }

    public static Integer isNulThen(Number o, Integer other) {
        if (o == null) {
            if (other == null) {
                other = 0;
            }
            return other;
        }
        return o.intValue();
    }

    public static Long isNulThen(Number o, Long other) {
        if (o == null) {
            if (other == null) {
                other = 0L;
            }
            return other;
        }
        return o.longValue();
    }

    public static Boolean validarFormadoDeIDsInformado(String str) {
        for (int ctr = 0; ctr < str.length(); ++ctr) {
            if ("1234567890,".contains(Character.valueOf(str.charAt(ctr)).toString())) continue;
            return false;
        }
        return true;
    }

    public static <K, Y> Map<K, Y> toMap(Pair<K, Y> ... pairs) {
        TreeMap t = new TreeMap();
        for (Pair<K, Y> pair : pairs) {
            t.put(pair.key, pair.value);
        }
        return t;
    }

    public static boolean isEquals(Object ... data) {
        boolean aux = true;
        Object last = null;
        for (Object object : data) {
            if (last == null) {
                last = object;
            }
            aux = aux && ToolMethods.isEquals(object, last);
        }
        return aux;
    }

    public static boolean isAnyEquals(Object ... data) {
        boolean aux = false;
        Object last = null;
        for (Object object : data) {
            if (last == null) {
                last = object;
                continue;
            }
            aux = aux || ToolMethods.isEquals(object, last);
        }
        return aux;
    }

    public static <K, Y> Pair<K, Y> pair(K key, Y value) {
        return new Pair<K, Y>(key, value);
    }

    public static boolean isBetween(Number valor, Number valorMinimo, Number valorMaximo) {
        if (valor == null) {
            valor = 0.0;
        }
        if (valorMinimo == null) {
            valorMinimo = 0.0;
        }
        if (valorMaximo == null) {
            valorMaximo = 0.0;
        }
        return ToolMethods.isBetween(valor.doubleValue(), valorMinimo.doubleValue(), valorMaximo.doubleValue());
    }

    public static boolean isBetween(Double valor, Double valorMinimo, Double valorMaximo) {
        if (valor == null) {
            valor = 0.0;
        }
        if (valorMinimo == null) {
            valorMinimo = 0.0;
        }
        if (valorMaximo == null) {
            valorMaximo = 0.0;
        }
        return valor >= valorMinimo && valor <= valorMaximo;
    }

    public static List<HashMap<String, Object>> toHashMap(List<Object[]> resultList, String ... aliases) {
        LinkedList<HashMap<String, Object>> data = new LinkedList<HashMap<String, Object>>();
        for (Object[] objects : resultList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            data.add(map);
            if (objects.length != aliases.length) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.GEN.000065", new Object[]{objects.length, aliases.length}));
            }
            for (int i = 0; i < objects.length; ++i) {
                String alias = aliases[i];
                map.put(alias, objects[i]);
            }
        }
        return data;
    }

    public static boolean isBeforeEqual(Date dataBase, Date dataAnalise, boolean analisarSemConsHora) {
        if (dataBase == null || dataAnalise == null) {
            return false;
        }
        if (analisarSemConsHora) {
            dataBase = ToolDate.dataSemHora(dataBase);
            dataAnalise = ToolDate.dataSemHora(dataAnalise);
        }
        return ToolMethods.isEquals((Object)dataBase, (Object)dataAnalise) || dataBase.before(dataAnalise);
    }

    public static boolean isBetweenEqual(Date dataBase, Date dataInicial, Date dataFinal, boolean analisarSemConsHora) {
        if (dataBase == null || dataInicial == null || dataFinal == null) {
            return false;
        }
        if (analisarSemConsHora) {
            dataBase = ToolDate.dataSemHora(dataBase);
            dataInicial = ToolDate.dataSemHora(dataInicial);
        }
        return ToolMethods.isEquals((Object)dataBase, (Object)dataInicial) || dataBase.after(dataInicial) && dataBase.before(dataFinal);
    }

    public static boolean isAfterEqual(Date dataBase, Date dataAnalise, boolean analisarSemConsHora) {
        if (dataBase == null || dataAnalise == null) {
            return false;
        }
        if (analisarSemConsHora) {
            dataBase = ToolDate.dataSemHora(dataBase);
            dataAnalise = ToolDate.dataSemHora(dataAnalise);
        }
        return ToolMethods.isEquals((Object)dataBase, (Object)dataAnalise) || dataBase.after(dataAnalise);
    }

    public static <E extends Number> List<E> clearNumberList(List<E> data) {
        if (data == null) {
            return null;
        }
        data.removeIf(i -> !ToolMethods.isWithData(i));
        return data;
    }

    public static List<String> clearStringList(List<String> data) {
        if (data == null) {
            return null;
        }
        data.removeIf(i -> !ToolMethods.isStrWithData(i));
        return data;
    }

    public static boolean isAnyNull(Object ... data) {
        if (data == null) {
            return true;
        }
        for (Object ob : data) {
            if (ob != null) continue;
            return true;
        }
        return false;
    }

    public static Date isNulThen(Date dataBase, Date dataCasoNull) {
        if (dataBase == null) {
            dataBase = dataCasoNull;
        }
        return dataBase;
    }

    public static class Pair<K, Y> {
        private K key;
        private Y value;

        public Pair() {
        }

        public Pair(K key, Y value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public void setKey(K key) {
            this.key = key;
        }

        public Y getValue() {
            return this.value;
        }

        public void setValue(Y value) {
            this.value = value;
        }
    }
}

