/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.number;

import com.touchcomp.basementorexceptions.exceptions.impl.parse.ExceptionParseObject;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Random;

public class ToolNumber {
    public static int getNrAleatorio(int maxCasas) {
        char[] temp = new char[maxCasas];
        for (int i = 0; i < maxCasas; ++i) {
            temp[i] = 57;
        }
        Random r = new Random();
        return r.nextInt(Integer.valueOf(new String(temp)) + 1);
    }

    public static String getNrAleatorioStr(int maxCasas) {
        char[] temp = new char[maxCasas];
        for (int i = 0; i < maxCasas; ++i) {
            temp[i] = 57;
        }
        Random r = new Random();
        Integer number = r.nextInt(Integer.valueOf(new String(temp)) + 1);
        return ToolString.completaZeros(number.toString(), maxCasas, true);
    }

    public static int getDigitoVerificadorMod11(String seqNumeros) {
        int[] aux = new int[seqNumeros.length()];
        int variavel = 2;
        int total = 0;
        int dv = 0;
        for (int i = aux.length - 1; i >= 0; --i) {
            aux[i] = Integer.parseInt("" + seqNumeros.charAt(i));
            aux[i] = aux[i] * variavel;
            if (++variavel > 9) {
                variavel = 2;
            }
            total += aux[i];
        }
        dv = total % 11;
        if ((dv = 11 - dv) > 9) {
            dv = 0;
        }
        return dv;
    }

    public static Double asNumber(String numberSTR, int casasDecimais) {
        if (numberSTR == null || numberSTR.length() == 0) {
            return 0.0;
        }
        if (numberSTR.length() > casasDecimais) {
            numberSTR = ToolString.onlyNumbers(numberSTR);
            String sufix = numberSTR.substring(numberSTR.length() - casasDecimais, numberSTR.length());
            String prefix = numberSTR.substring(0, numberSTR.subSequence(0, numberSTR.length() - casasDecimais).length());
            return Double.valueOf(prefix + "." + sufix);
        }
        return Double.valueOf(numberSTR);
    }

    public static Double calcPercentual(Number valor1, Number valor2) {
        return ToolNumber.calcPercentual(valor1, valor2, 2);
    }

    public static Double calcPercentual(Double valor1, Double valor2) {
        return ToolNumber.calcPercentual(valor1, valor2, 2);
    }

    public static Double calcDifPercentual(Double valorInicial, Double valorFinal) {
        return ToolNumber.calcDifPercentual(valorInicial, valorFinal, 2);
    }

    public static Double calcDifPercentual(Number valorInicial, Number valorFinal) {
        return ToolNumber.calcDifPercentual(valorInicial, valorFinal, 2);
    }

    public static Double calcDifPercentual(Number nr1, Number nr2, int casasDec) {
        Double valorInicial = nr1 == null ? 0.0 : nr1.doubleValue();
        Double valorFinal = nr2 == null ? 0.0 : nr2.doubleValue();
        valorInicial = ToolFormatter.arrredondarNumero((double)valorInicial, casasDec);
        valorFinal = ToolFormatter.arrredondarNumero((double)valorFinal, casasDec);
        if (valorInicial == 0.0 && valorFinal == 0.0) {
            return 0.0;
        }
        double difference = (valorFinal - valorInicial) / valorInicial * 100.0;
        return difference;
    }

    public static Double calcPercentual(Number valor1, Number valor2, int casasDec) {
        valor1 = valor1 == null ? (Number)0.0 : (Number)valor1;
        valor2 = valor2 == null ? (Number)0.0 : (Number)valor2;
        valor1 = ToolFormatter.arrredondarNumero(valor1.doubleValue(), casasDec);
        if ((valor2 = ToolFormatter.arrredondarNumero(valor2.doubleValue(), casasDec)).doubleValue() != 0.0) {
            return ToolFormatter.arrredondarNumero(valor1.doubleValue() / valor2.doubleValue() * 100.0, casasDec);
        }
        return 100.0;
    }

    public static boolean isGreatePerc(Double valorInicial, Double valorFinal, Double tolerancia) {
        double dif;
        if (valorInicial == null) {
            valorInicial = 0.0;
        }
        if (valorFinal == null) {
            valorFinal = 0.0;
        }
        if (tolerancia == null) {
            tolerancia = 0.0;
        }
        return (dif = ToolNumber.calcDifPercentual(valorInicial, valorFinal).doubleValue()) > tolerancia;
    }

    public static Double arredondarNumero(Double numero, Integer casasDec, Integer fracao) {
        if (numero == null) {
            return null;
        }
        if (casasDec == null) {
            return numero;
        }
        numero = ToolFormatter.arrredondarNumero(numero, (int)casasDec);
        if (fracao == null || fracao == 0) {
            return numero;
        }
        Integer cast = numero.intValue();
        Double dec = ToolFormatter.arrredondarNumero(numero - (double)cast.intValue(), (int)casasDec);
        Double resto = dec * Math.pow(10.0, casasDec.intValue());
        resto = resto % (double)fracao.intValue();
        Double dif = (double)fracao.intValue() - resto;
        dif = dif / Math.pow(10.0, casasDec.intValue());
        return (double)cast.intValue() + (dec + dif);
    }

    public static double calcDif(Double firtNumber, Double secondNumber, int i) {
        firtNumber = firtNumber != null ? firtNumber : 0.0;
        secondNumber = secondNumber != null ? secondNumber : 0.0;
        return ToolFormatter.arrredondarNumero(firtNumber - secondNumber, i);
    }

    public static Double asZeroIfNull(Double numHoras) {
        if (numHoras == null) {
            numHoras = 0.0;
        }
        return numHoras;
    }

    public static Double asZeroIfNullDouble(Number numHoras) {
        if (numHoras == null) {
            numHoras = 0.0;
        }
        return numHoras.doubleValue();
    }

    public static short asZeroIfNullShort(Number numHoras) {
        if (numHoras == null) {
            numHoras = 0.0;
        }
        return numHoras.shortValue();
    }

    public static int asZeroIfNullSInt(Number numHoras) {
        if (numHoras == null) {
            numHoras = 0.0;
        }
        return numHoras.intValue();
    }

    public static long asZeroIfNullSLong(Number numHoras) {
        if (numHoras == null) {
            numHoras = 0.0;
        }
        return numHoras.longValue();
    }

    public static boolean isExponentialNumber(String codigoAuxiliar) {
        if (codigoAuxiliar == null || codigoAuxiliar.isEmpty()) {
            return false;
        }
        if (!codigoAuxiliar.toUpperCase().contains("E+")) {
            return false;
        }
        try {
            codigoAuxiliar = codigoAuxiliar.replaceAll(",", "\\.");
            Double.valueOf(codigoAuxiliar);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static Long convertExponentialNumberLong(String codigoAuxiliar) {
        if (codigoAuxiliar == null || codigoAuxiliar.isEmpty()) {
            return 0L;
        }
        codigoAuxiliar = codigoAuxiliar.replaceAll(",", "\\.");
        return new BigDecimal(codigoAuxiliar).longValue();
    }

    public static Double convertExponentialNumberDouble(String codigoAuxiliar) {
        if (codigoAuxiliar == null || codigoAuxiliar.isEmpty()) {
            return 0.0;
        }
        codigoAuxiliar = codigoAuxiliar.replaceAll(",", "\\.");
        return new BigDecimal(codigoAuxiliar).doubleValue();
    }

    public static String convertExponentialNumberStr(String codigoAuxiliar) {
        if (codigoAuxiliar == null || codigoAuxiliar.isEmpty()) {
            return "";
        }
        codigoAuxiliar = codigoAuxiliar.replaceAll(",", "\\.");
        return new BigDecimal(codigoAuxiliar).toPlainString();
    }

    public static String testAndconvertExponentialNumberStr(String codigoAuxiliar) {
        if (!ToolNumber.isExponentialNumber(codigoAuxiliar)) {
            return codigoAuxiliar;
        }
        return ToolNumber.convertExponentialNumberStr(codigoAuxiliar);
    }

    public static Integer countDecimalPlaces(Double number) {
        String text = Double.toString(Math.abs(number));
        int integerPlaces = text.indexOf(46);
        return text.length() - integerPlaces - 1;
    }

    public static Double stringToDouble(String value) throws ExceptionParseObject {
        if (value.contains(",")) {
            return ToolNumber.stringMoneyToDouble(value);
        }
        if (ToolString.isADoubleNumber(value)) {
            return Double.valueOf(value);
        }
        return null;
    }

    public static Double stringMoneyToDouble(String value) throws ExceptionParseObject {
        try {
            if (value == null) {
                return 0.0;
            }
            NumberFormat formatador = NumberFormat.getInstance(new Locale.Builder().setLanguage("pt").setRegion("BR").build());
            Number numero = formatador.parse(value);
            return numero.doubleValue();
        }
        catch (ParseException ex) {
            throw new ExceptionParseObject(ex, new Object[0]);
        }
    }
}

