/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.reflections;

import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class AuxFillObjectBaseValues {
    AuxFillObjectBaseValues() {
    }

    void fillWithBaseValues(Object to) throws ExceptionReflection {
        try {
            HashMap<Class, Object> defValues = this.getDefValues();
            BeanInfo b = Introspector.getBeanInfo(to.getClass());
            for (PropertyDescriptor prop : b.getPropertyDescriptors()) {
                if (prop.getWriteMethod() == null) continue;
                this.setIt(to, prop, defValues);
            }
        }
        catch (IntrospectionException ex) {
            throw new ExceptionReflection(ex);
        }
    }

    private HashMap<Class, Object> getDefValues() {
        HashMap<Class, Object> defValues = new HashMap<Class, Object>();
        defValues.put(Double.class, 1.0);
        defValues.put(Double.TYPE, 1.0);
        defValues.put(Integer.class, 1);
        defValues.put(Integer.TYPE, 1);
        defValues.put(Float.class, Float.valueOf(1.0f));
        defValues.put(Float.TYPE, Float.valueOf(1.0f));
        defValues.put(Short.class, (short)1);
        defValues.put(Short.TYPE, (short)1);
        defValues.put(Long.class, 1L);
        defValues.put(Long.TYPE, 1L);
        defValues.put(String.class, "Something");
        defValues.put(Boolean.class, true);
        defValues.put(Boolean.TYPE, true);
        defValues.put(Character.class, Character.valueOf('A'));
        defValues.put(Character.TYPE, Character.valueOf('A'));
        defValues.put(java.util.Date.class, new java.util.Date());
        defValues.put(Timestamp.class, new Timestamp(new java.util.Date().getTime()));
        defValues.put(Date.class, new Date(new java.util.Date().getTime()));
        return defValues;
    }

    private void setIt(Object to, PropertyDescriptor prop, HashMap<Class, Object> defValues) throws ExceptionReflection, IntrospectionException {
        Class type = prop.getPropertyType();
        if (ToolReflections.isPrimitive(type)) {
            Object value = defValues.get(type);
            ToolReflections.setIt(prop.getWriteMethod(), to, value);
        } else if (ToolReflections.isCollection(type)) {
            AbstractCollection inst = null;
            if (List.class.isAssignableFrom(type)) {
                inst = new LinkedList();
            } else if (Set.class.isAssignableFrom(type)) {
                inst = new HashSet();
            }
            ToolReflections.setIt(prop.getWriteMethod(), to, inst);
            type = ToolReflections.getGenericTypeClass(type);
            if (type != null) {
                try {
                    Object ob = type.newInstance();
                    inst.add(ob);
                    this.fillWithBaseValues(ob);
                }
                catch (InstantiationException ex) {
                    throw new ExceptionReflection(ex);
                }
                catch (IllegalAccessException ex) {
                    throw new ExceptionReflection(ex);
                }
            }
        } else {
            try {
                Object inst = type.newInstance();
                ToolReflections.setIt(prop.getWriteMethod(), to, inst);
                this.fillWithBaseValues(inst);
            }
            catch (InstantiationException ex) {
                throw new ExceptionReflection(ex);
            }
            catch (IllegalAccessException ex) {
                throw new ExceptionReflection(ex);
            }
        }
    }
}

