/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.reflections;

import com.google.common.base.Predicate;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.EnumReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementortools.model.reflection.FieldClassInfo;
import com.touchcomp.basementortools.model.reflection.MethodClassInfo;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.reflections.AuxFillObjectBaseValues;
import com.touchcomp.basementortools.tools.reflections.AuxHibernate;
import com.touchcomp.basementortools.tools.reflections.AuxReflectionPackClasses;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.collection.internal.PersistentBag;
import org.reflections.Configuration;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class ToolReflections {
    public static List<Method> getGetMethods(Class inputClass) {
        Set getters = ReflectionUtils.getAllMethods((Class)inputClass, (Predicate[])new Predicate[]{ReflectionUtils.withModifier((int)1), ReflectionUtils.withPrefix((String)"get"), ReflectionUtils.withParametersCount((int)0)});
        return new LinkedList<Method>(getters);
    }

    public static List<Method> getSetMethods(Class inputClass) {
        Set setters = ReflectionUtils.getAllMethods((Class)inputClass, (Predicate[])new Predicate[]{ReflectionUtils.withModifier((int)1), ReflectionUtils.withPrefix((String)"set"), ReflectionUtils.withParametersCount((int)1)});
        return new LinkedList<Method>(setters);
    }

    public static List<Method> getGetMethodsManagedHibernate(Class inputClass) {
        Set getters = ReflectionUtils.getAllMethods((Class)inputClass, (Predicate[])new Predicate[]{ReflectionUtils.withModifier((int)1), ReflectionUtils.withPrefix((String)"get"), ReflectionUtils.withParametersCount((int)0)});
        LinkedList<Method> toRet = new LinkedList<Method>();
        for (Method mh : getters) {
            ToolReflections.testMethod(mh, toRet);
        }
        return toRet;
    }

    private static void testMethod(Method mh, List<Method> toRet) {
        if (mh.getAnnotation(Transient.class) != null) {
            return;
        }
        if (!toRet.contains(mh)) {
            toRet.add(mh);
        }
    }

    public static List<Field> getGetFieldsManagedHibernate(Class inputClass) {
        Set getters = ReflectionUtils.getAllFields((Class)inputClass, (Predicate[])new Predicate[0]);
        LinkedList<Field> toRet = new LinkedList<Field>();
        for (Field mh : getters) {
            ToolReflections.testMethod(mh, toRet);
        }
        return toRet;
    }

    private static void testMethod(Field mh, List<Field> toRet) {
        if (mh.getAnnotation(Transient.class) != null) {
            return;
        }
        if (!toRet.contains(mh)) {
            toRet.add(mh);
        }
    }

    public static String getFieldName(Method mh) {
        String name = mh.getName();
        StringBuilder sb = new StringBuilder(name);
        sb.delete(0, 3);
        sb.replace(0, 1, String.valueOf(Character.toLowerCase(sb.charAt(0))));
        return sb.toString();
    }

    public static String getFieldName(Field mh) {
        String name = mh.getName();
        return name;
    }

    public static Class getReturnClass(Method mh) throws ExceptionReflection {
        Type t = mh.getGenericReturnType();
        if (t instanceof ParameterizedType) {
            int n = 0;
            ParameterizedType pt = (ParameterizedType)t;
            Type[] typeArray = pt.getActualTypeArguments();
            int n2 = typeArray.length;
            if (n < n2) {
                Type taux = typeArray[n];
                String str = taux.getTypeName();
                try {
                    return Class.forName(str);
                }
                catch (ClassNotFoundException ex) {
                    throw new ExceptionReflection(ex);
                }
            }
        } else {
            return mh.getReturnType();
        }
        return null;
    }

    public static Class getReturnClassHibernate(Method mh) throws ExceptionReflection {
        Type t = mh.getGenericReturnType();
        Class<?> found = null;
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            for (Type taux : pt.getActualTypeArguments()) {
                String str = taux.getTypeName();
                try {
                    found = Class.forName(str);
                }
                catch (ClassNotFoundException ex) {
                    throw new ExceptionReflection(ex);
                }
            }
        } else {
            found = mh.getReturnType();
        }
        if (found != null && found.getAnnotation(Entity.class) != null) {
            return found;
        }
        return null;
    }

    public static Class getReturnClassHibernate(Field mh) throws ClassNotFoundException {
        Type t = mh.getGenericType();
        Class<?> found = null;
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            for (Type taux : pt.getActualTypeArguments()) {
                String str = taux.getTypeName();
                found = Class.forName(str);
            }
        } else {
            found = mh.getType();
        }
        if (found != null && found.getAnnotation(Entity.class) != null) {
            return found;
        }
        return null;
    }

    public static boolean isInstanceOF(Class found, Class compareTo) {
        return compareTo.isAssignableFrom(found);
    }

    public static boolean hasCascade(Method mh) {
        OneToMany oneToMany = mh.getAnnotation(OneToMany.class);
        if (oneToMany != null && oneToMany.cascade().length > 0) {
            return true;
        }
        ManyToMany manyToMany = mh.getAnnotation(ManyToMany.class);
        if (manyToMany != null && manyToMany.cascade().length > 0) {
            return true;
        }
        ManyToOne manyToOne = mh.getAnnotation(ManyToOne.class);
        if (manyToOne != null && manyToOne.cascade().length > 0) {
            return true;
        }
        OneToOne oneToOne = mh.getAnnotation(OneToOne.class);
        if (oneToOne != null && oneToOne.cascade().length > 0) {
            return true;
        }
        Cascade casc = mh.getAnnotation(Cascade.class);
        return casc != null && casc.value().length > 0;
    }

    public static Class getHibernateEntityClass(Method mh) throws ExceptionReflection {
        OneToMany oneToMany = mh.getAnnotation(OneToMany.class);
        if (oneToMany != null && oneToMany.targetEntity() != null && !oneToMany.targetEntity().equals(Void.TYPE)) {
            return oneToMany.targetEntity();
        }
        ManyToMany manyToMany = mh.getAnnotation(ManyToMany.class);
        if (manyToMany != null && manyToMany.targetEntity() != null && !manyToMany.targetEntity().equals(Void.TYPE)) {
            return manyToMany.targetEntity();
        }
        ManyToOne manyToOne = mh.getAnnotation(ManyToOne.class);
        if (manyToOne != null && manyToOne.targetEntity() != null && !manyToOne.targetEntity().equals(Void.TYPE)) {
            return manyToOne.targetEntity();
        }
        OneToOne oneToOne = mh.getAnnotation(OneToOne.class);
        if (oneToOne != null && oneToOne.targetEntity() != null && !oneToOne.targetEntity().equals(Void.TYPE)) {
            return oneToOne.targetEntity();
        }
        return ToolReflections.getReturnClassHibernate(mh);
    }

    public static Class getHibernateEntityClass(Field mh) throws ClassNotFoundException {
        OneToMany oneToMany = mh.getAnnotation(OneToMany.class);
        if (oneToMany != null && oneToMany.targetEntity() != null && !oneToMany.targetEntity().equals(Void.TYPE)) {
            return oneToMany.targetEntity();
        }
        ManyToMany manyToMany = mh.getAnnotation(ManyToMany.class);
        if (manyToMany != null && manyToMany.targetEntity() != null && !manyToMany.targetEntity().equals(Void.TYPE)) {
            return manyToMany.targetEntity();
        }
        ManyToOne manyToOne = mh.getAnnotation(ManyToOne.class);
        if (manyToOne != null && manyToOne.targetEntity() != null && !manyToOne.targetEntity().equals(Void.TYPE)) {
            return manyToOne.targetEntity();
        }
        OneToOne oneToOne = mh.getAnnotation(OneToOne.class);
        if (oneToOne != null && oneToOne.targetEntity() != null && !oneToOne.targetEntity().equals(Void.TYPE)) {
            return oneToOne.targetEntity();
        }
        return ToolReflections.getReturnClassHibernate(mh);
    }

    public static boolean isPersisted(Method mh) {
        return mh.getAnnotation(Transient.class) == null && mh.getName().startsWith("get");
    }

    public static boolean isEntity(Method mh) throws ExceptionReflection {
        return ToolReflections.getHibernateEntityClass(mh) != null;
    }

    public static boolean isEntity(Class clazz) {
        return clazz.getAnnotation(Entity.class) != null;
    }

    public static String getDescName(Class classe) {
        String key = classe.getSimpleName();
        String ret = MessagesBaseMentor.getMsg((String)key, (Object[])new Object[0]);
        if (ret == null) {
            ret = key;
        }
        return ret;
    }

    public static String getDescName(Method mh) {
        String key = ToolReflections.getFieldName(mh);
        String ret = MessagesBaseMentor.getMsg((String)key, (Object[])new Object[0]);
        if (ret == null) {
            ret = key;
        }
        return ret;
    }

    public static String getDescName(Field mh) {
        String ret = MessagesBaseMentor.getMsg((String)mh.getName(), (Object[])new Object[0]);
        if (ret == null) {
            ret = mh.getName();
        }
        return ret;
    }

    public static Class toModelVOClass(String classe) throws ClassNotFoundException {
        if (classe == null) {
            return null;
        }
        if (((String)classe).lastIndexOf(".") > -1) {
            classe = ((String)classe).substring(((String)classe).lastIndexOf(".") + 1);
            classe = "com.touchcomp.basementor.model.vo." + (String)classe;
        }
        return Class.forName((String)classe);
    }

    public static List<Method> getGetMethodsWithAnnotation(Class aClass, Class anotationClass) {
        Set getters = ReflectionUtils.getAllMethods((Class)aClass, (Predicate[])new Predicate[]{ReflectionUtils.withModifier((int)1), ReflectionUtils.withAnnotation((Class)anotationClass)});
        LinkedList<Method> toRet = new LinkedList<Method>();
        for (Method mh : getters) {
            ToolReflections.testMethod(mh, toRet);
        }
        return toRet;
    }

    public static List<Field> getFieldWithAnnotation(Class aClass, Class anotationClass) {
        Set getters = ReflectionUtils.getAllFields((Class)aClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation((Class)anotationClass)});
        return new LinkedList<Field>(getters);
    }

    public static List<FieldClassInfo> getFieldClass(String classe) throws Exception {
        return ToolReflections.getFieldClass(classe, new LinkedList<Class>());
    }

    public static List<FieldClassInfo> getFieldClass(String classe, List<Class> tiposRetornos) throws Exception {
        if (classe == null) {
            return new LinkedList<FieldClassInfo>();
        }
        Class<?> clazz = Class.forName(classe);
        Method[] methodsTemp = clazz.getDeclaredMethods();
        Field[] fields = clazz.getDeclaredFields();
        List mList = ToolMethods.toList(methodsTemp);
        LinkedList<FieldClassInfo> ret = new LinkedList<FieldClassInfo>();
        for (Field field : fields) {
            Optional<Method> found = mList.stream().filter(i -> i.getName().startsWith("get") && ToolReflections.getFieldName(i).equals(field.getName())).findFirst();
            if (!found.isPresent() || !tiposRetornos.isEmpty() && !tiposRetornos.contains(field.getType())) continue;
            FieldClassInfo f = new FieldClassInfo(MessagesBaseMentor.getDefMsg((String)field.getName(), (Object[])new Object[0]), field.getName(), field.getType().getCanonicalName(), field.getType());
            ret.add(f);
        }
        return ret;
    }

    public static List<MethodClassInfo> getMethodClass(String classe) throws Exception {
        return ToolReflections.getMethodClass(classe, new LinkedList<Class>());
    }

    public static List<MethodClassInfo> getMethodClass(String classe, List<Class> tiposRetornos) throws Exception {
        if (classe == null) {
            return new LinkedList<MethodClassInfo>();
        }
        Method[] methods = Class.forName(classe).getDeclaredMethods();
        LinkedList<MethodClassInfo> toRet = new LinkedList<MethodClassInfo>();
        for (Method mh : methods) {
            if (!tiposRetornos.isEmpty() && !tiposRetornos.contains(mh.getReturnType())) continue;
            String name = mh.getName();
            String field = ToolReflections.readFieldName(name);
            MethodClassInfo f = new MethodClassInfo(MessagesBaseMentor.getDefMsg((String)field, (Object[])new Object[0]), field, name);
            toRet.add(f);
        }
        Collections.sort(toRet, new Comparator<MethodClassInfo>(){

            @Override
            public int compare(MethodClassInfo o1, MethodClassInfo o2) {
                MethodClassInfo m1 = o1;
                MethodClassInfo m2 = o2;
                return m1.getDescricao().compareTo(m2.getDescricao());
            }
        });
        return toRet;
    }

    public static Object getFieldValueFromMethod(String methodName, Object entidade) throws ExceptionReflection {
        try {
            Method m = ToolReflections.getMethod(methodName, entidade);
            return ToolReflections.getValueFromMethod(m, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (SecurityException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new ExceptionReflection(ex);
        }
    }

    public static Object getValueFromMethod(Method m, Object entidade) throws ExceptionReflection {
        try {
            if (m == null || entidade == null) {
                return null;
            }
            return m.invoke(entidade, new Object[0]);
        }
        catch (SecurityException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (InvocationTargetException ex) {
            throw new ExceptionReflection(ex);
        }
    }

    private static Method getMethod(String name, Object entidade) throws NoSuchMethodException, SecurityException {
        Class<?> cl = entidade.getClass();
        return ToolReflections.getMethod(name, cl);
    }

    private static Method getMethod(String name, Class cl) throws NoSuchMethodException, SecurityException {
        return cl.getMethod(name, new Class[0]);
    }

    private static Method getMethodWithParams(String name, Class cl, Class ... params) throws NoSuchMethodException, SecurityException {
        return cl.getMethod(name, params);
    }

    public static Object getFieldValueFromGetMethod(String pathField, Object entidade) throws ExceptionReflection {
        return ToolReflections.getFieldValueFromGetMethod(pathField, entidade, false);
    }

    public static Object getFieldValueFromGetMethod(String pathField, Object entidade, boolean validadeNullEntity) throws ExceptionReflection {
        if (entidade == null && validadeNullEntity) {
            throw new ExceptionReflection(EnumReflection.NULL_POINTER, new Object[]{entidade});
        }
        if (entidade == null && !validadeNullEntity) {
            return null;
        }
        return ToolReflections.getFieldValueFromGetMethodInternal(pathField, entidade);
    }

    private static Object getFieldValueFromGetMethodInternal(String pathField, Object entidade) throws ExceptionReflection {
        StringTokenizer stk = new StringTokenizer(pathField, ".");
        Object value = entidade;
        while (stk.hasMoreTokens()) {
            String next = stk.nextToken();
            if ((value = value instanceof Map ? ((Map)value).get(next) : ToolReflections.invockeMethodFromFieldPath(next, value)) != null) continue;
            break;
        }
        return value;
    }

    private static Object invockeMethodFromFieldPath(String next, Object value) throws ExceptionReflection {
        if (next == null || next.equalsIgnoreCase("null")) {
            return null;
        }
        next = next.trim();
        Object name = next;
        if (value != null && value instanceof Map) {
            return ((Map)value).get(next);
        }
        if (!((String)name).startsWith("get")) {
            name = "get" + next.substring(0, 1).toUpperCase() + next.substring(1);
        }
        if (value != null && (Collections.class.isAssignableFrom(value.getClass()) || value instanceof PersistentBag)) {
            Collection data = (Collection)value;
            Object[] aux = new Object[data.size()];
            int i = 0;
            for (Object object : data) {
                aux[i] = ToolReflections.invockeInternal((String)name, object);
            }
            return aux;
        }
        if (value != null && value.getClass().isArray()) {
            Object[] temp = (Object[])value;
            Object[] aux = new Object[temp.length];
            int i = 0;
            for (Object object : temp) {
                aux[i] = ToolReflections.invockeInternal((String)name, object);
            }
            return aux;
        }
        return ToolReflections.invockeInternal((String)name, value);
    }

    private static String readFieldName(String name) {
        name = ((String)name).substring(3);
        name = ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1);
        return name;
    }

    private static Class getAnnotationOneToOne(Method m) {
        OneToOne o = m.getAnnotation(OneToOne.class);
        if (o != null) {
            Class c = o.targetEntity();
            if (c.getClassLoader() != null) {
                return c;
            }
            return m.getReturnType();
        }
        return null;
    }

    private static Class getAnnotationManyToOne(Method m) {
        ManyToOne o = m.getAnnotation(ManyToOne.class);
        if (o != null) {
            Class c = o.targetEntity();
            if (c.getClassLoader() != null) {
                return c;
            }
            return m.getReturnType();
        }
        return null;
    }

    private static Class getAnnotationOneToMany(Method m) {
        OneToMany o = m.getAnnotation(OneToMany.class);
        if (o != null && m.getGenericReturnType() instanceof ParameterizedType) {
            Class<?> c = o.targetEntity().getClass();
            if (c.getClassLoader() != null) {
                return c;
            }
            ParameterizedType p = (ParameterizedType)m.getGenericReturnType();
            if (p.getActualTypeArguments() != null && p.getActualTypeArguments()[0] != null) {
                Class cc = (Class)p.getActualTypeArguments()[0];
                return cc;
            }
        }
        return null;
    }

    public static Class getHibernateReturnType(Method m) {
        return ToolReflections.getHibernateReturnType(m, null);
    }

    public static Class getHibernateReturnType(Method m, Method[] methodsPersintentClass) {
        Class cl;
        if (methodsPersintentClass != null) {
            for (Method aux : methodsPersintentClass) {
                if (!m.getName().equalsIgnoreCase(aux.getName())) continue;
                m = aux;
            }
        }
        if ((cl = ToolReflections.getAnnotationOneToOne(m)) != null) {
            return cl;
        }
        cl = ToolReflections.getAnnotationManyToOne(m);
        if (cl != null) {
            return cl;
        }
        cl = ToolReflections.getAnnotationOneToMany(m);
        if (cl != null) {
            return cl;
        }
        return m.getReturnType();
    }

    public static boolean hasCascadeAnnotation(Method mh) {
        if (mh == null) {
            return false;
        }
        if (mh.getAnnotation(Cascade.class) != null) {
            return true;
        }
        if (mh.getAnnotation(OneToMany.class) != null) {
            OneToMany one = mh.getAnnotation(OneToMany.class);
            return one.cascade() != null && one.cascade().length > 0;
        }
        if (mh.getAnnotation(OneToOne.class) != null) {
            OneToOne one = mh.getAnnotation(OneToOne.class);
            return one.cascade() != null && one.cascade().length > 0;
        }
        if (mh.getAnnotation(ManyToOne.class) != null) {
            ManyToOne one = mh.getAnnotation(ManyToOne.class);
            return one.cascade() != null && one.cascade().length > 0;
        }
        return false;
    }

    public static boolean hasCascadeAnnotation(Field field) {
        if (field == null) {
            return false;
        }
        if (field.getAnnotation(Cascade.class) != null) {
            return true;
        }
        if (field.getAnnotation(OneToMany.class) != null) {
            OneToMany one = field.getAnnotation(OneToMany.class);
            return one.cascade() != null && one.cascade().length > 0;
        }
        if (field.getAnnotation(OneToOne.class) != null) {
            OneToOne one = field.getAnnotation(OneToOne.class);
            return one.cascade() != null && one.cascade().length > 0;
        }
        if (field.getAnnotation(ManyToOne.class) != null) {
            ManyToOne one = field.getAnnotation(ManyToOne.class);
            return one.cascade() != null && one.cascade().length > 0;
        }
        return false;
    }

    private static boolean hasMethodAnnotation(Method mh, Class classe) {
        return mh.getAnnotation(classe) != null;
    }

    public static Method[] getMethodsWithAnnotation(Class classe, List<Class> to) {
        if (classe == null) {
            return new Method[0];
        }
        Method[] methods = classe.getMethods();
        LinkedList<Method> toRet = new LinkedList<Method>();
        for (Method mh : methods) {
            for (Class ann : to) {
                if (!ToolReflections.hasMethodAnnotation(mh, ann)) continue;
                toRet.add(mh);
            }
        }
        return toRet.toArray(new Method[toRet.size()]);
    }

    public static String getClassEntityFromPath(String classe, String fullPathAtributo) throws ExceptionReflection {
        try {
            Class<?> clazz = Class.forName(classe);
            StringTokenizer tokString = new StringTokenizer(fullPathAtributo, ".");
            while (tokString.hasMoreTokens()) {
                Object token = tokString.nextToken();
                Method mh = ToolReflections.getMethodFromClazz((String)(token = "get" + ((String)token).substring(0, 1).toUpperCase() + ((String)token).substring(1)), clazz);
                clazz = ToolReflections.getAnnotationManyToOne(mh);
                if (clazz == null) {
                    clazz = ToolReflections.getAnnotationOneToOne(mh);
                }
                if (clazz == null) {
                    clazz = ToolReflections.getAnnotationOneToMany(mh);
                }
                if (clazz != null) continue;
                clazz = mh.getReturnType();
            }
            return clazz.getCanonicalName();
        }
        catch (ClassNotFoundException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new ExceptionReflection(ex);
        }
    }

    public static Method getMethodFromClazz(String token, Class clazz) throws NoSuchMethodException {
        return clazz.getMethod(token, new Class[0]);
    }

    public static String getFieldNameFromGetMethod(String metodoPesquisa) {
        if (metodoPesquisa == null || metodoPesquisa.length() == 0) {
            return metodoPesquisa;
        }
        if (metodoPesquisa.startsWith("get")) {
            metodoPesquisa = metodoPesquisa.substring("get".length());
        }
        return metodoPesquisa.substring(0, 1).toLowerCase() + metodoPesquisa.substring(1);
    }

    public static Class<?>[] getClasses(String packageName, Class<? extends Annotation> annotation) throws ExceptionReflection {
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        Set allClasses = reflections.getTypesAnnotatedWith(annotation);
        return allClasses.toArray(new Class[0]);
    }

    public static Class<?>[] getClasses(String packageName) throws ExceptionReflection {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new SubTypesScanner(false)}));
        Set allClasses = reflections.getSubTypesOf(Object.class);
        return allClasses.toArray(new Class[0]);
    }

    public static Class<?>[] getClassesFromClassLoader(String packageName) throws ExceptionReflection {
        try {
            return new AuxReflectionPackClasses().getClasses(packageName);
        }
        catch (ClassNotFoundException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (IOException ex) {
            throw new ExceptionReflection(ex);
        }
    }

    public static Class<?>[] getClassFromPackage(String packageName) throws ExceptionReflection {
        LinkedList<ClassLoader> classLoadersList = new LinkedList<ClassLoader>();
        classLoadersList.add(ClasspathHelper.contextClassLoader());
        classLoadersList.add(ClasspathHelper.staticClassLoader());
        Reflections reflections = new Reflections(packageName, new Scanner[]{new SubTypesScanner(false)});
        Set allClasses = reflections.getSubTypesOf(Object.class);
        return allClasses.toArray(new Class[0]);
    }

    public static List<Class> getClassFromPackage(String packageName, Class<? extends Annotation> annotation) throws ExceptionReflection {
        try {
            Class<?>[] classes = ToolReflections.getClasses(packageName, annotation);
            LinkedList<Class> l = new LinkedList<Class>(Arrays.asList(classes));
            Collections.sort(l, new Comparator<Class>(){

                @Override
                public int compare(Class o1, Class o2) {
                    return o1.getCanonicalName().compareToIgnoreCase(o2.getCanonicalName());
                }
            });
            return l;
        }
        catch (ExceptionReflection e) {
            e.printStackTrace();
            throw e;
        }
    }

    private static Object invockeInternal(String next, Object value) throws ExceptionReflection {
        try {
            if (next == null || value == null) {
                return null;
            }
            Method m = ToolReflections.getMethod(next, value);
            if (m == null) {
                return null;
            }
            return m.invoke(value, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (InvocationTargetException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (SecurityException ex) {
            throw new ExceptionReflection(ex);
        }
    }

    public static Number getIdValueFromVOModel(Object objeto) throws ExceptionReflection {
        try {
            if (objeto == null) {
                return null;
            }
            LinkedList<Class> aux = new LinkedList<Class>();
            aux.add(Id.class);
            Method[] found = ToolReflections.getMethodsWithAnnotation(objeto.getClass(), aux);
            if (found.length > 0) {
                Method first = found[0];
                return (Number)first.invoke(objeto, new Object[0]);
            }
            List<Field> fields = ToolReflections.getFieldWithAnnotation(objeto.getClass(), Id.class);
            if (!fields.isEmpty()) {
                Field f = fields.get(0);
                f.setAccessible(true);
                return (Number)f.get(objeto);
            }
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (InvocationTargetException ex) {
            throw new ExceptionReflection(ex);
        }
        return null;
    }

    public static String getIdPropertyName(Class clazz) throws ExceptionReflection {
        try {
            if (clazz == null) {
                return null;
            }
            LinkedList<Class> aux = new LinkedList<Class>();
            aux.add(Id.class);
            Method[] found = ToolReflections.getMethodsWithAnnotation(clazz, aux);
            if (found.length > 0) {
                Method first = found[0];
                return ToolReflections.getFieldName(first);
            }
            List<Field> fields = ToolReflections.getFieldWithAnnotation(clazz, Id.class);
            if (!fields.isEmpty()) {
                Field f = fields.get(0);
                f.setAccessible(true);
                return f.getName();
            }
        }
        catch (IllegalArgumentException ex) {
            throw new ExceptionReflection(ex);
        }
        return null;
    }

    public static List<Class> getClassesFromInterface(String packageName, Class interfaceClass) {
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        Set classes = reflections.getSubTypesOf(interfaceClass);
        return new LinkedList<Class>(classes);
    }

    public static Class getGenericTypeClass(Class<?> clazz) {
        return ToolReflections.getGenericTypeClass(clazz, 0);
    }

    public static Class getGenericTypeClass(Class<?> clazz, int index) {
        ParameterizedType p = (ParameterizedType)clazz.getGenericSuperclass();
        if (p == null) {
            return null;
        }
        return ToolReflections.getGenericTypeClass(p, index);
    }

    public static Class getGenericTypeClass(ParameterizedType clazz, int index) {
        Type parameterizedType = clazz.getActualTypeArguments()[index];
        if (parameterizedType instanceof Class) {
            return (Class)parameterizedType;
        }
        return null;
    }

    public static boolean isPrimitive(Object obj) {
        if (obj == null) {
            return false;
        }
        return ToolReflections.isPrimitive(obj.getClass());
    }

    public static boolean isPrimitive(Class fieldEntityType) {
        return ToolReflections.getPrimitiveClass().contains(fieldEntityType);
    }

    public static boolean isPrimitiveByClassName(String fieldEntityType) {
        for (Class<?> clazz : ToolReflections.getPrimitiveClass()) {
            if (!clazz.getCanonicalName().equalsIgnoreCase(fieldEntityType) && !clazz.getSimpleName().equals(fieldEntityType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitiveOrArray(Object obj) {
        if (obj == null) {
            return false;
        }
        return ToolReflections.isPrimitiveOrArray(obj.getClass());
    }

    public static Set<Class<?>> getPrimitiveClass() {
        return new HashSet(Arrays.asList(Boolean.class, Boolean.TYPE, Character.class, Character.TYPE, Byte.class, Byte.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, Void.class, Void.TYPE, Date.class, Timestamp.class, String.class));
    }

    public static Set<Class<?>> getPrimitiveClassNumber() {
        return new HashSet(Arrays.asList(Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE));
    }

    public static Set<Class<?>> getPrimitiveClassIntNumber() {
        return new HashSet(Arrays.asList(Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE));
    }

    public static Set<Class[]> getPrimitiveClassArray() {
        return new HashSet<Class>(Arrays.asList(Boolean[].class, boolean[].class, Character[].class, char[].class, Byte[].class, byte[].class, Short[].class, short[].class, Long[].class, long[].class, Float[].class, float[].class, Double[].class, double[].class, Void.class, Void.TYPE, Date[].class, Timestamp[].class, String[].class, LocalDate.class, LocalDateTime.class));
    }

    public static boolean isPrimitiveOrArray(Class fieldEntityType) {
        if (fieldEntityType == null) {
            return false;
        }
        if (ToolReflections.isPrimitive(fieldEntityType)) {
            return true;
        }
        if (fieldEntityType.isEnum()) {
            return true;
        }
        return ToolReflections.getPrimitiveClassArray().contains(fieldEntityType);
    }

    public static Object[] getValuesEnum(Class<?> type) throws ExceptionReflection {
        try {
            Method method = type.getDeclaredMethod("values", new Class[0]);
            return (Object[])method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (InvocationTargetException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (SecurityException ex) {
            throw new ExceptionReflection(ex);
        }
    }

    public static boolean isCollection(Class fieldType) {
        return Collection.class.isAssignableFrom(fieldType);
    }

    public static boolean hasCascade(Field field, Class parent) throws ExceptionReflection {
        try {
            OneToMany oneToMany = field.getAnnotation(OneToMany.class);
            if (oneToMany != null && oneToMany.cascade().length > 0) {
                return true;
            }
            ManyToMany manyToMany = field.getAnnotation(ManyToMany.class);
            if (manyToMany != null && manyToMany.cascade().length > 0) {
                return true;
            }
            ManyToOne manyToOne = field.getAnnotation(ManyToOne.class);
            if (manyToOne != null && manyToOne.cascade().length > 0) {
                return true;
            }
            OneToOne oneToOne = field.getAnnotation(OneToOne.class);
            if (oneToOne != null && oneToOne.cascade().length > 0) {
                return true;
            }
            Cascade casc = field.getAnnotation(Cascade.class);
            if (casc != null) {
                return true;
            }
            String getMethod = ToolReflections.getMethodGetName(field);
            Method m = parent.getMethod(getMethod, new Class[0]);
            return ToolReflections.hasCascade(m);
        }
        catch (NoSuchMethodException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (SecurityException ex) {
            throw new ExceptionReflection(ex);
        }
    }

    public static void fillWithBaseValues(Object to) throws ExceptionReflection {
        new AuxFillObjectBaseValues().fillWithBaseValues(to);
    }

    public static void setIt(Method writeMethod, Object obj, Object ... value) throws ExceptionReflection {
        try {
            writeMethod.invoke(obj, value);
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (InvocationTargetException ex) {
            throw new ExceptionReflection(ex);
        }
    }

    public static String getMethodGetName(Field f) {
        return ToolReflections.getMethodGetName(f.getName());
    }

    public static String getMethodGetName(String fieldName) {
        return "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static Method getMethodGet(Field f, Class base) throws ExceptionReflection {
        try {
            return ToolReflections.getMethod(ToolReflections.getMethodGetName(f), base);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (SecurityException ex) {
            throw new ExceptionReflection(ex);
        }
    }

    public static Method getMethodSet(Field f, Class base) throws ExceptionReflection {
        try {
            return ToolReflections.getMethodWithParams(ToolReflections.getMethodSetName(f), base, f.getType());
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (SecurityException ex) {
            throw new ExceptionReflection(ex);
        }
    }

    public static String getMethodSetName(Field f) {
        return "set" + f.getName().substring(0, 1).toUpperCase() + f.getName().substring(1);
    }

    public static Field getField(Class base, String fieldName) {
        Set fields = ReflectionUtils.getAllFields((Class)base, (Predicate[])new Predicate[0]);
        Optional<Field> found = fields.stream().filter(i -> i.getName().equals(fieldName)).findFirst();
        return found.isPresent() ? found.get() : null;
    }

    public static String getFieldDatabase(String classe, String fullPathAtributo) throws ExceptionReflection {
        try {
            return ToolReflections.getFieldDatabase(Class.forName(classe), fullPathAtributo);
        }
        catch (ClassNotFoundException ex) {
            throw new ExceptionReflection(ex);
        }
    }

    public static String getFieldDatabase(Class classe, String fullPathAtributo) throws ExceptionReflection {
        return new AuxHibernate().getFieldDatabase(classe, fullPathAtributo);
    }

    public static Method getWriteMethod(Class<? extends Object> aClass, String fieldName) throws ExceptionReflection {
        try {
            PropertyDescriptor[] props;
            BeanInfo bInfo = Introspector.getBeanInfo(aClass);
            for (PropertyDescriptor prop : props = bInfo.getPropertyDescriptors()) {
                if (!TMethods.isEquals((Object)prop.getName(), (Object)fieldName)) continue;
                return prop.getWriteMethod();
            }
            return null;
        }
        catch (IntrospectionException ex) {
            throw new ExceptionReflection(ex);
        }
    }

    public static Method getReadMethod(Class<? extends Object> aClass, String fieldName) throws ExceptionReflection {
        try {
            PropertyDescriptor[] props;
            BeanInfo bInfo = Introspector.getBeanInfo(aClass);
            for (PropertyDescriptor prop : props = bInfo.getPropertyDescriptors()) {
                if (!TMethods.isEquals((Object)prop.getName(), (Object)fieldName)) continue;
                return prop.getReadMethod();
            }
            return null;
        }
        catch (IntrospectionException ex) {
            throw new ExceptionReflection(ex);
        }
    }

    public static String getTableName(String entity) throws ExceptionReflection {
        try {
            return ToolReflections.getTableName(Class.forName(entity));
        }
        catch (ClassNotFoundException ex) {
            throw new ExceptionReflection(ex);
        }
    }

    public static String getTableName(Class entity) {
        return new AuxHibernate().getTableName(entity);
    }

    public static <E> E setNullFields(E obj) throws IntrospectionException, ExceptionReflection {
        try {
            PropertyDescriptor[] props;
            BeanInfo bean = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor pr : props = bean.getPropertyDescriptors()) {
                if (pr.getWriteMethod() == null) continue;
                pr.getWriteMethod().invoke(obj, new Object[]{null});
            }
            return obj;
        }
        catch (IllegalAccessException ex) {
            TLogger.get(ToolReflections.class).error((Throwable)ex);
            throw new ExceptionReflection(ex);
        }
        catch (IllegalArgumentException ex) {
            TLogger.get(ToolReflections.class).error((Throwable)ex);
            throw new ExceptionReflection(ex);
        }
        catch (InvocationTargetException ex) {
            TLogger.get(ToolReflections.class).error((Throwable)ex);
            throw new ExceptionReflection(ex);
        }
    }

    public static void setEmptyListIfNull(Object entity, boolean clearIfNotNull) throws ExceptionReflection {
        if (entity == null) {
            return;
        }
        try {
            Field[] fields;
            Class<?> entClass = entity.getClass();
            for (Field field : fields = entity.getClass().getDeclaredFields()) {
                Class<?> type = field.getType();
                Method get = ToolReflections.getMethodGet(field, entClass);
                Method set = ToolReflections.getMethodSet(field, entClass);
                if (get == null || set == null) continue;
                Cloneable toSet = get.invoke(entity, new Object[0]);
                if (!Collection.class.isAssignableFrom(type)) continue;
                if (toSet == null && List.class.isAssignableFrom(type)) {
                    toSet = new LinkedList();
                    set.invoke(entity, toSet);
                } else if (toSet == null && Map.class.isAssignableFrom(type)) {
                    toSet = new LinkedHashMap();
                    set.invoke(entity, toSet);
                } else if (toSet == null && Set.class.isAssignableFrom(type)) {
                    toSet = new LinkedHashSet();
                    set.invoke(entity, toSet);
                }
                if (toSet == null || !clearIfNotNull) continue;
                ((Collection)((Object)toSet)).clear();
            }
        }
        catch (IllegalAccessException ex) {
            TLogger.get(ToolReflections.class).error((Throwable)ex);
            throw new ExceptionReflection(ex);
        }
        catch (IllegalArgumentException ex) {
            TLogger.get(ToolReflections.class).error((Throwable)ex);
            throw new ExceptionReflection(ex);
        }
        catch (InvocationTargetException ex) {
            TLogger.get(ToolReflections.class).error((Throwable)ex);
            throw new ExceptionReflection(ex);
        }
        catch (ExceptionReflection ex) {
            TLogger.get(ToolReflections.class).error((Throwable)ex);
            throw ex;
        }
    }

    public static Object getDefValue(Class retType) throws ExceptionReflection {
        if (Short.class.isAssignableFrom(retType)) {
            return (short)0;
        }
        if (Integer.class.isAssignableFrom(retType)) {
            return 0;
        }
        if (Long.class.isAssignableFrom(retType)) {
            return 0L;
        }
        if (Float.class.isAssignableFrom(retType)) {
            return Float.valueOf(0.0f);
        }
        if (Double.class.isAssignableFrom(retType)) {
            return 0.0;
        }
        if (String.class.isAssignableFrom(retType)) {
            return "";
        }
        if (Date.class.isAssignableFrom(retType)) {
            return new Date();
        }
        try {
            return retType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (InvocationTargetException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (SecurityException ex) {
            throw new ExceptionReflection(ex);
        }
    }

    public static String getClassNameFromPath(String path) {
        if (path != null && path.lastIndexOf(".") > -1) {
            return path.substring(path.lastIndexOf(".") + 1);
        }
        return null;
    }

    public static boolean isPrimitiveIntNumber(Object ob) {
        if (ob == null) {
            return false;
        }
        return Number.class.isAssignableFrom(ob.getClass()) && !ToolReflections.isPrimitiveDecNumber(ob);
    }

    public static boolean isPrimitiveDecNumber(Object ob) {
        if (ob == null) {
            return false;
        }
        return Float.class.isAssignableFrom(ob.getClass()) || Double.class.isAssignableFrom(ob.getClass());
    }

    public static boolean isPrimitiveDate(Object ob) {
        if (ob == null) {
            return false;
        }
        return Date.class.isAssignableFrom(ob.getClass());
    }

    public static boolean isPrimitiveNumber(String classeParametro) throws ExceptionReflection {
        if (classeParametro == null) {
            return false;
        }
        for (Class<?> clazz : ToolReflections.getPrimitiveClassNumber()) {
            if (!clazz.getCanonicalName().equalsIgnoreCase(classeParametro) && !clazz.getSimpleName().equals(classeParametro)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitiveIntNumber(String classeParametro) throws ExceptionReflection {
        if (classeParametro == null) {
            return false;
        }
        try {
            Class<?> temp = Class.forName(classeParametro);
            return ToolReflections.getPrimitiveClassIntNumber().contains(temp);
        }
        catch (ClassNotFoundException ex) {
            throw new ExceptionReflection(ex);
        }
    }

    public static Method getMethod(Class clazz, String methodName, Class<?> ... parameterTypes) throws ExceptionReflection {
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new ExceptionReflection(ex);
        }
    }
}

