/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.textfile.genericreader.model;

import com.touchcomp.basementorexceptions.exceptions.impl.parse.ExceptionParseObject;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.textfile.genericreader.model.TextLineConfig;
import com.touchcomp.basementortools.tools.textfile.genericreader.model.TextLineGenericReader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Date;

public class TextLineRegGenericReader {
    private final String data;
    private final TextLineGenericReader lineReader;
    private final TextLineConfig.Reg regConfig;

    public TextLineRegGenericReader(TextLineGenericReader lineReader, String data, TextLineConfig.Reg regConfig) {
        this.lineReader = lineReader;
        this.data = data;
        this.regConfig = regConfig;
    }

    public String getData() {
        return this.data;
    }

    public TextLineGenericReader getLineReader() {
        return this.lineReader;
    }

    public int asInt() {
        String tmp = this.data;
        tmp = tmp == null || tmp.isEmpty() ? "0" : tmp;
        return Integer.parseInt(tmp);
    }

    public short asShort() {
        String tmp = this.data;
        tmp = tmp == null || tmp.isEmpty() ? "0" : tmp;
        return Short.parseShort(tmp);
    }

    public long asLong() {
        String tmp = this.data;
        tmp = tmp == null || tmp.isEmpty() ? "0" : tmp;
        return Long.parseLong(tmp);
    }

    public double asDouble() throws ExceptionParseObject {
        String tmp = this.data;
        return this.asDoubleInternal(tmp);
    }

    private double asDoubleInternal(String tmp) throws ExceptionParseObject {
        tmp = tmp == null || tmp.isEmpty() ? "0" : tmp;
        Character separator = this.getSeparator();
        DecimalFormat d = new DecimalFormat();
        DecimalFormatSymbols symb = DecimalFormatSymbols.getInstance();
        symb.setDecimalSeparator(separator.charValue());
        d.setDecimalFormatSymbols(symb);
        try {
            return d.parse(tmp).doubleValue();
        }
        catch (ParseException ex) {
            throw new ExceptionParseObject(ex, new Object[]{tmp});
        }
    }

    public double asDouble(String pattern) throws ExceptionParseObject {
        String tmp = this.data;
        tmp = tmp == null || tmp.isEmpty() ? "0" : tmp;
        DecimalFormat d = new DecimalFormat(pattern);
        try {
            return d.parse(tmp).doubleValue();
        }
        catch (ParseException ex) {
            throw new ExceptionParseObject(ex, new Object[]{tmp});
        }
    }

    public float asFloat() throws ExceptionParseObject {
        String tmp = this.data;
        tmp = tmp == null || tmp.isEmpty() ? "0" : tmp;
        Character separator = this.getSeparator();
        try {
            DecimalFormat d = new DecimalFormat();
            DecimalFormatSymbols symb = DecimalFormatSymbols.getInstance();
            symb.setDecimalSeparator(separator.charValue());
            d.setDecimalFormatSymbols(symb);
            return d.parse(tmp).floatValue();
        }
        catch (ParseException ex) {
            throw new ExceptionParseObject(ex, new Object[]{tmp});
        }
    }

    public float asFloat(String pattern) throws ExceptionParseObject {
        String tmp = this.data;
        tmp = tmp == null || tmp.isEmpty() ? "0" : tmp;
        DecimalFormat d = new DecimalFormat(pattern);
        try {
            return d.parse(tmp).floatValue();
        }
        catch (ParseException ex) {
            throw new ExceptionParseObject(ex, new Object[]{tmp});
        }
    }

    public Date asDate() {
        String tmp = this.data;
        tmp = tmp == null || tmp.isEmpty() ? "0" : tmp;
        return ToolDate.strToDate(tmp, this.lineReader.getReader().getDateMask());
    }

    public Date asDateTime() {
        String tmp = this.data;
        tmp = tmp == null || tmp.isEmpty() ? "0" : tmp;
        return ToolDate.strToDate(tmp, this.lineReader.getReader().getDateTimeMask());
    }

    public Date asDate(String mask) {
        String tmp = this.data;
        tmp = tmp == null || tmp.isEmpty() ? "0" : tmp;
        return ToolDate.strToDate(tmp, mask);
    }

    public String asString() {
        String tmp = this.data;
        tmp = tmp == null || tmp.isEmpty() ? "" : tmp;
        return tmp;
    }

    public String toString() {
        return this.data;
    }

    public TextLineConfig.Reg getRegConfig() {
        return this.regConfig;
    }

    private Character getSeparator() {
        Character sep = null;
        if (this.lineReader != null && this.lineReader.getReader() != null) {
            sep = this.lineReader.getReader().getDecSeparator();
        }
        if (sep == null) {
            sep = Character.valueOf('.');
        }
        return sep;
    }

    public Double asDouble(int nrCasas) throws ExceptionParseObject {
        String text = this.asString();
        if (ToolMethods.isStrWithData(text)) {
            String part2;
            String part1 = "0";
            if (text.length() > nrCasas) {
                part1 = text.substring(0, text.length() - nrCasas);
                part2 = text.substring(text.length() - nrCasas);
            } else {
                part2 = text;
            }
            return this.asDoubleInternal(part1 + "." + part2);
        }
        return 0.0;
    }
}

