/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.threadpool;

import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class TaskPoolExecutor {
    private final ExecutorService executor;
    private final List<Throwable> errors = new LinkedList<Throwable>();
    private final List<Task> tasks = new LinkedList<Task>();

    public static TaskPoolExecutor getNew(int numThreads) {
        return new TaskPoolExecutor(numThreads);
    }

    public TaskPoolExecutor(int poolSize) {
        this.executor = Executors.newFixedThreadPool(poolSize);
    }

    public TaskPoolExecutor submitTasks(List<Task> tasks) {
        for (Task task : tasks) {
            this.submitTask(task);
        }
        return this;
    }

    public TaskPoolExecutor submitTasks(Task ... tasks) {
        for (Task task : tasks) {
            this.submitTask(task);
        }
        return this;
    }

    public TaskPoolExecutor waitForCompletion(long timeout, TimeUnit unit) {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return this;
    }

    public TaskPoolExecutor waitForCompletion() {
        this.waitForCompletion(99L, TimeUnit.DAYS);
        return this;
    }

    private void submitTask(Task task) {
        this.tasks.add(task);
        this.executor.submit(() -> {
            try {
                task.toRun.run();
            }
            catch (Throwable t) {
                TLogger.get(this.getClass()).error(t);
                if (t.getCause() != null) {
                    task.setError(t.getCause());
                }
                task.setError(t);
            }
        });
    }

    public boolean hasErrors() {
        return !this.getAllErrors().isEmpty();
    }

    public List<Throwable> getAllErrors() {
        LinkedList<Throwable> all = new LinkedList<Throwable>();
        for (Task task : this.tasks) {
            if (!task.isOnError()) continue;
            all.add(task.error);
        }
        return all;
    }

    public List<Throwable> getDistinctErrors() {
        LinkedList<Throwable> all = new LinkedList<Throwable>();
        for (Throwable erro : this.getAllErrors()) {
            Optional<Throwable> found = all.stream().filter(i -> ToolMethods.isEquals((Object)i.getCause(), (Object)erro.getCause()) && ToolMethods.isEquals((Object)i.getMessage(), (Object)erro.getCause())).findFirst();
            if (found.isPresent()) continue;
            all.add(erro);
        }
        return all;
    }

    public void thowExceptionIfError() throws ExceptionInvalidData {
        if (this.hasErrors()) {
            StringBuilder sb = new StringBuilder();
            for (Throwable error : this.getDistinctErrors()) {
                if (ExceptionBase.class.isAssignableFrom(error.getClass())) {
                    sb.append(((ExceptionBase)error).getFormattedMessage());
                } else if (ExceptionRuntimeBase.class.isAssignableFrom(error.getClass())) {
                    sb.append(((ExceptionRuntimeBase)error).getFormattedMessage());
                } else {
                    sb.append(error.getMessage());
                }
                sb.append("\n");
            }
            throw new ExceptionInvalidData("E.GEN.000028", new Object[]{sb.toString()});
        }
    }

    public static class Task {
        private final Runnable toRun;
        private Throwable error;

        public Task(Runnable toRun) {
            this.toRun = toRun;
        }

        private boolean isOnError() {
            return this.error != null;
        }

        public Throwable getError() {
            return this.error;
        }

        public void setError(Throwable error) {
            this.error = error;
        }
    }
}

