/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.confplanilhaexcelcotcompra;

import com.touchcomp.basementor.constants.enums.modeloplanilhacotacaocompra.EnumConstConfPlanExcelCotCompra;
import com.touchcomp.basementor.model.vo.ConfPlanilhaExcelCotCompra;
import com.touchcomp.basementor.model.vo.ConfPlanilhaExcelCotCompraItem;
import com.touchcomp.basementortools.constants.EnumConstantsSimNao;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ValidConfPlanilhaExcelCotCompra
extends ValidGenericEntitiesImpl<ConfPlanilhaExcelCotCompra> {
    @Override
    protected void isValid(ConfPlanilhaExcelCotCompra vo) {
        this.valid(this.code("V.ERP.1238.001", "descricao"), vo.getDescricao());
        this.valid(this.code("V.ERP.1238.002", "arquivoPlanilha"), vo.getArquivoPlanilha());
        this.validWarn(this.code("V.ERP.1238.008"), (Collection)vo.getItensConf());
        if (ToolMethods.isWithData((Collection)vo.getItensConf())) {
            for (ConfPlanilhaExcelCotCompraItem item : vo.getItensConf()) {
                if (!this.isEquals(item.getUtilizar(), EnumConstantsSimNao.SIM.getValue())) continue;
                if (item.getLinha() <= 0) {
                    this.addError(this.code("V.ERP.1238.003", item.getChave()), item.getChave());
                }
                if (item.getColuna() > 0) continue;
                this.addError(this.code("V.ERP.1238.004", item.getChave()), item.getChave());
            }
            if (!this.contains(EnumConstConfPlanExcelCotCompra.CODIGO_COTACAO.getDescricao(), vo.getItensConf())) {
                this.addError(this.code("V.ERP.1238.005"), EnumConstConfPlanExcelCotCompra.CODIGO_COTACAO.getDescricao());
            }
            if (!this.contains(EnumConstConfPlanExcelCotCompra.CODIGO_FORNECEDOR.getDescricao(), vo.getItensConf())) {
                this.addError(this.code("V.ERP.1238.006"), EnumConstConfPlanExcelCotCompra.CODIGO_FORNECEDOR.getDescricao());
            }
            if (!this.contains(EnumConstConfPlanExcelCotCompra.ID_PRODUTO.getDescricao(), vo.getItensConf())) {
                this.addError(this.code("V.ERP.1238.007"), EnumConstConfPlanExcelCotCompra.ID_PRODUTO.getDescricao());
            }
        }
    }

    private boolean contains(String codigo, List itens) {
        for (Object object : itens) {
            ConfPlanilhaExcelCotCompraItem item = (ConfPlanilhaExcelCotCompraItem)object;
            if (!item.getChave().equalsIgnoreCase(codigo) || !this.isEquals(item.getUtilizar(), EnumConstantsSimNao.SIM.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getSimpleName() {
        return "";
    }
}

