/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.esoccomunicadoacidtrab;

import com.touchcomp.basementor.constants.enums.esocial.EnumConstTipoAcidenteTrabalho;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoaComplementar;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.EsocCatAgenteCausador;
import com.touchcomp.basementor.model.vo.EsocCatPartesAtingidas;
import com.touchcomp.basementor.model.vo.EsocComunicadoAcidTrab;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.impl.endereco.ValidEndereco;
import org.springframework.stereotype.Component;

@Component
public class ValidEsocComunicadoAcidTrab
extends ValidGenericEntitiesImpl<EsocComunicadoAcidTrab> {
    ValidEndereco validEndereco = new ValidEndereco();

    @Override
    protected void isValid(EsocComunicadoAcidTrab vo) {
        this.valid(this.code("V.ERP.1743.001", "colaborador"), vo.getColaborador());
        this.valid(this.code("V.ERP.1743.002", "tipoAcidenteTrabalho"), vo.getTipoAcidenteTrabalho());
        this.valid(this.code("V.ERP.1743.003", "dataHoraAcidente"), vo.getDataHoraAcidente());
        this.valid(this.code("V.ERP.1743.004", "horasTrabAcid"), vo.getHorasTrabAcid());
        this.valid(this.code("V.ERP.1743.005", "tipoCat"), vo.getTipoCat());
        this.valid(this.code("V.ERP.1743.006", "emissorCat"), vo.getEmissorCat());
        if (vo.getTipoCat() != null && TMethods.isEquals((Object)vo.getTipoCat().getCodigo(), (Object)"2")) {
            this.addError(this.code("V.ERP.1743.007", "tipoCat"), vo.getTipoCat());
        }
        if (TMethods.isAffirmative((Number)vo.getObito())) {
            this.valid(this.code("V.ERP.1743.008", "dataObito"), vo.getDataObito());
        }
        this.valid(this.code("V.ERP.1743.009", "codSitGeradoraAcidTrabalho"), vo.getCodSitGeradoraAcidTrabalho());
        this.validAtestado(vo);
        this.valid(this.code("V.ERP.1743.016", "tipoLocalAcidente"), vo.getTipoLocalAcidente());
        this.valid(this.code("V.ERP.1743.017", "pessoaLocalAcidente"), vo.getPessoaLocalAcidente());
        this.valid(this.code("V.ERP.1743.018", "tipoLogradouro"), vo.getTipoLogradouro());
        this.valid((ValidGenericEntitiesImpl)this.validEndereco, (InterfaceVO)vo.getEnderecoLocalAcidente());
        this.validPartesAtingidas(vo);
        this.validAgenteCausador(vo);
        if (vo.getAmbienteTrabalho() != null) {
            this.valid(this.code("V.ERP.1743.022", "lotacaoTributaria"), vo.getAmbienteTrabalho().getLotacaoTributaria());
        }
        if (ToolMethods.isNotNull((Object)vo.getColaborador()).booleanValue() && ToolMethods.isNotNull((Object)vo.getPessoaLocalAcidente()).booleanValue()) {
            this.validEquals(this.code("V.ERP.1743.023"), vo.getColaborador().getPessoa(), vo.getPessoaLocalAcidente());
        }
        this.validPessoaLocalAcidente(vo);
    }

    private void validPartesAtingidas(EsocComunicadoAcidTrab vo) {
        this.validNotEmpty(this.code("V.ERP.1743.019", "partesAtingidas"), vo.getPartesAtingidas());
        if (vo.getPartesAtingidas() != null) {
            for (EsocCatPartesAtingidas e : vo.getPartesAtingidas()) {
                this.valid(this.code("V.ERP.1743.020", "lateralidade"), e.getLateralidade());
            }
        }
    }

    private void validAgenteCausador(EsocComunicadoAcidTrab vo) {
        this.validNotEmpty(this.code("V.ERP.1743.021", "agentesCausadores"), vo.getAgentesCausadores());
        if (ToolMethods.isNotNull((Object)vo.getAgentesCausadores()).booleanValue() && ToolMethods.isNotNull((Object)vo.getTipoAcidenteTrabalho()).booleanValue() && this.isEquals(vo.getTipoAcidenteTrabalho().getCodigo(), EnumConstTipoAcidenteTrabalho.TIPICO.getEnumId())) {
            boolean existAgentCausadorDiferente = false;
            for (EsocCatAgenteCausador e : vo.getAgentesCausadores()) {
                if (!e.getAgenteCausador().getCodigo().startsWith("3")) {
                    existAgentCausadorDiferente = true;
                }
                if (!existAgentCausadorDiferente) continue;
                this.addError(this.code("V.ERP.1743.025"), vo);
            }
        }
    }

    private void validAtestado(EsocComunicadoAcidTrab vo) {
        this.valid(this.code("V.ERP.1743.010", "atestado"), vo.getAtestado());
        if (vo.getAtestado() != null) {
            this.valid(this.code("V.ERP.1743.011", "dataHoraAtend"), vo.getAtestado().getDataHoraAtend());
            this.validGreather0(this.code("V.ERP.1743.012", "duracaoTratamento"), vo.getAtestado().getDuracaoTratamento());
            this.valid(this.code("V.ERP.1743.013", "naturezaLesao"), vo.getAtestado().getNaturezaLesao());
            this.valid(this.code("V.ERP.1743.014", "medicoEmitente"), vo.getAtestado().getMedicoEmitente());
            this.valid(this.code("V.ERP.1743.015", "codigoCid"), vo.getAtestado().getCodigoCid());
        }
    }

    private void validPessoaLocalAcidente(EsocComunicadoAcidTrab vo) {
        if (ToolMethods.isNotNull((Object)vo.getPessoaLocalAcidente()).booleanValue()) {
            this.validNotEquals(this.code("V.ERP.1743.024"), vo.getPessoaLocalAcidente().getComplemento().getTipoPessoa(), EnumConstTipoPessoaComplementar.JURIDICA.getEnumId());
        }
    }

    @Override
    public String getSimpleName() {
        return "1743 - Comunicado Acidente de Trabalho";
    }
}

