/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.eventoosproducaolinhaprod;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.tipoproducaosped.EnumConstTipoProducaoSped;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ColabEvtOsProdLinhaProd;
import com.touchcomp.basementor.model.vo.EventoOsProducaoLinhaProd;
import com.touchcomp.basementor.model.vo.GradeItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.impl.comunicadoproducao.ValidComunicadoProducao;
import org.springframework.stereotype.Component;

@Component
public class ValidEventoOsProducaoLinhaProd
extends ValidGenericEntitiesImpl<EventoOsProducaoLinhaProd> {
    ValidComunicadoProducao validComunicadoProducao;

    public ValidEventoOsProducaoLinhaProd(ValidComunicadoProducao validComunicadoProducao) {
        this.validComunicadoProducao = validComunicadoProducao;
    }

    @Override
    protected void isValid(EventoOsProducaoLinhaProd vo) {
        this.valid(this.code("V.ERP.0428.001", "empresa"), vo.getEmpresa());
        this.valid(this.code("V.ERP.0428.003", "tipoEvento"), vo.getTipoEvento());
        this.valid(this.code("V.ERP.0428.008", "tipoApontEvento"), vo.getTipoApontEvento());
        this.valid(this.code("V.ERP.0428.002", "dataAbertura"), vo.getDataAbertura());
        if (vo.getDataFechamento() != null) {
            this.validBeforeEqual(this.code("V.ERP.0428.012", "dataAbertura"), vo.getDataAbertura(), vo.getDataFechamento(), new Object[0]);
        }
        if (vo.getComunicadoProducao() != null) {
            this.valid(this.code("V.ERP.0428.002", "dataFechamento"), vo.getDataFechamento());
        }
        this.valid(this.code("V.ERP.0428.007", "subdivisaoOSProd"), vo.getSubdivisaoOSProd());
        this.valid(this.code("V.ERP.0428.004", "faseProdutiva"), vo.getFaseProdutiva());
        this.valid(this.code("V.ERP.0428.005", "horaEvento"), vo.getHoraEvento());
        this.valid(this.code("V.ERP.0428.006", "horaEventoRoteiro"), vo.getHoraEventoRoteiro());
        if (vo.getComunicadoProducao() != null) {
            this.valid((ValidGenericEntitiesImpl)this.validComunicadoProducao, (InterfaceVO)vo.getComunicadoProducao());
        }
        this.validColaboradores(vo);
        this.validarTodosItensFormReq(vo);
        this.validarQdeApontamentoVersusSubOS(vo);
    }

    private void validColaboradores(EventoOsProducaoLinhaProd vo) {
        if (this.getSharedObjects() == null) {
            return;
        }
        OpcoesPCP opcoes = this.getSharedObjects().getOpcoesPCP(vo.getEmpresa());
        if (opcoes == null || !this.isAffirmative(opcoes.getObrigarInformarColEvtProd())) {
            return;
        }
        if (this.valid(this.code("V.ERP.0428.009", "colaboradoresEvtProd"), (Object)vo.getColaboradoresEvtProd())) {
            for (ColabEvtOsProdLinhaProd colab : vo.getColaboradoresEvtProd()) {
                this.valid(this.code("V.ERP.0428.009", "colaborador"), colab.getColaborador());
            }
        }
    }

    private void validarTodosItensFormReq(EventoOsProducaoLinhaProd vo) {
        if (vo.getComunicadoProducao() == null) {
            return;
        }
        if (this.getSharedObjects() == null) {
            return;
        }
        for (ItemComunicadoProducao itemC : vo.getComunicadoProducao().getItemComunicadoProducao()) {
            if (this.isEquals(EnumConstTipoProducaoSped.PRODUCAO_INTERNA_DESMANCHE, EnumConstTipoProducaoSped.get((Object)vo.getComunicadoProducao().getTipoProducaoSped().getCodigo()))) continue;
            this.validNotEmpty(this.code("V.ERP.0428.013", itemC.getProduto()), itemC.getRequisicoes());
        }
    }

    @Override
    public String getSimpleName() {
        return "";
    }

    private void validarQdeApontamentoVersusSubOS(EventoOsProducaoLinhaProd vo) {
        if (this.getSharedObjects() == null) {
            return;
        }
        if (vo.getComunicadoProducao() == null) {
            return;
        }
        OpcoesPCP opcoes = this.getSharedObjects().getOpcoesPCP(vo.getEmpresa());
        if (opcoes == null || this.isEquals(opcoes.getValidarQtdSubos(), EnumConstantsMentorSimNao.SIM.getValue())) {
            Double quantidadeTotal = 0.0;
            if (ToolMethods.isNotNull((Object)vo.getComunicadoProducao()).booleanValue()) {
                for (ItemComunicadoProducao i : vo.getComunicadoProducao().getItemComunicadoProducao()) {
                    for (GradeItemComunicadoProducao g : i.getGradeItemComunicadoProducao()) {
                        quantidadeTotal = quantidadeTotal + g.getQuantidade();
                    }
                }
            }
            if (ToolMethods.isNotNull((Object)vo.getSubdivisaoOSProd()).booleanValue()) {
                for (EventoOsProducaoLinhaProd e : vo.getSubdivisaoOSProd().getEventosOs()) {
                    if (e.getComunicadoProducao() == null || this.isEquals(vo.getComunicadoProducao(), e.getComunicadoProducao())) continue;
                    for (ItemComunicadoProducao i : e.getComunicadoProducao().getItemComunicadoProducao()) {
                        for (GradeItemComunicadoProducao g : i.getGradeItemComunicadoProducao()) {
                            quantidadeTotal = quantidadeTotal + g.getQuantidade();
                        }
                    }
                }
            }
            if (quantidadeTotal > vo.getSubdivisaoOSProd().getQuantidadePrevista()) {
                this.addError(this.code("V.ERP.0428.011"), vo.getSubdivisaoOSProd().getQuantidadePrevista());
            }
        }
    }
}

