/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.expedicao;

import com.touchcomp.basementor.model.vo.EmbalagemExpedicao;
import com.touchcomp.basementor.model.vo.Expedicao;
import com.touchcomp.basementor.model.vo.GradeItemPedido;
import com.touchcomp.basementor.model.vo.GradeItemPedidoLoteFab;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.PreFaturamentoNFItem;
import com.touchcomp.basementor.model.vo.PreFaturamentoNFItemGrade;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class ValidExpedicao
extends ValidGenericEntitiesImpl<Expedicao> {
    @Override
    protected void isValid(Expedicao entity) {
        Double quantidadeTotal;
        if (ToolMethods.isNotNull((Object)entity.getPedido()).booleanValue()) {
            this.valid(this.code("V.ERP.0226.001"), entity.getPedido().getSituacaoPedido());
            this.validNotEmpty(this.code("V.ERP.0226.002"), entity.getPedido().getItemPedido());
            for (ItemPedido itemPedido : entity.getPedido().getItemPedido()) {
                for (GradeItemPedido gradeItemPedido : itemPedido.getGradeItemPedido()) {
                    if (ToolMethods.isNotNull((Object)this.getSharedObjects().getOpcoesFaturamento(entity.getEmpresa())).booleanValue() && this.isAffirmative(this.getSharedObjects().getOpcoesFaturamento(entity.getEmpresa()).getBloquearExpedicaoSemLoteFabricacao()) && !this.isAffirmative(itemPedido.getProduto().getLoteUnico())) {
                        this.validNotEmpty(this.code("V.ERP.0226.006", itemPedido.getProduto()), gradeItemPedido.getLotesFabricacao());
                    }
                    if (!ToolMethods.isWithData((Collection)gradeItemPedido.getLotesFabricacao()) || !(Math.abs((quantidadeTotal = Double.valueOf(gradeItemPedido.getLotesFabricacao().stream().mapToDouble(GradeItemPedidoLoteFab::getQuantidade).sum())) - itemPedido.getQuantidadeTotal()) > 0.01)) continue;
                    this.addError(this.code("V.ERP.0226.008", itemPedido.getProduto()), itemPedido.getProduto());
                }
            }
            Double pesoLiquidoTotal = entity.getEmbalagemExpedicao().stream().mapToDouble(EmbalagemExpedicao::getPesoLiquido).sum();
            if (Math.abs(pesoLiquidoTotal - entity.getPedido().getPesoTotal()) > 0.01) {
                this.addError(this.code("V.ERP.0226.009", entity.getPedido().getPesoTotal(), pesoLiquidoTotal), entity.getPedido());
            }
        }
        if (ToolMethods.isNotNull((Object)entity.getPreFaturamentoNF()).booleanValue()) {
            this.validNotEmpty(this.code("V.ERP.0226.003"), entity.getPreFaturamentoNF().getItens());
            for (PreFaturamentoNFItem preFaturamentoNFItem : entity.getPreFaturamentoNF().getItens()) {
                for (PreFaturamentoNFItemGrade preFaturamentoNFItemGrade : preFaturamentoNFItem.getGrades()) {
                    if (ToolMethods.isNotNull((Object)this.getSharedObjects().getOpcoesFaturamento(entity.getEmpresa())).booleanValue() && this.isAffirmative(this.getSharedObjects().getOpcoesFaturamento(entity.getEmpresa()).getBloquearExpedicaoSemLoteFabricacao()) && !this.isAffirmative(preFaturamentoNFItem.getProduto().getLoteUnico())) {
                        this.valid(this.code("V.ERP.0226.007", preFaturamentoNFItem.getProduto()), preFaturamentoNFItemGrade.getLoteFabricacao());
                    }
                    if (!(Math.abs((quantidadeTotal = Double.valueOf(preFaturamentoNFItem.getGrades().stream().mapToDouble(PreFaturamentoNFItemGrade::getQuantidade).sum())) - preFaturamentoNFItem.getQuantidadeTotal()) > 0.01)) continue;
                    this.addError(this.code("V.ERP.0226.008", preFaturamentoNFItem.getProduto()), preFaturamentoNFItem.getProduto());
                }
            }
        }
        this.validNotEmpty(this.code("V.ERP.0226.004"), entity.getEmbalagemExpedicao());
        for (EmbalagemExpedicao embalagemExpedicao : entity.getEmbalagemExpedicao()) {
            this.valid(this.code("V.ERP.0226.005", embalagemExpedicao.getNrEmbalagem()), embalagemExpedicao.getEmbalagem());
        }
        if (this.isEquals(entity.getTipoConferencia(), (short)3)) {
            this.valid(this.code("V.ERP.0226.010"), entity.getJustificativa());
        }
        Optional.ofNullable(entity.getEmbalagemExpedicao()).orElse(Collections.emptyList()).stream().filter(emb -> this.isAffirmative(emb.getLacraEmbalagem())).forEach(emb -> this.validNotEmpty(this.code("V.ERP.0226.011"), emb.getItemEmbalagemExpedicao()));
    }

    @Override
    public String getSimpleName() {
        return "Expedi\u00e7\u00e3o";
    }
}

