/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.fechamentoordemservico;

import com.touchcomp.basementor.constants.enums.opcoesmanutencaoativos.EnumConstTipoMovimentoConsumo;
import com.touchcomp.basementor.model.vo.Executante;
import com.touchcomp.basementor.model.vo.FechamOrdemServicoColeta;
import com.touchcomp.basementor.model.vo.FechamentoOrdemServico;
import com.touchcomp.basementor.model.vo.HoraParadaRetornoAtivo;
import com.touchcomp.basementor.model.vo.OcorrenciaCausa;
import com.touchcomp.basementor.model.vo.Procedimento;
import com.touchcomp.basementor.model.vo.ProdutoPrevManutencao;
import com.touchcomp.basementor.model.vo.ServicoProcedimento;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ValidFechamentoOrdemServico
extends ValidGenericEntitiesImpl<FechamentoOrdemServico> {
    @Override
    protected void isValid(FechamentoOrdemServico vo) {
        this.valid(this.code("V.ERP.0742.001", "ordemServico"), vo.getOrdemServico());
        this.validaHoraParada(vo);
        this.validNotEmpty(this.code("V.ERP.0742.005", "servicoProcedimentos"), vo.getServicoProcedimentos());
        if (!this.validaOcorrenciaCausa(vo.getServicoProcedimentos()).booleanValue()) {
            this.newMessageItem(this.code("V.ERP.0742.006"), vo.getServicoProcedimentos());
        }
        if (!this.validaDataReal(vo.getServicoProcedimentos()).booleanValue()) {
            this.newMessageItem(this.code("V.ERP.0742.007"), vo.getServicoProcedimentos());
        }
        if (this.isAffirmative(vo.getOsFechada())) {
            this.validNotEmpty(this.code("V.ERP.0742.008", "executantes"), vo.getExecutantes());
        }
        if (vo.getExecutantes() != null) {
            String msgValValorExec;
            if (!this.validaDataHoraExecutante(vo.getExecutantes()).booleanValue()) {
                this.newMessageItem(this.code("V.ERP.0742.009"), vo.getExecutantes());
            }
            if (!(msgValValorExec = this.validaValorExecutante(vo.getExecutantes())).isEmpty()) {
                this.newMessageItem(this.code("V.ERP.0742.010", msgValValorExec), vo.getExecutantes());
            }
        }
        if (!this.validaServicosExecutados(vo).booleanValue()) {
            this.newMessageItem(this.code("V.ERP.0742.012"), vo.getServicoProcedimentos());
        }
        this.validaOutrosItens(vo);
        this.validaColetas(vo);
    }

    void validaColetas(FechamentoOrdemServico vo) {
        if (vo.getFechamOrdemServicoColeta() != null && !vo.getFechamOrdemServicoColeta().isEmpty()) {
            for (FechamOrdemServicoColeta f : vo.getFechamOrdemServicoColeta()) {
                this.valid(this.code("V.ERP.0742.018", "tipoPontoControle"), f.getTipoPontoControle());
                this.valid(this.code("V.ERP.0742.019", "dataHoraColeta"), f.getDataHoraColeta());
                this.valid(this.code("V.ERP.0742.020", "valorColeta"), f.getValorColeta());
                this.validGreather0(this.code("V.ERP.0742.021", "valorColeta"), f.getValorColeta());
            }
        }
    }

    void validaOutrosItens(FechamentoOrdemServico vo) {
        if (this.isAffirmative(vo.getOsFechada()) && vo.getServicoProcedimentos() != null) {
            for (ServicoProcedimento servicoProcedimento : vo.getServicoProcedimentos()) {
                if (servicoProcedimento.getProcedimento() == null) continue;
                for (Procedimento procedimento : servicoProcedimento.getProcedimento()) {
                    if (servicoProcedimento.getProcedimento() == null) continue;
                    for (ProdutoPrevManutencao pr : procedimento.getProdutosPrevisaoManutencao()) {
                        if (pr.getQtdReal() == null || pr.getQtdReal() <= 0.0) {
                            this.newMessageItem(this.code("V.ERP.0742.014", pr.getGradeCor().getProdutoGrade().getProduto().toString()), pr.getQtdReal());
                        }
                        if (pr.getTipoMovProdutoCons() == null) {
                            this.newMessageItem(this.code("V.ERP.0742.015", pr.getGradeCor().getProdutoGrade().getProduto().toString()), pr.getTipoMovProdutoCons());
                        }
                        if (!this.isEquals(pr.getTipoMovProdutoCons(), EnumConstTipoMovimentoConsumo.CONSUMO_INTERNO.getValue())) continue;
                        if (pr.getNaturezaRequisicao() == null) {
                            this.newMessageItem(this.code("V.ERP.0742.016", pr.getGradeCor().getProdutoGrade().getProduto().toString()), pr.getNaturezaRequisicao());
                        }
                        if (pr.getLoteFabricacao() != null) continue;
                        this.newMessageItem(this.code("V.ERP.0742.017", pr.getGradeCor().getProdutoGrade().getProduto().toString()), pr.getLoteFabricacao());
                    }
                }
            }
        }
    }

    Boolean validaServicosExecutados(FechamentoOrdemServico vo) {
        if (this.isAffirmative(vo.getOsFechada()) && vo.getServicoProcedimentos() != null) {
            for (ServicoProcedimento servicoProcedimento : vo.getServicoProcedimentos()) {
                if (servicoProcedimento.getExecutado() != null) continue;
                return false;
            }
        }
        return true;
    }

    String validaValorExecutante(List<Executante> executantes) {
        Object msgColInv = "";
        if (executantes != null) {
            for (Executante executante : executantes) {
                if (executante.getFechamentoOrdemServico() == null || executante.getFechamentoOrdemServico().getOrdemServico() == null || executante.getFechamentoOrdemServico().getOrdemServico().getTipoServico() == null) continue;
                Short tipoServicoOS = executante.getFechamentoOrdemServico().getOrdemServico().getTipoServico().getTipoServicoOS();
                Boolean tipoServicoNaoObrigarValorHFechamento = this.isEquals(tipoServicoOS, (short)5);
                if (executante.getValorHora() != null && (!executante.getValorHora().equals(0.0) || tipoServicoNaoObrigarValorHFechamento.booleanValue()) && executante.getValorTotal() != null && (!executante.getValorTotal().equals(0.0) || tipoServicoNaoObrigarValorHFechamento.booleanValue())) continue;
                msgColInv = executante.getColaborador() != null ? (String)msgColInv + "Colaborador: " : (String)msgColInv + "Pessoa: ";
                msgColInv = (String)msgColInv + String.valueOf(executante.getPessoa()) + "\n";
            }
        }
        return msgColInv;
    }

    Boolean validaDataHoraExecutante(List<Executante> executantes) {
        for (Executante executante : executantes) {
            if (executante.getDataHoraInicio() != null && !executante.getDataHoraInicio().after(new Date()) && executante.getDataHoraFinal() != null && !executante.getDataHoraFinal().after(new Date()) && !executante.getDataHoraFinal().before(executante.getDataHoraInicio()) && !executante.getDataHoraFinal().equals(executante.getDataHoraInicio())) continue;
            return false;
        }
        return true;
    }

    Boolean validaDataReal(List<ServicoProcedimento> servicoProcedimentos) {
        if (servicoProcedimentos != null) {
            for (ServicoProcedimento servicoProcedimento : servicoProcedimentos) {
                for (Procedimento procedimento : servicoProcedimento.getProcedimento()) {
                    for (ProdutoPrevManutencao produtoPrevManutencao : procedimento.getProdutosPrevisaoManutencao()) {
                        if (produtoPrevManutencao.getQtdReal() != null) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    void validaHoraParada(FechamentoOrdemServico vo) {
        if (vo.getHoraParadaRetornoAtivo() != null) {
            for (HoraParadaRetornoAtivo hora : vo.getHoraParadaRetornoAtivo()) {
                if (hora.getDataParadaAtivo() != null && hora.getDataRetornoAtivo() == null) {
                    this.newMessageItem(this.code("V.ERP.0742.003", "horaParadaRetornoAtivo"), hora.getDataParadaAtivo());
                    return;
                }
                if (!hora.getDataRetornoAtivo().before(hora.getDataParadaAtivo())) continue;
                this.newMessageItem(this.code("V.ERP.0742.004", "horaParadaRetornoAtivo"), vo.getHoraParadaRetornoAtivo());
                return;
            }
        }
    }

    Boolean validaOcorrenciaCausa(List<ServicoProcedimento> servicoProcedimentos) {
        if (servicoProcedimentos != null) {
            for (ServicoProcedimento servicoProcedimento : servicoProcedimentos) {
                for (OcorrenciaCausa ocorrenciaCausa : servicoProcedimento.getOcorrenciaCausa()) {
                    if (ocorrenciaCausa.getCausa() != null) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public String getSimpleName() {
        return "Fechamento Ordem Servi\u00e7o";
    }
}

