/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.fornecedor;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.impl.fornecedor.ValidUnidadeFatFornecedor;
import com.touchcomp.basementorvalidator.entities.impl.pessoa.ValidPessoa;
import org.springframework.stereotype.Component;

@Component
public class ValidFornecedor
extends ValidGenericEntitiesImpl<Fornecedor> {
    ValidUnidadeFatFornecedor validUnidadeFat;
    ValidPessoa validPessoa;

    public ValidFornecedor(ValidUnidadeFatFornecedor validUnidadeFat, ValidPessoa validPessoa) {
        this.validUnidadeFat = validUnidadeFat;
        this.validPessoa = validPessoa;
    }

    @Override
    protected void isValid(Fornecedor vo) {
        int unidadesPadroes;
        this.validPessoa.clearContainer();
        if (this.valid(this.code("V.ERP.0077.001 ", "pessoa"), vo.getPessoa()) && this.valid((ValidGenericEntitiesImpl)this.validPessoa, (InterfaceVO)vo.getPessoa())) {
            if (this.isEquals(vo.getAtivo(), (short)1) && this.isEquals(vo.getPessoa().getAtivo(), (short)0)) {
                this.addError(this.code("V.ERP.0077.001", "pessoa.ativo"), vo.getPessoa());
            }
            if (vo.getPessoa().getEndereco().getCidade().getUf() != null && !vo.getPessoa().getEndereco().getCidade().getUf().getSigla().equalsIgnoreCase("EX")) {
                this.valid(this.code("V.ERP.0077.002", "cnpj"), vo.getPessoa().getComplemento().getCnpj());
            }
            if (this.getSharedObjects().getOpcoesRelacionamento(vo.getEmpresa()) != null && this.isAffirmative(this.getSharedObjects().getOpcoesRelacionamento(vo.getEmpresa()).getObrigarEmailFornecedor())) {
                this.validNotEmpty(this.code("V.ERP.0077.003", "pessoa.complemento.emails"), vo.getPessoa().getComplemento().getEmails());
            }
        }
        this.valid(this.code("V.ERP.0077.004", "tipo"), vo.getTipo());
        this.valid(this.code("V.ERP.0077.005", "categoriaPessoa"), vo.getCategoriaPessoa());
        this.validNotEmpty(this.code("V.ERP.0077.006", "unidadesFatForn"), vo.getUnidadesFatForn());
        this.valid(this.code("V.ERP.0077.007", "classificacaoPessoa"), vo.getClassificacaoPessoa());
        if (this.getSharedObjects().getOpcoesCompraSuprimentos(vo.getEmpresa()) != null && this.isAffirmative(this.getSharedObjects().getOpcoesCompraSuprimentos(vo.getEmpresa()).getUsarClassificacaoFornecedor())) {
            this.valid(this.code("V.ERP.0077.008", "classificacaoFornecedor"), vo.getClassificacaoFornecedor());
        }
        if (this.valid((ValidGenericEntitiesImpl)this.validUnidadeFat, vo.getUnidadesFatForn()) && (unidadesPadroes = vo.getUnidadesFatForn().stream().mapToInt(i -> i.getUnidadeFatPadrao().shortValue()).sum()) != 1) {
            this.addError(this.code("V.ERP.0077.010", "unidadeFatPadrao"), vo.getUnidadesFatForn());
        }
    }

    @Override
    public String getSimpleName() {
        return "";
    }
}

