/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.meiopagamento;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.meiopagamento.EnumConstTipoIntegracaoAutomacao;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoPagNFe;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstGerarDocFinanceiro;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import org.springframework.stereotype.Component;

@Component
public class ValidMeioPagamento
extends ValidGenericEntitiesImpl<MeioPagamento> {
    @Override
    protected void isValid(MeioPagamento vo) {
        this.valid(this.code("V.ERP.1552.001", "descricao"), vo.getDescricao());
        if (this.isEquals(vo.getAlterarPessoaTitulo(), EnumConstantsMentorSimNao.SIM.getValue())) {
            this.valid(this.code("V.ERP.1552.002", "pessoa"), vo.getPessoa());
            this.valid(this.code("V.ERP.1552.003", "planoConta"), vo.getPlanoConta());
        }
        this.valid(this.code("V.ERP.1552.004", "tipoPagamento"), vo.getTipoPagamentoNFe());
        this.valid(this.code("V.ERP.1552.005", "gerarFinanceiro"), vo.getGerarFinanceiro());
        this.valid(this.code("V.ERP.1552.006", "tipoMeioPagamento"), vo.getTipoMeioPagamento());
        if (ToolMethods.isNotNull((Object)vo.getTipoPagamentoNFe()).booleanValue()) {
            if (this.isEquals(vo.getTipoPagamentoNFe().getCartaoDebCred(), EnumConstantsMentorSimNao.SIM.getValue())) {
                this.valid(this.code("V.ERP.1552.007"), vo.getTipoIntegracao());
                if (this.isEquals(vo.getTipoIntegracao(), EnumConstTipoIntegracaoAutomacao.TIPO_PAG_INTEGRADO.getValue())) {
                    this.valid(this.code("V.ERP.1552.008"), vo.getBandeiraCartaoNFe());
                    this.valid(this.code("V.ERP.1552.009"), vo.getCredenciadoraCreditoDebito());
                    this.valid(this.code("V.ERP.1552.010"), vo.getPlanoContaCredenciadoraCreditoDebito());
                }
            }
            if (this.isEquals(vo.getTipoPagamentoNFe().getCodigo(), EnumConstNFeTipoPagNFe.SEM_PAGAMENTO.getCodigo())) {
                this.validNotEquals(this.code("V.ERP.1552.011"), vo.getGerarFinanceiro(), EnumConstGerarDocFinanceiro.NAO_GERAR_DOC_FINANCEIRO.getValue());
            }
        }
    }

    @Override
    public String getSimpleName() {
        return "";
    }
}

