/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.opcoesqrcode;

import com.touchcomp.basementor.constants.enums.opcoesqrcode.EnumConstTokensModeloQrCode;
import com.touchcomp.basementor.model.vo.ModeloQrCode;
import com.touchcomp.basementor.model.vo.OpcoesQrCode;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;

@Component
public class ValidOpcoesQrCode
extends ValidGenericEntitiesImpl<OpcoesQrCode> {
    @Override
    protected void isValid(OpcoesQrCode entity) {
        if (TMethods.isWithData((Collection)entity.getModelos())) {
            for (ModeloQrCode modelo : entity.getModelos()) {
                if (!TMethods.isStrWithData((String)modelo.getParametrizacao())) continue;
                this.validarModelo(modelo);
            }
        }
    }

    public void validarModelo(ModeloQrCode modelo) {
        List<String> tokens = this.extrairTokens(modelo.getParametrizacao());
        HashMap<String, Integer> tokensXocorrencias = new HashMap<String, Integer>();
        for (String token : tokens) {
            if (!this.isEquals(token, "") && TMethods.isNull((Object)EnumConstTokensModeloQrCode.get((String)token)).booleanValue()) {
                this.addError(this.code("V.ERP.2036.002", "modelo.parametrizacao", token, modelo.getDescricao()), token);
                continue;
            }
            if (tokensXocorrencias.containsKey(token)) {
                tokensXocorrencias.put(token, (Integer)tokensXocorrencias.get(token) + 1);
                continue;
            }
            tokensXocorrencias.put(token, 1);
        }
        for (String token : tokensXocorrencias.keySet()) {
            if ((Integer)tokensXocorrencias.get(token) <= 1 || this.isEquals(token, "")) continue;
            this.addError(this.code("V.ERP.2036.003", "modelo.parametrizacao", token, modelo.getDescricao()), token);
        }
    }

    public List<String> extrairTokens(String texto) {
        if (texto == null || texto.isEmpty()) {
            return List.of();
        }
        Pattern pattern = Pattern.compile("\\{([^{}]+)\\}");
        return pattern.matcher(texto).results().map(match -> match.group(1)).toList();
    }

    @Override
    public String getSimpleName() {
        return "2036 - Op\u00e7\u00f5es QrCode";
    }
}

