/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.paramtribcbsibs;

import com.touchcomp.basementor.model.vo.ParamTribCbsIbs;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsCfop;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsClass;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsClassNcm;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsEmp;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.LinkedList;
import org.springframework.stereotype.Component;

@Component
public class ValidParamTribCbsIbs
extends ValidGenericEntitiesImpl<ParamTribCbsIbs> {
    @Override
    protected void isValid(ParamTribCbsIbs vo) {
        this.valid(this.code("V.ERP.2037.001", "descricao"), vo.getDescricao());
        this.valid(this.code("V.ERP.2037.002", "incidenciaTributaria"), vo.getIncidenciaTributaria());
        if (this.valid(this.code("V.ERP.2037.003", "empresas"), (Object)vo.getEmpresas())) {
            this.validarEmpresas(vo);
        }
        if (this.validNotEmpty(this.code("V.ERP.2037.012", "cfops"), vo.getCfops())) {
            this.validarCfops(vo);
        }
        if (this.valid(this.code("V.ERP.2037.004", "classificacoes"), (Object)vo.getClassificacoes())) {
            this.validClassificacoes(vo);
        }
    }

    @Override
    public String getSimpleName() {
        return "";
    }

    private void validarEmpresas(ParamTribCbsIbs vo) {
        for (ParamTribCbsIbsEmp empresa : vo.getEmpresas()) {
            this.valid(this.code("V.ERP.2037.005", "empresas.empresa"), empresa.getEmpresa());
            this.valid(this.code("V.ERP.2037.006", "empresas.dataInicioVigencia"), empresa.getDataInicioVigencia());
        }
    }

    private void validClassificacoes(ParamTribCbsIbs vo) {
        for (ParamTribCbsIbsClass classificacao : vo.getClassificacoes()) {
            this.valid(this.code("V.ERP.2037.007", ".classificacoesclassificacaoTrib"), classificacao.getClassificacaoTrib());
            this.validNCM(classificacao);
        }
    }

    private void validNCM(ParamTribCbsIbsClass vo) {
        if (vo.getNcms() == null) {
            vo.setNcms(new LinkedList());
        }
        if (vo.getNbs() == null) {
            vo.setNbs(new LinkedList());
        }
        for (ParamTribCbsIbsClassNcm classificacao : vo.getNcms()) {
            this.valid(this.code("V.ERP.2037.008", "ncms.ncm"), classificacao.getNcm());
            this.valid(this.code("V.ERP.2037.009", "ncms.dataInicioVigencia"), classificacao.getDataInicioVigencia());
        }
        for (ParamTribCbsIbsClassNcm classificacao : vo.getNbs()) {
            this.valid(this.code("V.ERP.2037.010", "nbs.nbs"), classificacao.getNbs());
            this.valid(this.code("V.ERP.2037.011", "nbs.dataInicioVigencia"), classificacao.getDataInicioVigencia());
        }
    }

    private void validarCfops(ParamTribCbsIbs vo) {
        for (ParamTribCbsIbsCfop cfop : vo.getCfops()) {
            this.valid(this.code("V.ERP.2037.013", "cfops.cfop"), cfop.getCfop());
            this.valid(this.code("V.ERP.2037.014", "cfops.dataInicioVigencia"), cfop.getDataInicioVigencia());
        }
    }
}

