/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.pessoa;

import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoa;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.impl.complemento.ValidComplemento;
import com.touchcomp.basementorvalidator.entities.impl.endereco.ValidEndereco;
import org.springframework.stereotype.Component;

@Component
public class ValidPessoa
extends ValidGenericEntitiesImpl<Pessoa> {
    ValidEndereco validEndereco;
    ValidComplemento validComplemento;

    public ValidPessoa(ValidEndereco validEndereco, ValidComplemento validComplemento) {
        this.validEndereco = validEndereco;
        this.validComplemento = validComplemento;
    }

    @Override
    protected void isValid(Pessoa vo) {
        this.valid(this.code("V.ERP.0047.001", "nome"), vo.getNome());
        this.valid(this.code("V.ERP.0047.002", "tipoPessoa"), vo.getTipoPessoa());
        if (this.isEquals(vo.getTipoPessoa(), EnumConstTipoPessoa.PESSOA_SECUNDARIA.value)) {
            this.valid(this.code("V.ERP.0047.003", "nomeFantasia"), vo.getNomeFantasia());
        }
        this.valid(this.code("V.ERP.0047.004", "endereco"), vo.getEndereco());
        this.valid(this.code("V.ERP.0047.005", "complemento"), vo.getComplemento());
        this.valid((ValidGenericEntitiesImpl)this.validEndereco, (InterfaceVO)vo.getEndereco());
        this.valid((ValidGenericEntitiesImpl)this.validComplemento, (InterfaceVO)vo.getComplemento());
    }

    @Override
    public String getSimpleName() {
        return "pessoa";
    }
}

