/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.reinfr2060;

import com.touchcomp.basementor.model.vo.ReinfR2060;
import com.touchcomp.basementor.model.vo.ReinfR2060Item;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class ValidReinfR2060
extends ValidGenericEntitiesImpl<ReinfR2060> {
    @Override
    protected void isValid(ReinfR2060 vo) {
        this.valid(this.code("V.ERP.1720.001", "periodo"), vo.getPeriodo());
        this.validNotEmpty(this.code("V.ERP.1720.002", "itens"), vo.getItens());
        this.validarItens(vo);
    }

    private void validarItens(ReinfR2060 vo) {
        if (TMethods.isWithData((Collection)vo.getItens())) {
            Double valor = 0.0;
            for (ReinfR2060Item i : vo.getItens()) {
                if (i.getValorContribPrev() != null) {
                    valor = valor + i.getValorContribPrev();
                }
                this.valid(this.code("V.ERP.1720.003", "reinfCodAtividadeEconomica"), i.getReinfCodAtividadeEconomica());
            }
            this.validNotEquals(this.code("V.ERP.1720.004", "valorContribPrevTotal"), ToolFormatter.arrredondarNumero((Double)valor, (int)2), ToolFormatter.arrredondarNumero((Double)vo.getValorContribPrevTotal(), (int)2));
        }
    }

    @Override
    public String getSimpleName() {
        return "1720 - Reinf R-2060";
    }
}

