/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.relacionamentopessoa;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.ItemInfAdicionalItemRelPes;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoa;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoaGC;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoaLog;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class ValidRelacionamentoPessoa
extends ValidGenericEntitiesImpl<RelacionamentoPessoa> {
    @Override
    protected void isValid(RelacionamentoPessoa vo) {
        this.valid(this.code("V.ERP.0442.001", "setor"), vo.getSetor());
        this.valid(this.code("V.ERP.0442.002", "classificacaoMarketing"), vo.getClassificacaoMarketing());
        this.valid(this.code("V.ERP.0442.003", "procedenciaSolicitacao"), vo.getProcedenciaSolicitacao());
        this.valid(this.code("V.ERP.0442.004", "pessoa"), vo.getPessoa());
        this.valid(this.code("V.ERP.0442.005", "prioridadeMarketing"), vo.getPrioridadeMarketing());
        this.valid(this.code("V.ERP.0442.006", "assunto"), vo.getAssunto());
        if (TMethods.isAffirmative((Number)vo.getSolucionado())) {
            this.valid(this.code("V.ERP.0442.007", "solucao"), vo.getSolucao());
        }
        this.validarProdutos(vo);
        this.validarAgendamentosPendentes(vo);
        this.validarInfAdicionaisRelacionamento(vo);
    }

    private void validarInfAdicionaisRelacionamento(RelacionamentoPessoa vo) {
        if (TMethods.isWithData((Collection)vo.getItensInfAdicional())) {
            for (ItemInfAdicionalItemRelPes infAdicional : vo.getItensInfAdicional()) {
                if (!TMethods.isAffirmative((Number)infAdicional.getValorObrigatorio())) continue;
                this.valid(this.code("V.ERP.0442.008", "valor", infAdicional.getItensModeloFichaTecnica().getDescricao()), infAdicional.getValor());
                if (!TMethods.isNotNull((Object)infAdicional.getValor()).booleanValue() || !ToolString.isADoubleNumber((String)infAdicional.getValor()) || !TMethods.isNotNull((Object)infAdicional.getItensModeloFichaTecnica()).booleanValue()) continue;
                this.validMin(this.code("V.ERP.0442.009", "valor", infAdicional.getItensModeloFichaTecnica().getDescricao(), infAdicional.getItensModeloFichaTecnica().getValorMinimo()), Double.valueOf(infAdicional.getValor()), infAdicional.getItensModeloFichaTecnica().getValorMinimo());
                this.validMax(this.code("V.ERP.0442.010", "valor", infAdicional.getItensModeloFichaTecnica().getDescricao(), infAdicional.getItensModeloFichaTecnica().getValorMaximo()), Double.valueOf(infAdicional.getValor()), infAdicional.getItensModeloFichaTecnica().getValorMaximo());
            }
        }
    }

    private void validarAgendamentosPendentes(RelacionamentoPessoa vo) {
        if (TMethods.isWithData((Collection)vo.getAgendamentos())) {
            if (TMethods.isAffirmative((Number)vo.getSolucionado())) {
                for (RelacionamentoPessoaLog agendamento : vo.getAgendamentos()) {
                    if (TMethods.isEquals((Object)agendamento.getFinalizado(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) continue;
                    this.addError(this.code("V.ERP.0442.011", "finalizado"), agendamento.getFinalizado());
                    break;
                }
            } else {
                Boolean todosAgFinalizados = true;
                for (RelacionamentoPessoaLog agendamento : vo.getAgendamentos()) {
                    if (TMethods.isAffirmative((Number)agendamento.getFinalizado())) continue;
                    todosAgFinalizados = false;
                    break;
                }
                if (todosAgFinalizados.booleanValue()) {
                    this.addError(this.code("V.ERP.0442.012", "finalizado"), vo.getSolucionado());
                }
            }
        }
    }

    private void validarProdutos(RelacionamentoPessoa vo) {
        if (TMethods.isNotNull((Object)vo.getProcedenciaSolicitacao()).booleanValue() && TMethods.isAffirmative((Number)vo.getProcedenciaSolicitacao().getAssistenciaTecnica())) {
            this.validNotEmpty(this.code("V.ERP.0442.013", "produtos"), vo.getProdutos());
        }
        if (TMethods.isWithData((Collection)vo.getProdutos())) {
            for (RelacionamentoPessoaGC prod : vo.getProdutos()) {
                this.valid(this.code("V.ERP.0442.015", "gradeCor"), prod.getGradeCor());
                if (!TMethods.isNotNull((Object)prod.getGradeCor()).booleanValue()) continue;
                this.validGreather0(this.code("V.ERP.0442.014", "quantidade", String.valueOf(prod.getGradeCor().getProdutoGrade().getProduto())), prod.getQuantidade());
            }
        }
    }

    @Override
    public String getSimpleName() {
        return "442 - CRM/PRM";
    }
}

