/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.rotaclientes;

import com.touchcomp.basementor.model.vo.GrupoCidadesCidade;
import com.touchcomp.basementor.model.vo.RotaClientes;
import com.touchcomp.basementor.model.vo.RotaClientesItem;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class ValidRotaClientes
extends ValidGenericEntitiesImpl<RotaClientes> {
    @Override
    protected void isValid(RotaClientes entity) {
        this.valid(this.code("V.ERP.1384.001", "descricao"), entity.getDescricao());
        this.valid(this.code("V.ERP.1384.002", "representante"), entity.getRepresentante());
        this.validarItens(entity.getItens());
        if (!ToolMethods.isNull((Object)entity.getItens()).booleanValue()) {
            this.validarUnidadeFaturamento(entity.getItens());
            this.validarNrSequencial(entity.getItens());
        }
        this.validarGrupoCidades(entity);
    }

    protected boolean validarItens(List<RotaClientesItem> itens) {
        boolean hasError = false;
        if (!ToolMethods.isWithData(itens)) {
            this.addError(this.code("V.ERP.1384.003", "itens"), itens);
            hasError = true;
        }
        return hasError;
    }

    protected boolean validarUnidadeFaturamento(List<RotaClientesItem> itens) {
        boolean hasError = false;
        Optional<RotaClientesItem> hasUnidadeFatNull = itens.stream().filter(x -> ToolMethods.isNull((Object)x.getUnidadeFatCliente())).findFirst();
        if (hasUnidadeFatNull.isPresent()) {
            this.addError(this.code("V.ERP.1384.005", "unidadeFatCliente"), hasUnidadeFatNull.get());
            hasError = true;
        }
        return hasError;
    }

    protected boolean validarNrSequencial(List<RotaClientesItem> itens) {
        boolean hasError = false;
        Optional<RotaClientesItem> hasNrSequencialNull = itens.stream().filter(x -> ToolMethods.isNull((Object)x.getNrSequencial())).findFirst();
        if (hasNrSequencialNull.isPresent()) {
            this.addError(this.code("V.ERP.1384.006", "nrSequencial"), hasNrSequencialNull.get());
            hasError = true;
        }
        return hasError;
    }

    protected boolean validarGrupoCidades(RotaClientes entity) {
        boolean hasError = false;
        if (ToolMethods.isNull((Object)entity.getGrupoCidades()).booleanValue() || entity.getGrupoCidades().getCidades().size() <= 0) {
            this.addError(this.code("V.ERP.1384.004", "cidades"), entity.getGrupoCidades());
            hasError = true;
        } else {
            List cidades = entity.getGrupoCidades().getCidades();
            Optional<GrupoCidadesCidade> hasCidadeNull = cidades.stream().filter(x -> ToolMethods.isNull((Object)x.getCidade())).findFirst();
            if (hasCidadeNull.isPresent()) {
                this.addError(this.code("V.ERP.1384.004", "cidades"), hasCidadeNull.get());
                hasError = true;
            }
        }
        return hasError;
    }

    @Override
    public String getSimpleName() {
        return "1384";
    }
}

