/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.ticketfiscal;

import com.touchcomp.basementor.constants.enums.ticketfiscal.EnumConstTicketFiscalStatus;
import com.touchcomp.basementor.model.vo.ObsTicketFiscal;
import com.touchcomp.basementor.model.vo.OpcoesTicketFiscal;
import com.touchcomp.basementor.model.vo.PedidoTicketFiscal;
import com.touchcomp.basementor.model.vo.TicketFiscal;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class ValidTicketFiscal
extends ValidGenericEntitiesImpl<TicketFiscal> {
    @Override
    protected void isValid(TicketFiscal vo) {
        if (ToolMethods.isNull((Object)this.getSharedObjects()).booleanValue()) {
            return;
        }
        OpcoesTicketFiscal opcoesTicketFiscal = this.getSharedObjects().getOpcoesTicketFiscal(vo.getEmpresa());
        if (ToolMethods.isNull((Object)opcoesTicketFiscal).booleanValue()) {
            return;
        }
        this.valid(this.code("V.ERP.0518.001", "naturezaOperacaoTicketFiscal"), vo.getNaturezaOperacaoTicketFiscal());
        this.valid(this.code("V.ERP.0518.002", "dataAbertura"), vo.getDataAbertura());
        this.valid(this.code("V.ERP.0518.003", "unidadeFatCliente"), vo.getUnidadeFatCliente());
        if (this.isAffirmative(opcoesTicketFiscal.getValidarInversoPesoTotalTara())) {
            this.validGreather0(this.code("V.ERP.0518.004", "pesoTotal"), vo.getPesoTotal());
        } else {
            this.validGreather0(this.code("V.ERP.0518.005", "pesoVeiculo"), vo.getPesoVeiculo());
        }
        if (this.isAffirmative(opcoesTicketFiscal.getHabPesoEstimadoLiquidoEst())) {
            this.validGreather0(this.code("V.ERP.0518.006", "pesoEstimado"), vo.getPesoEstimado());
            this.validGreather0(this.code("V.ERP.0518.007", "pesoLiquidoEstimado"), vo.getPesoLiquidoEstimado());
        }
        this.validLenghtWarn(this.code("V.ERP.0518.008", "placa"), vo.getPlaca(), 7);
        this.validLenghtWarn(this.code("V.ERP.0518.009", "placaCarreta"), vo.getPlacaCarreta(), 7);
        this.valid(this.code("V.ERP.0518.010", "transportador"), vo.getTransportador());
        this.valid(this.code("V.ERP.0518.011", "motorista"), vo.getMotorista());
        if (ToolMethods.isWithData((Collection)vo.getObsTicketFiscal())) {
            for (ObsTicketFiscal o : vo.getObsTicketFiscal()) {
                if (!ToolMethods.isNull((Object)o.getConteudo()).booleanValue() && !ToolMethods.isWithData((Collection)ToolString.getReplaceTokens((String)o.getConteudo()))) continue;
                this.addError(this.code("V.ERP.0518.012"), vo.getObsTicketFiscal());
            }
        }
        if (this.isAffirmative(opcoesTicketFiscal.getInformarPedido())) {
            this.validNotEmpty(this.code("V.ERP.0518.013", "transportador"), vo.getPedidoTicketFiscal());
        }
        if (this.isEquals(vo.getStatus(), EnumConstTicketFiscalStatus.FECHADA.getValue())) {
            this.valid(this.code("V.ERP.0518.014", "dataFechamento"), vo.getDataFechamento());
            if (this.isAffirmative(opcoesTicketFiscal.getValidarInversoPesoTotalTara())) {
                this.validGreather0(this.code("V.ERP.0518.005", "pesoVeiculo"), vo.getPesoVeiculo());
            } else {
                this.validGreather0(this.code("V.ERP.0518.004", "pesoTotal"), vo.getPesoTotal());
            }
            this.validMin(this.code("V.ERP.0518.015"), vo.getPesoTotal(), vo.getPesoVeiculo());
            if (this.isAffirmative(opcoesTicketFiscal.getInformarPedido())) {
                Double saldoTotal = 0.0;
                for (PedidoTicketFiscal p : vo.getPedidoTicketFiscal()) {
                    saldoTotal = saldoTotal + p.getSaldo();
                }
                this.validMax(this.code("V.ERP.0518.016"), vo.getPesoLiquidoTotal(), saldoTotal);
            }
        }
        if (this.isAffirmative(opcoesTicketFiscal.getHabilitadoPesoTaraTotal()) && this.isAffirmative(vo.getInfManualPeso())) {
            this.valid(this.code("V.ERP.0518.017", "motivoManualPeso"), vo.getMotivoManualPeso());
        }
        this.valid(this.code("V.ERP.0518.018", "loteFabricacao"), vo.getLoteFabricacao());
    }

    @Override
    public String getSimpleName() {
        return "Ticket Fiscal";
    }
}

