/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.transferenciacentroestoque;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.model.vo.GradeItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.ItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.TransferenciaCentroEstoque;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ValidTransferenciaCentroEstoque
extends ValidGenericEntitiesImpl<TransferenciaCentroEstoque> {
    @Override
    protected void isValid(TransferenciaCentroEstoque vo) {
        this.valid(this.code("V.ERP.0818.001"), vo.getDataTransferencia());
        this.valid(this.code("V.ERP.0818.002"), vo.getEmpresa());
        this.validNotEmpty(this.code("V.ERP.0818.003"), vo.getItemTransfCentroEstoque());
        if (ToolMethods.isNotNull((Object)vo.getDestino()).booleanValue() && ToolMethods.isNotNull((Object)vo.getOrigem()).booleanValue()) {
            this.validEquals(this.code("V.ERP.0818.011"), vo.getDestino(), vo.getOrigem());
            this.validNotEquals(this.code("V.ERP.0818.012"), vo.getDestino().getTipoEstProprioTerceiros(), vo.getOrigem().getTipoEstProprioTerceiros());
            if (this.isEquals(vo.getOrigem().getTipoEstProprioTerceiros(), EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_TERCEIROS.getValue())) {
                this.validNotEquals(this.code("V.ERP.0818.013"), vo.getOrigem().getParceiro(), vo.getDestino().getParceiro());
            }
        }
        this.validarItens(vo.getItemTransfCentroEstoque());
    }

    @Override
    public String getSimpleName() {
        return TransferenciaCentroEstoque.class.getSimpleName();
    }

    private void validarItens(List<ItemTransfCentroEstoque> itemTransfCentroEstoque) {
        if (itemTransfCentroEstoque == null) {
            return;
        }
        for (ItemTransfCentroEstoque item : itemTransfCentroEstoque) {
            this.valid(this.code("V.ERP.0818.004"), item.getProduto());
            this.valid(this.code("V.ERP.0818.007"), item.getQuantidadeTotal());
            this.validarGrades(item.getGradeItemTransCentroEst());
        }
    }

    private void validarGrades(List<GradeItemTransfCentroEstoque> gradeItemTransCentroEst) {
        if (gradeItemTransCentroEst == null) {
            return;
        }
        for (GradeItemTransfCentroEstoque gr : gradeItemTransCentroEst) {
            this.valid(this.code("V.ERP.0818.001"), gr.getDataTransferencia());
            this.valid(this.code("V.ERP.0818.005"), gr.getOrigem());
            this.valid(this.code("V.ERP.0818.006"), gr.getDestino());
            this.valid(this.code("V.ERP.0818.002"), gr.getEmpresa());
            this.valid(this.code("V.ERP.0818.008"), gr.getGradeCor());
            this.valid(this.code("V.ERP.0818.009"), gr.getLoteFabricacao());
            this.valid(this.code("V.ERP.0818.010"), gr.getQuantidade());
        }
    }
}

