/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.wmspedido;

import com.touchcomp.basementor.constants.enums.wmspedido.EnumConstTipoMovimentacaoWMS;
import com.touchcomp.basementor.model.vo.WmsPedido;
import com.touchcomp.basementor.model.vo.WmsPedidoItem;
import com.touchcomp.basementor.model.vo.WmsPedidoItemEmb;
import com.touchcomp.basementor.model.vo.WmsPedidoItemGrade;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ValidWmsPedido
extends ValidGenericEntitiesImpl<WmsPedido> {
    @Override
    protected void isValid(WmsPedido vo) {
        this.valid(this.code("V.ERP.1915.001", "empresa"), vo.getEmpresa());
        this.valid(this.code("V.ERP.1915.002", "dataSolicitacao"), vo.getDataSolicitacao());
        this.valid(this.code("V.ERP.1915.003", "usuarioSolicitante"), vo.getUsuarioSolicitante());
        if (this.validNotEmpty(this.code("V.ERP.1915.004", "itens"), vo.getItens())) {
            this.validItens(vo);
            this.validItensEmbalagem(vo.getItens());
        }
        this.valid(this.code("V.ERP.1915.005", "statusPedido"), vo.getStatusPedido());
        this.valid(this.code("V.ERP.1915.013", "descricao"), vo.getDescricao());
        if (vo.getWmsSeparacaoPedido() != null && ToolMethods.isAffirmative((Number)vo.getWmsSeparacaoPedido().getConferenciaFinalizada())) {
            this.addError(this.code("V.ERP.1915.014", "wmsSeparacaoPedido"), vo);
        }
        this.valid(this.code("V.ERP.1915.016"), vo.getTipoMovimentacao());
    }

    private void validItens(WmsPedido vo) {
        for (WmsPedidoItem item : vo.getItens()) {
            this.valid(this.code("V.ERP.1904.006", "produto"), item.getProduto());
            if (this.validNotEmpty(this.code("V.ERP.1912.007", item.getGrades()), item.getGrades())) {
                this.validGrades(item);
            }
            if (!this.isEquals(vo.getTipoMovimentacao(), EnumConstTipoMovimentacaoWMS.TIPO_MOVIMENTACAO_BAIXA_EFETIVA.getEnumId())) continue;
            this.valid(this.code("V.ERP.1822.017", item.getProduto()), item.getCentroCusto());
        }
    }

    private void validGrades(WmsPedidoItem item) {
        for (WmsPedidoItemGrade vo : item.getGrades()) {
            this.valid(this.code("V.ERP.1915.008", "gradeCor"), vo.getGradeCor());
            this.valid(this.code("V.ERP.1915.009", "quantidade"), vo.getQuantidade());
        }
    }

    @Override
    public String getSimpleName() {
        return "1915";
    }

    private void validItensEmbalagem(List<WmsPedidoItem> itens) {
        for (WmsPedidoItem item : itens) {
            if (!ToolMethods.isWithData((Collection)item.getItensEmbalagens())) continue;
            double total = 0.0;
            for (WmsPedidoItemEmb vo : item.getItensEmbalagens()) {
                this.valid(this.code("V.ERP.1915.010", "embalagem"), vo.getEmbalagem());
                this.valid(this.code("V.ERP.1915.011", "nrEmbalagem"), vo.getNrEmbalagem());
                this.valid(this.code("V.ERP.1915.012", "qtdePorEmbalagem"), vo.getQtdePorEmbalagem());
                if (vo.getQtdePorEmbalagem() == null || vo.getNrEmbalagem() == null) continue;
                total += vo.getQtdePorEmbalagem() * (double)vo.getNrEmbalagem().intValue();
            }
            if (!(Math.abs(total - item.getQuantidadeTotal()) > 0.001)) continue;
            this.addError(this.code("V.ERP.1915.015", "qtdePorEmbalagem", total, item.getQuantidadeTotal()), total);
        }
    }
}

