/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.wmstransfestoque;

import com.touchcomp.basementor.model.vo.WmsTransfEstoque;
import com.touchcomp.basementor.model.vo.WmsTransfEstoqueGrade;
import com.touchcomp.basementor.model.vo.WmsTransfEstoqueItem;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import org.springframework.stereotype.Component;

@Component
public class ValidWmsTransfEstoque
extends ValidGenericEntitiesImpl<WmsTransfEstoque> {
    @Override
    protected void isValid(WmsTransfEstoque vo) {
        this.valid(this.code("V.ERP.1904.001", "empresa"), vo.getEmpresa());
        this.valid(this.code("V.ERP.1904.002", "dataTransferencia"), vo.getDataTransferencia());
        if (this.validNotEmpty(this.code("V.ERP.1904.003", "itens"), vo.getItens())) {
            this.validItens(vo);
        }
    }

    private void validItens(WmsTransfEstoque vo) {
        for (WmsTransfEstoqueItem item : vo.getItens()) {
            this.valid(this.code("V.ERP.1904.004", "produto"), item.getProduto());
            this.valid(this.code("V.ERP.1904.005", "wmsEnderecoOrigem"), item.getWmsEnderecoOrigem());
            this.valid(this.code("V.ERP.1904.006", "wmsEnderecoDestino"), item.getWmsEnderecoDestino());
            if (!this.validNotEmpty(this.code("V.ERP.1912.009", item.getProduto()), item.getGrades())) continue;
            this.validGrades(item);
        }
    }

    private void validGrades(WmsTransfEstoqueItem item) {
        for (WmsTransfEstoqueGrade vo : item.getGrades()) {
            this.valid(this.code("V.ERP.1912.001", "empresa"), vo.getEmpresa());
            this.valid(this.code("V.ERP.1904.005", "wmsEnderecoOrigem"), vo.getWmsEnderecoOrigem());
            this.valid(this.code("V.ERP.1904.006", "wmsEnderecoDestino"), vo.getWmsEnderecoDestino());
            this.valid(this.code("V.ERP.1904.007", "loteFabricacao"), vo.getLoteFabricacao());
            this.valid(this.code("V.ERP.1904.008", "gradeCor"), vo.getGradeCor());
            this.valid(this.code("V.ERP.1904.009", "quantidade"), vo.getQuantidade());
            this.valid(this.code("V.ERP.1904.002", "dataEntrada"), vo.getDataTransferencia());
        }
    }

    @Override
    public String getSimpleName() {
        return "transferencia";
    }
}

