/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.model;

import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorvalidator.entities.ValidMessages;
import com.touchcomp.basementorvalidator.entities.model.ValidContainerItem;
import java.util.LinkedList;
import java.util.List;

public class ValidContainer {
    private String descricao;
    private String voClass;
    private List<ValidContainerItem> itens = new LinkedList<ValidContainerItem>();

    public void clear() {
        this.itens = new LinkedList<ValidContainerItem>();
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getVoClass() {
        return this.voClass;
    }

    public void setVoClass(String voClass) {
        this.voClass = voClass;
    }

    public List<ValidContainerItem> getItens() {
        return this.itens;
    }

    public void setItens(List<ValidContainerItem> itens) {
        this.itens = itens;
    }

    public void addItens(List<ValidContainerItem> itens) {
        this.getItens().addAll(itens);
    }

    public String toString() {
        StringBuilder val = new StringBuilder();
        this.getItens().forEach(item -> {
            val.append("* ");
            val.append(item.getCodigo().getCode());
            val.append(" - ");
            val.append(item.getDescricao());
            val.append("\n");
        });
        return val.toString();
    }

    public String asString() {
        StringBuilder sb = new StringBuilder();
        for (ValidContainerItem item : this.itens) {
            sb.append(item.getCodigo().getCode());
            sb.append(" : ");
            sb.append(item.getDescricao());
            sb.append("\n");
        }
        return sb.toString();
    }

    public void add(String codError, Object ... others) {
        String descError = MessagesBaseMentor.getMsg((String)codError, (Object[])others);
        ValidContainerItem item = new ValidContainerItem(new ValidMessages.Code(codError, others), descError);
        this.getItens().add(item);
    }
}

