/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorversao.dao;

import com.touchcomp.basementorversao.dao.DaoVersaoGenericEntity;
import com.touchcomp.basementorversao.dao.DaoVersaoGenericImpl;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.metadata.ClassMetadata;
import org.springframework.stereotype.Repository;

@Repository
public abstract class DaoVersaoGenericEntityImpl<E, K extends Serializable>
extends DaoVersaoGenericImpl
implements DaoVersaoGenericEntity<E, K> {
    protected Class<? extends E> voClass;

    public DaoVersaoGenericEntityImpl() {
        Type t = this.getClass().getGenericSuperclass();
        ParameterizedType pt = (ParameterizedType)t;
        this.voClass = (Class)pt.getActualTypeArguments()[0];
    }

    @Override
    public E saveOrUpdate(E entity) {
        return (E)this.getSession().merge(entity);
    }

    @Override
    public List<E> saveOrUpdate(Collection<E> entity) {
        LinkedList temp = new LinkedList();
        entity.forEach(i -> temp.add(this.saveOrUpdate(i)));
        return temp;
    }

    @Override
    public boolean delete(E entity) {
        this.getSession().delete(entity);
        return true;
    }

    @Override
    public boolean delete(Collection<E> entity) {
        entity.forEach(i -> this.delete((K)i));
        return true;
    }

    @Override
    public boolean delete(K id) {
        String hql = "delete " + this.voClass.getCanonicalName() + " where id = :id";
        Query q = this.query(hql).setParameter("id", id);
        q.executeUpdate();
        return true;
    }

    @Override
    public E get(K id) {
        if (id == null) {
            return null;
        }
        return (E)this.getSession().get(this.getVOClass(), id);
    }

    @Override
    public List<E> getAll() {
        return this.getSession().createCriteria(this.getVOClass()).list();
    }

    @Override
    public Long countOf() {
        return (Long)this.criteria().setProjection(Projections.rowCount()).uniqueResult();
    }

    @Override
    public Class<?> getVOClass() {
        return this.voClass;
    }

    @Override
    public E getFirst() {
        Criteria crit = this.criteria();
        crit.setMaxResults(1);
        ClassMetadata meta = this.getSessionFactory().getClassMetadata(this.getVOClass());
        crit.addOrder(Order.asc((String)meta.getIdentifierPropertyName()));
        return (E)crit.uniqueResult();
    }

    @Override
    public E getLast() {
        Criteria crit = this.criteria();
        crit.setMaxResults(1);
        ClassMetadata meta = this.getSessionFactory().getClassMetadata(this.getVOClass());
        crit.addOrder(Order.desc((String)meta.getIdentifierPropertyName()));
        return (E)crit.uniqueResult();
    }

    public List<E> toList(Criteria crit) {
        return crit.list();
    }

    @Override
    public E refresh(E entity) {
        this.getSession().refresh(entity);
        return entity;
    }

    @Override
    public Criteria criteria() {
        return super.criteria(this.getVOClass());
    }

    @Override
    public E toUnique(Criteria crit) {
        return (E)super.toUnique(crit);
    }

    public E toUnique(Query crit) {
        return (E)super.toUnique(crit);
    }
}

