/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorversao.dao.impl;

import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistemasTouch;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementorversao.dao.DaoVersaoGenericEntityImpl;
import com.touchcomp.basementorversao.model.Versoes;
import com.touchcomp.basementorversao.model.temp.DTOInfoVersao;
import com.touchcomp.basementorversao.model.temp.DTOInfoVersoesRes;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.springframework.stereotype.Repository;

@Repository
public class DaoVersaoVersoesImpl
extends DaoVersaoGenericEntityImpl<Versoes, Long> {
    public boolean existeNovasVersoes(Long codigo, EnumConstTipoSistemasTouch sistema) {
        return this.getCountNovasVersoes(codigo, sistema) > 0L;
    }

    public long getCountNovasVersoes(Long codigo, EnumConstTipoSistemasTouch sistema) {
        Criteria c = this.restrictions(this.criteria(), this.greather("codigo", codigo), this.eq("codigoSistema", sistema.getValue()));
        Long l = this.countOf(c);
        return l;
    }

    public List<Versoes> getNovasVersoes(Long codigo, EnumConstTipoSistemasTouch sistema) {
        Criteria c = this.restrictions(this.criteria(), this.eq("codigo", codigo), this.eq("codigoSistema", sistema.getValue()));
        this.order(c, "codigo");
        return this.toList(c);
    }

    public List<DTOInfoVersoesRes> getListResNovasVersoes(Long codigoVersaoAtual, EnumConstTipoSistemasTouch codigoSistema) {
        ProjectionList proj = Projections.projectionList();
        proj.add((Projection)Projections.property((String)"codigo"));
        proj.add((Projection)Projections.property((String)"descricao"));
        proj.add((Projection)Projections.property((String)"fileSize"));
        proj.add((Projection)Projections.property((String)"urlArquivoVersao"));
        proj.add((Projection)Projections.property((String)"codigoSistema"));
        proj.add((Projection)Projections.property((String)"tipo"));
        proj.add((Projection)Projections.property((String)"beta"));
        Criteria c = this.criteria();
        c.setProjection((Projection)proj);
        this.restrictions(c, this.greather("codigo", codigoVersaoAtual), this.eq("codigoSistema", codigoSistema.getValue()));
        this.order(c, "codigo");
        List versoes = c.list();
        LinkedList<DTOInfoVersoesRes> res = new LinkedList<DTOInfoVersoesRes>();
        for (Object[] ver : versoes) {
            DTOInfoVersoesRes r = new DTOInfoVersoesRes();
            r.setCodigo((Long)ver[0]);
            r.setDescricao((String)ver[1]);
            r.setFileSize((Long)ver[2]);
            r.setUrlArquivoVersao((String)ver[3]);
            r.setUrlFile((String)ver[3]);
            r.setCodigoSistema((Integer)ver[4]);
            r.setTipo((Short)ver[5]);
            r.setBeta((Short)ver[6]);
            res.add(r);
        }
        return res;
    }

    public DTOInfoVersao getNewVersionApp(Long codigoVersaoAtual, EnumConstTipoSistemasTouch codigoSistema) {
        Criteria c = this.criteria();
        this.restrictions(c, this.eq("codigo", codigoVersaoAtual), this.eq("codigoSistema", codigoSistema.getValue()));
        Versoes v = (Versoes)this.toUnique(c);
        if (v == null) {
            return null;
        }
        DTOInfoVersao r = new DTOInfoVersao();
        r.setCodigo(v.getCodigo());
        r.setDescricao(v.getDescricao());
        r.setFileSize(v.getFileSize());
        r.setUrlArquivoVersao(v.getUrlArquivoVersao());
        r.setCodigoSistema(v.getCodigoSistema());
        r.setTipo(v.getTipo());
        r.setBeta(v.getBeta());
        r.setFlagUpdate(v.getFlagUpdate());
        if (v.getArquivoCliente() != null) {
            r.setArquivoCliente(ToolHexString.encodeToHex((byte[])v.getArquivoCliente()));
        }
        return r;
    }

    public Versoes getUltimaVersao(Long codigoVersaoAtual, EnumConstTipoSistemasTouch codigoSistema) {
        Criteria c = this.restrictions(this.criteria(), this.greather("codigo", codigoVersaoAtual), this.eq("codigoSistema", codigoSistema.getValue()));
        c.setMaxResults(1);
        c.addOrder(Order.desc((String)"codigo"));
        return (Versoes)this.toUnique(c);
    }

    public DTOInfoVersao getVersaoSistema(EnumConstTipoSistemasTouch codigoSistema) {
        Criteria c = this.restrictions(this.criteria(), this.eq("codigoSistema", codigoSistema.getValue()));
        c.setMaxResults(1);
        c.addOrder(Order.desc((String)"codigo"));
        Versoes v = (Versoes)this.toUnique(c);
        DTOInfoVersao r = new DTOInfoVersao();
        if (v != null) {
            r.setCodigo(v.getCodigo());
            r.setDescricao(v.getDescricao());
            r.setFileSize(v.getFileSize());
            r.setUrlArquivoVersao(v.getUrlArquivoVersao());
            r.setCodigoSistema(v.getCodigoSistema());
            r.setTipo(v.getTipo());
            r.setBeta(v.getBeta());
            r.setFlagUpdate(v.getFlagUpdate());
            if (v.getArquivoCliente() != null) {
                r.setArquivoCliente(ToolHexString.encodeToHex((byte[])v.getArquivoCliente()));
            }
        }
        return r;
    }

    public List<DTOInfoVersao> getVersaoSistema() {
        String query = "select v.codigoSistema,v.tipo,max(v.codigo) from Versoes v group by v.codigoSistema,v.tipo";
        String query2 = "select v.descricao,v.dataAtualizacao from Versoes v where v.codigoSistema=:codigoSistema and v.codigo=:codigo";
        Query q = this.query(query);
        List data = q.getResultList();
        LinkedList<DTOInfoVersao> ret = new LinkedList<DTOInfoVersao>();
        for (Object[] obj : data) {
            Integer codigoSistema = (Integer)obj[0];
            Short tipo = (Short)obj[1];
            Long codigo = (Long)obj[2];
            DTOInfoVersao dto = new DTOInfoVersao();
            dto.setCodigoSistema(codigoSistema);
            dto.setTipo(tipo);
            dto.setCodigo(codigo);
            Query q2 = this.query(query2);
            q2.setParameter("codigoSistema", (Object)codigoSistema);
            q2.setParameter("codigo", (Object)codigo);
            q2.setMaxResults(1);
            Object[] ob = (Object[])q2.getSingleResult();
            if (ob != null) {
                dto.setDescricao((String)ob[0]);
                dto.setDataAtualizacao((Date)ob[1]);
            }
            ret.add(dto);
        }
        return ret;
    }
}

