/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.EventoCancelamentoManifestoCte;
import com.touchcomp.basementor.model.vo.EvtCTeCancelamento;
import com.touchcomp.basementor.model.vo.EvtNFeCancelamento;
import com.touchcomp.basementor.model.vo.ManifestoCteEletronico;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementorservice.dao.DaoGenericImpl;
import com.touchcomp.basementorwebtasks.dao.interfaces.DaoTaskAverbaCteMdfeNfe;
import java.util.List;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoTASKAverbaCteMdfeNfeImpl
extends DaoGenericImpl
implements DaoTaskAverbaCteMdfeNfe {
    @Override
    public List<Cte> getCteAprovadosParaAverbar(Long idInicial, int maxResults, String serie) {
        Query q = this.query("select distinct c FROM Cte c left join c.erroAverbacaoCte er left JOIN c.averbacaoCte a WHERE c.identificador >= :idInicial AND (c.cteInfo.status = :aprovado) AND a.identificador is null AND c.gerarAverbacao = :gerarAverbacao and er is null and c.serie=:serie order by c.identificador");
        q.setLong("idInicial", idInicial.longValue());
        q.setShort("aprovado", (short)100);
        q.setShort("gerarAverbacao", (short)1);
        q.setString("serie", serie);
        q.setMaxResults(maxResults);
        return q.list();
    }

    @Override
    public List<Cte> getCteAprovadosParaAverbar(Long idInicial, int maxResults) {
        Query q = this.query("select distinct c FROM Cte c left join c.erroAverbacaoCte er left JOIN c.averbacaoCte a WHERE c.identificador >= :idInicial AND (c.cteInfo.status = :aprovado) AND a.identificador is null AND c.gerarAverbacao = :gerarAverbacao and er is null order by c.identificador");
        q.setLong("idInicial", idInicial.longValue());
        q.setShort("aprovado", (short)100);
        q.setShort("gerarAverbacao", (short)1);
        q.setMaxResults(maxResults);
        return q.list();
    }

    @Override
    public List<EvtCTeCancelamento> getCteCanceladosParaAverbar(Long idInicial, int maxResults, String serie) {
        Query q = this.query("SELECT DISTINCT e FROM EvtCTeCancelamento e inner join e.cte c left JOIN c.averbacaoCte a left join c.erroAverbacaoCte er WHERE c.identificador >= :idInicial AND c.cteInfo.status = :cancelado and a.tipoAverbacao <> :averbacao_cancelada AND c.gerarAverbacao = :gerarAverbacao and er is null and c.serie=:serie order by e.identificador");
        q.setLong("idInicial", idInicial.longValue());
        q.setShort("averbacao_cancelada", (short)1);
        q.setShort("cancelado", (short)101);
        q.setShort("gerarAverbacao", (short)1);
        q.setString("serie", serie);
        q.setMaxResults(maxResults);
        return q.list();
    }

    @Override
    public List<EvtCTeCancelamento> getCteCanceladosParaAverbar(Long idInicial, int maxResults) {
        Query q = this.query("SELECT DISTINCT e FROM EvtCTeCancelamento e inner join e.cte c left JOIN c.averbacaoCte a left join c.erroAverbacaoCte er WHERE c.identificador >= :idInicial AND c.cteInfo.status = :cancelado and a.tipoAverbacao <> :averbacao_cancelada AND c.gerarAverbacao = :gerarAverbacao and er is null order by e.identificador");
        q.setLong("idInicial", idInicial.longValue());
        q.setShort("averbacao_cancelada", (short)1);
        q.setShort("cancelado", (short)101);
        q.setShort("gerarAverbacao", (short)1);
        q.setMaxResults(maxResults);
        return q.list();
    }

    @Override
    public List<ManifestoCteEletronico> getMdfeAprovadosParaAverbar(Long idInicial, int maxResults) {
        Query q = this.query("SELECT DISTINCT m FROM ManifestoCteEletronico  m LEFT JOIN m.erroAverbacaoCte e LEFT JOIN m.averbacaoCte     a WHERE m.identificador       >= :idInicial AND   m.status               = :aprovado AND   a.identificador  IS NULL AND   m.gerarAverbacao       = :gerarAverbacao AND   e                IS NULL ORDER BY m.identificador");
        q.setLong("idInicial", idInicial.longValue());
        q.setShort("aprovado", (short)100);
        q.setShort("gerarAverbacao", EnumConstantsMentorSimNao.SIM.value);
        q.setMaxResults(maxResults);
        return q.list();
    }

    @Override
    public List<ManifestoCteEletronico> getMdfeAprovadosParaAverbar(Long idInicial, int maxResults, String serie) {
        Query q = this.query("SELECT DISTINCT m FROM ManifestoCteEletronico  m LEFT JOIN m.erroAverbacaoCte e LEFT JOIN m.averbacaoCte     a WHERE m.identificador       >= :idInicial AND   m.serie                = :serie AND   m.status               = :aprovado AND   a.identificador  IS NULL AND   m.gerarAverbacao       = :gerarAverbacao AND   e                IS NULL ORDER BY m.identificador");
        q.setLong("idInicial", idInicial.longValue());
        q.setString("serie", serie);
        q.setShort("aprovado", (short)100);
        q.setShort("gerarAverbacao", EnumConstantsMentorSimNao.SIM.value);
        q.setMaxResults(maxResults);
        return q.list();
    }

    @Override
    public List<EventoCancelamentoManifestoCte> getMdfeCanceladosParaAverbar(Long idInicial, int maxResults) {
        Query q = this.query("SELECT DISTINCT e FROM EventoCancelamentoManifestoCte e INNER JOIN e.manifestoCteEletronico m LEFT JOIN m.erroAverbacaoCte        r LEFT JOIN m.averbacaoCte            a WHERE m.identificador       >= :idInicial AND   m.status               = :cancelado AND   a.tipoAverbacao       <> :averbacao_cancelada AND   m.gerarAverbacao       = :gerarAverbacao AND   r                IS NULL ORDER BY e.identificador");
        q.setLong("idInicial", idInicial.longValue());
        q.setShort("averbacao_cancelada", (short)1);
        q.setShort("cancelado", (short)101);
        q.setShort("gerarAverbacao", EnumConstantsMentorSimNao.SIM.value);
        q.setMaxResults(maxResults);
        return q.list();
    }

    @Override
    public List<EventoCancelamentoManifestoCte> getMdfeCanceladosParaAverbar(Long idInicial, int maxResults, String serie) {
        Query q = this.query("SELECT DISTINCT e FROM EventoCancelamentoManifestoCte e INNER JOIN e.manifestoCteEletronico m LEFT JOIN m.erroAverbacaoCte        r LEFT JOIN m.averbacaoCte            a WHERE m.identificador       >= :idInicial AND   m.serie                = :serie AND   m.status               = :cancelado AND   a.tipoAverbacao       <> :averbacao_cancelada AND   m.gerarAverbacao       = :gerarAverbacao AND   r                IS NULL ORDER BY e.identificador");
        q.setLong("idInicial", idInicial.longValue());
        q.setString("serie", serie);
        q.setShort("averbacao_cancelada", (short)1);
        q.setShort("cancelado", (short)101);
        q.setShort("gerarAverbacao", EnumConstantsMentorSimNao.SIM.value);
        q.setMaxResults(maxResults);
        return q.list();
    }

    @Override
    public List<NotaFiscalPropria> getNfeAprovadosParaAverbar(Long idInicial, int maxResults) {
        Query q = this.query("SELECT DISTINCT n FROM NotaFiscalPropria n LEFT JOIN n.erroAverbacaoCte e LEFT JOIN n.averbacaoCte     a WHERE n.identificador >= :idInicial AND n.status           IN(:aprovado) AND a.identificador    IS NULL AND n.gerarAverbacao   = :gerarAverbacao AND e                  IS NULL ORDER BY n.identificador");
        q.setLong("idInicial", idInicial.longValue());
        q.setParameter("aprovado", (Object)EnumConstNFeStatus.getStatusAutorizadaShort());
        q.setShort("gerarAverbacao", EnumConstantsMentorSimNao.SIM.value);
        q.setMaxResults(maxResults);
        return q.list();
    }

    @Override
    public List<NotaFiscalPropria> getNfeAprovadosParaAverbar(Long idInicial, int maxResults, String serie) {
        Query q = this.query("SELECT DISTINCT n FROM NotaFiscalPropria n LEFT JOIN n.erroAverbacaoCte e LEFT JOIN n.averbacaoCte     a WHERE n.identificador   >= :idInicial AND   n.serie            = :serie AND   n.status           IN(:aprovado) AND   a.identificador    IS NULL AND   n.gerarAverbacao   = :gerarAverbacao AND   e                  IS NULL ORDER BY n.identificador");
        q.setLong("idInicial", idInicial.longValue());
        q.setString("serie", serie);
        q.setParameter("aprovado", (Object)EnumConstNFeStatus.getStatusAutorizadaShort());
        q.setShort("gerarAverbacao", EnumConstantsMentorSimNao.SIM.value);
        q.setMaxResults(maxResults);
        return q.list();
    }

    @Override
    public List<EvtNFeCancelamento> getNfeCanceladosParaAverbar(Long idInicial, int maxResults) {
        Query q = this.query("SELECT DISTINCT e FROM EvtNFeCancelamento        e INNER JOIN e.notaFiscalPropria n LEFT  JOIN n.erroAverbacaoCte  r LEFT  JOIN n.averbacaoCte      a WHERE n.identificador  >= :idInicial AND   n.status          IN(:cancelado) AND   a.tipoAverbacao  <> :averbacao_cancelada AND   n.gerarAverbacao  = :gerarAverbacao AND   r                 IS NULL ORDER BY e.identificador");
        q.setLong("idInicial", idInicial.longValue());
        q.setShort("averbacao_cancelada", (short)1);
        q.setParameter("cancelado", (Object)EnumConstNFeStatus.getStatusCanceladaShort());
        q.setShort("gerarAverbacao", EnumConstantsMentorSimNao.SIM.value);
        q.setMaxResults(maxResults);
        return q.list();
    }

    @Override
    public List<EvtNFeCancelamento> getNfeCanceladosParaAverbar(Long idInicial, int maxResults, String serie) {
        Query q = this.query("SELECT DISTINCT e FROM EvtNFeCancelamento        e INNER JOIN e.notaFiscalPropria n LEFT  JOIN n.erroAverbacaoCte  r LEFT  JOIN n.averbacaoCte      a WHERE n.identificador  >= :idInicial AND   n.serie           = :serie AND   n.status          IN(:cancelado) AND   a.tipoAverbacao  <> :averbacao_cancelada AND   n.gerarAverbacao  = :gerarAverbacao AND   r                 IS NULL ORDER BY e.identificador");
        q.setLong("idInicial", idInicial.longValue());
        q.setString("serie", serie);
        q.setShort("averbacao_cancelada", (short)1);
        q.setParameter("cancelado", (Object)EnumConstNFeStatus.getStatusCanceladaShort());
        q.setShort("gerarAverbacao", EnumConstantsMentorSimNao.SIM.value);
        q.setMaxResults(maxResults);
        return q.list();
    }
}

