/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.service.impl.averbaCteMdfeNfe;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AverbacaoCte;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.ErroAverbacaoCte;
import com.touchcomp.basementor.model.vo.ErroDetalheAverbacao;
import com.touchcomp.basementor.model.vo.EventoCancelamentoManifestoCte;
import com.touchcomp.basementor.model.vo.EvtCTeCancelamento;
import com.touchcomp.basementor.model.vo.EvtNFeCancelamento;
import com.touchcomp.basementor.model.vo.ManifestoCteEletronico;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ProtocoloAverbacao;
import com.touchcomp.basementorclientwebservices.averbacaocte.model.ErroProcesso;
import com.touchcomp.basementorclientwebservices.averbacaocte.model.Retorno;
import com.touchcomp.basementorclientwebservices.averbacaocte.model.RetornoMDFe;
import com.touchcomp.basementorclientwebservices.averbacaocte.model.SuccessProcesso;
import com.touchcomp.basementorclientwebservices.averbacaocte.model.SuccessProcessoMDFe;
import com.touchcomp.basementorclientwebservices.components.DocAverbaCteMdfeNfe;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionJDom;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.impl.averbacaocte.ServiceAverbacaoCteImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceErroAverbacaoCte;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.jdom.ToolJdom;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorwebtasks.dao.interfaces.DaoTaskAverbaCteMdfeNfe;
import com.touchcomp.basementorxml.model.XMLCTe;
import com.touchcomp.basementorxml.model.XMLEventoCTe;
import com.touchcomp.basementorxml.model.XMLManifestoCte;
import com.touchcomp.basementorxml.model.XMLNfePropria;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLCTe;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLEventoCTe;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLManifestoCTe;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLNFePropria;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.XMLOutputter;

public class UtilAverbaCteMdfeNfe {
    private static final TLogger logger = TLogger.get(UtilAverbaCteMdfeNfe.class);
    private final TaskProcessResult result;
    private final int MAX_REG_POR_VEZ = 50;
    private final DaoTaskAverbaCteMdfeNfe daoTaskAverbaCteMdfeNfe = (DaoTaskAverbaCteMdfeNfe)ConfApplicationContext.getBean(DaoTaskAverbaCteMdfeNfe.class);
    private final ServiceXMLCTe serviceXMLCTe = (ServiceXMLCTe)ConfApplicationContext.getBean(ServiceXMLCTe.class);
    private final ServiceXMLEventoCTe serviceXMLEventoCTe = (ServiceXMLEventoCTe)ConfApplicationContext.getBean(ServiceXMLEventoCTe.class);
    private final ServiceXMLManifestoCTe serviceXMLManifestoCTe = (ServiceXMLManifestoCTe)ConfApplicationContext.getBean(ServiceXMLManifestoCTe.class);
    private final ServiceXMLNFePropria serviceXMLNFePropria = (ServiceXMLNFePropria)ConfApplicationContext.getBean(ServiceXMLNFePropria.class);
    private final ServiceErroAverbacaoCte serviceErroAverbacaoCte = (ServiceErroAverbacaoCte)ConfApplicationContext.getBean(ServiceErroAverbacaoCte.class);
    private final DocAverbaCteMdfeNfe docAverbaCteMdfeNfe = (DocAverbaCteMdfeNfe)ConfApplicationContext.getBean(DocAverbaCteMdfeNfe.class);
    private final ServiceAverbacaoCteImpl serviceAverbacaoCte = (ServiceAverbacaoCteImpl)ConfApplicationContext.getBean(ServiceAverbacaoCteImpl.class);

    public UtilAverbaCteMdfeNfe(TaskProcessResult result) {
        this.result = result;
    }

    synchronized void averbaCteMdfeNfe(Short averbarCte, Short averbarMdfe, Short averbarNfe, String serieCte, Long idInicialCte, String serieMdfe, Long idInicialMdfe, String serieNfe, Long idInicialNfe, String usuario, String senha, String codAtm) {
        if (ToolMethods.isEquals((Object)averbarCte, (Object)EnumConstantsMentorSimNao.SIM.value)) {
            this.averbaCte(serieCte, idInicialCte, usuario, senha, codAtm);
        }
        if (ToolMethods.isEquals((Object)averbarMdfe, (Object)EnumConstantsMentorSimNao.SIM.value)) {
            this.averbaMdfe(serieMdfe, idInicialMdfe, usuario, senha, codAtm);
        }
        if (ToolMethods.isEquals((Object)averbarNfe, (Object)EnumConstantsMentorSimNao.SIM.value)) {
            this.averbaNfe(serieNfe, idInicialNfe, usuario, senha, codAtm);
        }
    }

    private void averbaCte(String serieCte, Long idInicialCte, String usuario, String senha, String codAtm) {
        if (ToolMethods.isStrWithData((String)serieCte)) {
            StringTokenizer sk = new StringTokenizer(serieCte, ";");
            while (sk.hasMoreTokens()) {
                String serie = sk.nextToken();
                this.averbaCteInternal(serie, idInicialCte, usuario, senha, codAtm);
            }
        } else {
            this.averbaCteInternal(null, idInicialCte, usuario, senha, codAtm);
        }
    }

    private void averbaCteInternal(String serieCte, Long idInicialCte, String usuario, String senha, String codAtm) {
        List<Cte> ctes = this.pesquisarCteAprovadosParaAverbar(idInicialCte, serieCte);
        List<EvtCTeCancelamento> ctesCancelados = this.pesquisarCteCanceladosParaAverbar(idInicialCte, serieCte);
        List<Map<String, Object>> xmlCtes = this.pesquisarXMLCtes(ctes);
        List<Map<String, Object>> xmlCtesCancelados = this.pesquisarXMLCtesCancelados(ctesCancelados);
        List<Map<String, Object>> averbacoes = this.enviarAverbacaoCte(xmlCtes, xmlCtesCancelados, usuario, senha, codAtm);
        this.salvarAverbacaoCte(averbacoes);
    }

    private List<Cte> pesquisarCteAprovadosParaAverbar(Long idInicial, String serie) {
        if (serie == null) {
            return this.daoTaskAverbaCteMdfeNfe.getCteAprovadosParaAverbar(idInicial, 50);
        }
        return this.daoTaskAverbaCteMdfeNfe.getCteAprovadosParaAverbar(idInicial, 50, serie);
    }

    private List<EvtCTeCancelamento> pesquisarCteCanceladosParaAverbar(Long idInicial, String serie) {
        if (serie == null) {
            return this.daoTaskAverbaCteMdfeNfe.getCteCanceladosParaAverbar(idInicial, 50);
        }
        return this.daoTaskAverbaCteMdfeNfe.getCteCanceladosParaAverbar(idInicial, 50, serie);
    }

    private List<Map<String, Object>> pesquisarXMLCtes(List<Cte> ctes) {
        ArrayList<Map<String, Object>> listCtes = new ArrayList<Map<String, Object>>();
        for (Cte c : ctes) {
            try {
                XMLCTe xmlCte = this.serviceXMLCTe.getXmlCTeIdCTe(c.getIdentificador());
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("xml", this.montarXMLAprovacaoCte(xmlCte, c));
                m.put("cte", (String)c);
                listCtes.add(m);
            }
            catch (Throwable ex) {
                logger.error(ex.getMessage(), ex);
                this.addAndSaveErroAverb(c, null, null, (short)0, null, ex.getMessage());
            }
        }
        return listCtes;
    }

    private String montarXMLAprovacaoCte(XMLCTe xmlCte, Cte c) throws ExceptionJDom {
        Document d = ToolJdom.getDocument((String)xmlCte.getConteudoXML());
        Element e = d.getRootElement();
        if (xmlCte.getConteudoAprovacao() != null) {
            Document a = ToolJdom.getDocument((String)xmlCte.getConteudoAprovacao());
            Element rootApprovado = a.detachRootElement();
            if (!rootApprovado.getName().equals("protCTe")) {
                e = new Element("protCTe");
                Attribute at = new Attribute("versao", "1.04");
                e.setAttribute(at);
                e.setNamespace(rootApprovado.getNamespace());
                e.addContent((Content)rootApprovado);
            } else {
                e = rootApprovado;
            }
        }
        Element nfeProc = new Element("cteProc");
        Attribute at = new Attribute("versao", c.getVersaoCte().getCodigo());
        nfeProc.setAttribute(at);
        Element root = d.detachRootElement();
        nfeProc.addContent((Content)root);
        if (e != null) {
            nfeProc.addContent((Content)e);
        }
        nfeProc.setNamespace(Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/cte"));
        return new XMLOutputter().outputString(nfeProc);
    }

    private List<Map<String, Object>> pesquisarXMLCtesCancelados(List<EvtCTeCancelamento> ctesCancelados) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (EvtCTeCancelamento e : ctesCancelados) {
            try {
                XMLEventoCTe xmlEventoCte = this.serviceXMLEventoCTe.getXMLEventoCTe(e.getIdentificador());
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("xml", this.montarXMLCancelamentoCte(xmlEventoCte, e.getCte()));
                m.put("cte", (String)e.getCte());
                result.add(m);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                this.addAndSaveErroAverb(e.getCte(), null, null, (short)1, null, ex.getMessage());
            }
        }
        return result;
    }

    private String montarXMLCancelamentoCte(XMLEventoCTe xmlEventoCte, Cte c) throws ExceptionJDom {
        Document d = new Document();
        if (xmlEventoCte.getConteudoEnviado() != null) {
            d = ToolJdom.getDocument((String)xmlEventoCte.getConteudoEnviado());
        }
        Element e = null;
        if (xmlEventoCte.getConteudoRecebido() != null) {
            Document a = ToolJdom.getDocument((String)xmlEventoCte.getConteudoRecebido());
            e = a.detachRootElement();
        }
        Element nfeProc = new Element("procCancCTe");
        Attribute at = new Attribute("versao", c.getVersaoCte().getCodigo());
        nfeProc.setAttribute(at);
        nfeProc.setNamespace(Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/cte"));
        Element root = d.detachRootElement();
        nfeProc.addContent((Content)root);
        if (e != null) {
            nfeProc.addContent((Content)e);
        }
        return new XMLOutputter().outputString(nfeProc);
    }

    private List<Map<String, Object>> enviarAverbacaoCte(List xmlCtes, List xmlCtesCancelados, String usuario, String senha, String codAtm) {
        HashMap<String, Object> m;
        Retorno a;
        String xml;
        ArrayList<Map<String, Object>> averbacaoCte = new ArrayList<Map<String, Object>>();
        for (Object o : xmlCtes) {
            xml = (String)((HashMap)o).get("xml");
            a = this.docAverbaCteMdfeNfe.sendMsgCte(xml, usuario, senha, codAtm);
            m = new HashMap<String, Object>();
            m.put("averbacao", a);
            m.put("cte", ((HashMap)o).get("cte"));
            m.put("xml", ((HashMap)o).get("xml"));
            m.put("tipoAverbacao", (short)0);
            averbacaoCte.add(m);
        }
        for (Object o2 : xmlCtesCancelados) {
            xml = (String)((HashMap)o2).get("xml");
            a = this.docAverbaCteMdfeNfe.sendMsgCte(xml, usuario, senha, codAtm);
            m = new HashMap();
            m.put("averbacao", a);
            m.put("cte", ((HashMap)o2).get("cte"));
            m.put("xml", ((HashMap)o2).get("xml"));
            m.put("tipoAverbacao", (short)1);
            averbacaoCte.add(m);
        }
        return averbacaoCte;
    }

    private void salvarAverbacaoCte(List averbacoes) {
        for (Object o : averbacoes) {
            Retorno resp = (Retorno)((HashMap)o).get("averbacao");
            if (resp == null) continue;
            this.salvarObjetoCte(resp, o);
        }
    }

    private void salvarObjetoCte(Retorno msg, Object o) {
        Cte cte = (Cte)((HashMap)o).get("cte");
        Short tipoAverbacao = (Short)((HashMap)o).get("tipoAverbacao");
        if (msg.getAverbado() != null) {
            AverbacaoCte a = new AverbacaoCte();
            a.setDataCadastro(new Date());
            a.setCte(cte);
            a.setTipoAverbacao(tipoAverbacao);
            a.setNumDoc(msg.getNumero());
            a.setSerieDoc(msg.getSerie());
            a.setFilialDoc(msg.getFilial());
            a.setLinhaArq((String)(msg.getInfAdic() != null ? msg.getInfAdic() + msg.getCNPJCli() : msg.getCNPJCli()));
            a.setProtocoloAverbacao(this.getProtocoloAverbacaoCte(msg.getAverbado()));
            this.serviceAverbacaoCte.saveOrUpdate((InterfaceVO)a);
            this.serviceErroAverbacaoCte.deleteErros(a.getCte());
            this.addSuccesToResult(a);
        } else if (msg.getErros() != null) {
            this.addAndSaveErroAverb(cte, null, null, tipoAverbacao, msg, "Erro ao averbar decorrente do site.");
        }
    }

    private ProtocoloAverbacao getProtocoloAverbacaoCte(SuccessProcesso protocoloAverbacao) {
        ProtocoloAverbacao p = new ProtocoloAverbacao();
        Date d = ToolDate.strToDate((String)(protocoloAverbacao.getDhAverbacao().toString().substring(0, 10) + " " + protocoloAverbacao.getDhAverbacao().toString().substring(11, 19)), (String)"yyyy-MM-dd HH:mm:ss");
        p.setData(d);
        p.setHora(d);
        p.setNumeroProtocolo(protocoloAverbacao.getProtocolo());
        return p;
    }

    private void averbaMdfe(String serieMdfe, Long idInicialMdfe, String usuario, String senha, String codAtm) {
        if (ToolMethods.isStrWithData((String)serieMdfe)) {
            StringTokenizer sk = new StringTokenizer(serieMdfe, ";");
            while (sk.hasMoreTokens()) {
                String serie = sk.nextToken();
                this.averbaMdfeInternal(serie, idInicialMdfe, usuario, senha, codAtm);
            }
        } else {
            this.averbaMdfeInternal(null, idInicialMdfe, usuario, senha, codAtm);
        }
    }

    private void averbaMdfeInternal(String serieMdfe, Long idInicialMdfe, String usuario, String senha, String codAtm) {
        List<ManifestoCteEletronico> mdfes = this.pesquisarMdfeAprovadosParaAverbar(idInicialMdfe, serieMdfe);
        List<EventoCancelamentoManifestoCte> mdfesCancelados = this.pesquisarMdfeCanceladosParaAverbar(idInicialMdfe, serieMdfe);
        List<Map<String, Object>> xmlMdfes = this.pesquisarXMLMdfe(mdfes);
        List<Map<String, Object>> xmlMdfesCancelados = this.pesquisarXMLMdfeCancelados(mdfesCancelados);
        List<Map<String, Object>> averbacoes = this.enviarAverbacaoMdfe(xmlMdfes, xmlMdfesCancelados, usuario, senha, codAtm);
        this.salvarAverbacaoMdfe(averbacoes);
    }

    private List<ManifestoCteEletronico> pesquisarMdfeAprovadosParaAverbar(Long idInicialMdfe, String serieMdfe) {
        if (serieMdfe == null) {
            return this.daoTaskAverbaCteMdfeNfe.getMdfeAprovadosParaAverbar(idInicialMdfe, 50);
        }
        return this.daoTaskAverbaCteMdfeNfe.getMdfeAprovadosParaAverbar(idInicialMdfe, 50, serieMdfe);
    }

    private List<EventoCancelamentoManifestoCte> pesquisarMdfeCanceladosParaAverbar(Long idInicialMdfe, String serieMdfe) {
        if (serieMdfe == null) {
            return this.daoTaskAverbaCteMdfeNfe.getMdfeCanceladosParaAverbar(idInicialMdfe, 50);
        }
        return this.daoTaskAverbaCteMdfeNfe.getMdfeCanceladosParaAverbar(idInicialMdfe, 50, serieMdfe);
    }

    private List<Map<String, Object>> pesquisarXMLMdfe(List<ManifestoCteEletronico> mdfes) {
        ArrayList<Map<String, Object>> listMdfes = new ArrayList<Map<String, Object>>();
        for (ManifestoCteEletronico m : mdfes) {
            try {
                XMLManifestoCte xmlMdfe = this.serviceXMLManifestoCTe.getXMLManifestoCte(m.getIdentificador());
                HashMap<String, String> h = new HashMap<String, String>();
                h.put("xml", this.montarXMLAprovacaoMdfe(xmlMdfe, m));
                h.put("mdfe", (String)m);
                listMdfes.add(h);
            }
            catch (Throwable ex) {
                logger.error(ex.getMessage(), ex);
                this.addAndSaveErroAverb(null, m, null, (short)0, null, ex.getMessage());
            }
        }
        return listMdfes;
    }

    private String montarXMLAprovacaoMdfe(XMLManifestoCte xmlMdfe, ManifestoCteEletronico m) throws ExceptionJDom {
        Document d = ToolJdom.getDocument((String)xmlMdfe.getConteudoXML());
        Element e = null;
        if (xmlMdfe.getConteudoAprovacao() != null) {
            Document a = ToolJdom.getDocument((String)xmlMdfe.getConteudoAprovacao());
            e = a.detachRootElement();
        }
        Element mdfeProc = new Element("mdfeProc");
        Attribute at = new Attribute("versao", m.getVersaoManifestoCte().getCodigo());
        mdfeProc.setAttribute(at);
        mdfeProc.setNamespace(Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/mdfe"));
        Element root = d.detachRootElement();
        mdfeProc.addContent((Content)root);
        if (e != null) {
            mdfeProc.addContent((Content)e);
        }
        return new XMLOutputter().outputString(mdfeProc);
    }

    private List<Map<String, Object>> pesquisarXMLMdfeCancelados(List<EventoCancelamentoManifestoCte> mdfesCancelados) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (EventoCancelamentoManifestoCte e : mdfesCancelados) {
            try {
                XMLManifestoCte xmlMdfe = this.serviceXMLManifestoCTe.getXMLManifestoCte(e.getManifestoCteEletronico().getIdentificador());
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("xml", this.montarXMLCancelamentoMdfe(xmlMdfe, e.getManifestoCteEletronico()));
                m.put("mdfe", (String)e.getManifestoCteEletronico());
                result.add(m);
            }
            catch (Throwable ex) {
                logger.error(ex.getMessage(), ex);
                this.addAndSaveErroAverb(null, e.getManifestoCteEletronico(), null, (short)1, null, ex.getMessage());
            }
        }
        return result;
    }

    private String montarXMLCancelamentoMdfe(XMLManifestoCte xmlMdfe, ManifestoCteEletronico m) throws ExceptionJDom {
        Document a;
        Document d;
        if (xmlMdfe.getConteudoCancelamento() != null) {
            d = ToolJdom.getDocument((String)xmlMdfe.getConteudoPedCancelamento());
            a = ToolJdom.getDocument((String)xmlMdfe.getConteudoCancelamento());
        } else {
            d = ToolJdom.getDocument((String)xmlMdfe.getConteudoPedEncerramento());
            a = ToolJdom.getDocument((String)xmlMdfe.getConteudoEncerramento());
        }
        Element e = d.detachRootElement();
        Element e2 = a.detachRootElement();
        Element mdfeProc = new Element("procEventoMDFe");
        Attribute at = new Attribute("versao", m.getVersaoManifestoCte().getCodigo());
        mdfeProc.setAttribute(at);
        mdfeProc.setNamespace(Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/mdfe"));
        mdfeProc.addContent((Content)e);
        mdfeProc.addContent((Content)e2);
        return new XMLOutputter().outputString(mdfeProc);
    }

    private List<Map<String, Object>> enviarAverbacaoMdfe(List<Map<String, Object>> xmlMdfes, List<Map<String, Object>> xmlMdfesCancelados, String usuario, String senha, String codAtm) {
        HashMap<String, Object> m;
        RetornoMDFe a;
        String xml;
        ArrayList<Map<String, Object>> averbacaoMdfe = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> o : xmlMdfes) {
            xml = (String)((HashMap)o).get("xml");
            a = this.docAverbaCteMdfeNfe.sendMsgMdfe(xml, usuario, senha, codAtm);
            m = new HashMap<String, Object>();
            m.put("averbacao", a);
            m.put("mdfe", ((HashMap)o).get("mdfe"));
            m.put("xml", ((HashMap)o).get("xml"));
            m.put("tipoAverbacao", (short)0);
            averbacaoMdfe.add(m);
        }
        for (Map<String, Object> o2 : xmlMdfesCancelados) {
            xml = (String)((HashMap)o2).get("xml");
            a = this.docAverbaCteMdfeNfe.sendMsgMdfe(xml, usuario, senha, codAtm);
            m = new HashMap();
            m.put("averbacao", a);
            m.put("mdfe", ((HashMap)o2).get("mdfe"));
            m.put("xml", ((HashMap)o2).get("xml"));
            m.put("tipoAverbacao", (short)1);
            averbacaoMdfe.add(m);
        }
        return averbacaoMdfe;
    }

    private void salvarAverbacaoMdfe(List<Map<String, Object>> averbacoes) {
        for (Map<String, Object> o : averbacoes) {
            RetornoMDFe resp = (RetornoMDFe)((HashMap)o).get("averbacao");
            if (resp == null) continue;
            this.salvarObjetoMdfe(resp, o);
        }
    }

    private void salvarObjetoMdfe(RetornoMDFe msg, Object o) {
        ManifestoCteEletronico mdfe = (ManifestoCteEletronico)((HashMap)o).get("mdfe");
        Short tipoAverbacao = (Short)((HashMap)o).get("tipoAverbacao");
        if (msg.getDeclarado() != null) {
            AverbacaoCte a = new AverbacaoCte();
            a.setDataCadastro(new Date());
            a.setManifestoCteEletronico(mdfe);
            a.setTipoAverbacao(tipoAverbacao);
            a.setNumDoc(msg.getNumero());
            a.setSerieDoc(msg.getSerie());
            a.setFilialDoc(msg.getFilial());
            a.setLinhaArq("MDFE");
            a.setProtocoloAverbacao(this.getProtocoloAverbacaoMdfe(msg.getDeclarado()));
            this.serviceAverbacaoCte.saveOrUpdate((InterfaceVO)a);
            this.serviceErroAverbacaoCte.deleteErros(a.getManifestoCteEletronico());
            this.addSuccesToResult(a);
        } else if (msg.getErros() != null) {
            this.addAndSaveErroAverb(null, mdfe, null, tipoAverbacao, msg, "Erro ao averbar decorrente do site.");
        }
    }

    private ProtocoloAverbacao getProtocoloAverbacaoMdfe(SuccessProcessoMDFe protocoloAverbacao) {
        ProtocoloAverbacao p = new ProtocoloAverbacao();
        Date d = ToolDate.strToDate((String)(protocoloAverbacao.getDhChancela().toString().substring(0, 10) + " " + protocoloAverbacao.getDhChancela().toString().substring(11, 19)), (String)"yyyy-MM-dd HH:mm:ss");
        p.setData(d);
        p.setHora(d);
        p.setNumeroProtocolo(protocoloAverbacao.getProtocolo());
        return p;
    }

    private void averbaNfe(String serieNfe, Long idInicialNfe, String usuario, String senha, String codAtm) {
        if (ToolMethods.isStrWithData((String)serieNfe)) {
            StringTokenizer sk = new StringTokenizer(serieNfe, ";");
            while (sk.hasMoreTokens()) {
                String serie = sk.nextToken();
                this.averbaNfeInternal(serie, idInicialNfe, usuario, senha, codAtm);
            }
        } else {
            this.averbaNfeInternal(null, idInicialNfe, usuario, senha, codAtm);
        }
    }

    private void averbaNfeInternal(String serieNfe, Long idInicialNfe, String usuario, String senha, String codAtm) {
        List<NotaFiscalPropria> nfes = this.pesquisarNfeAprovadosParaAverbar(idInicialNfe, serieNfe);
        List<EvtNFeCancelamento> nfesCancelados = this.pesquisarNfeCanceladosParaAverbar(idInicialNfe, serieNfe);
        List<Map<String, Object>> xmlNfes = this.pesquisarXMLNfe(nfes);
        List<Map<String, Object>> xmlNfesCancelados = this.pesquisarXMLNfeCancelados(nfesCancelados);
        List<Map<String, Object>> averbacoes = this.enviarAverbacaoNfe(xmlNfes, xmlNfesCancelados, usuario, senha, codAtm);
        this.salvarAverbacaoNfe(averbacoes);
    }

    private List<NotaFiscalPropria> pesquisarNfeAprovadosParaAverbar(Long idInicialNfe, String serieNfe) {
        if (serieNfe == null) {
            return this.daoTaskAverbaCteMdfeNfe.getNfeAprovadosParaAverbar(idInicialNfe, 50);
        }
        return this.daoTaskAverbaCteMdfeNfe.getNfeAprovadosParaAverbar(idInicialNfe, 50, serieNfe);
    }

    private List<EvtNFeCancelamento> pesquisarNfeCanceladosParaAverbar(Long idInicialNfe, String serieNfe) {
        if (serieNfe == null) {
            return this.daoTaskAverbaCteMdfeNfe.getNfeCanceladosParaAverbar(idInicialNfe, 50);
        }
        return this.daoTaskAverbaCteMdfeNfe.getNfeCanceladosParaAverbar(idInicialNfe, 50, serieNfe);
    }

    private List<Map<String, Object>> pesquisarXMLNfe(List<NotaFiscalPropria> nfes) {
        ArrayList<Map<String, Object>> listNfes = new ArrayList<Map<String, Object>>();
        for (NotaFiscalPropria n : nfes) {
            try {
                XMLNfePropria xmlNfe = this.serviceXMLNFePropria.getXMlNfePropria(n.getIdentificador());
                HashMap<String, String> h = new HashMap<String, String>();
                h.put("xml", this.montarXMLAprovacaoNfe(xmlNfe, n));
                h.put("nfe", (String)n);
                listNfes.add(h);
            }
            catch (Throwable ex) {
                logger.error(ex.getMessage(), ex);
                this.addAndSaveErroAverb(null, null, n, (short)0, null, ex.getMessage());
            }
        }
        return listNfes;
    }

    private String montarXMLAprovacaoNfe(XMLNfePropria xmlNfe, NotaFiscalPropria n) throws ExceptionJDom {
        Document d = ToolJdom.getDocument((String)xmlNfe.getConteudoXML());
        Element e = null;
        if (xmlNfe.getConteudoAprovacao() != null) {
            Document a = ToolJdom.getDocument((String)xmlNfe.getConteudoAprovacao());
            e = a.detachRootElement();
        }
        Element nfeProc = new Element("nfeProc");
        Attribute at = new Attribute("versao", n.getVersaoNfe().getCodigo());
        nfeProc.setAttribute(at);
        nfeProc.setNamespace(Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe"));
        Element root = d.detachRootElement();
        nfeProc.addContent((Content)root);
        if (e != null) {
            nfeProc.addContent((Content)e);
        }
        return new XMLOutputter().outputString(nfeProc);
    }

    private List<Map<String, Object>> pesquisarXMLNfeCancelados(List<EvtNFeCancelamento> nfesCancelados) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (EvtNFeCancelamento e : nfesCancelados) {
            try {
                XMLNfePropria xmlNfe = this.serviceXMLNFePropria.getXMlNfePropria(e.getNotaFiscalPropria().getIdentificador());
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("xml", this.montarXMLCancelamentoNfe(xmlNfe, e.getNotaFiscalPropria()));
                m.put("nfe", (String)e.getNotaFiscalPropria());
                result.add(m);
            }
            catch (Throwable ex) {
                logger.error(ex.getMessage(), ex);
                this.addAndSaveErroAverb(null, null, e.getNotaFiscalPropria(), (short)1, null, ex.getMessage());
            }
        }
        return result;
    }

    private String montarXMLCancelamentoNfe(XMLNfePropria xmlNfe, NotaFiscalPropria n) throws ExceptionJDom {
        Document d = ToolJdom.getDocument((String)xmlNfe.getConteudoPedCancelamento());
        Document a = ToolJdom.getDocument((String)xmlNfe.getConteudoCancelamento());
        Element e = a.detachRootElement();
        Element nfeProc = new Element("procCancNFe");
        Attribute at = new Attribute("versao", n.getVersaoNfe().getCodigo());
        nfeProc.setAttribute(at);
        nfeProc.setNamespace(Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe"));
        Element root = d.detachRootElement();
        nfeProc.addContent((Content)root);
        nfeProc.addContent((Content)e);
        return new XMLOutputter().outputString(nfeProc);
    }

    private List<Map<String, Object>> enviarAverbacaoNfe(List<Map<String, Object>> xmlNfes, List<Map<String, Object>> xmlNfesCancelados, String usuario, String senha, String codAtm) {
        HashMap<String, Object> m;
        Retorno a;
        String xml;
        ArrayList<Map<String, Object>> averbacaoNfe = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> o : xmlNfes) {
            xml = (String)((HashMap)o).get("xml");
            a = this.docAverbaCteMdfeNfe.sendMsgNfe(xml, usuario, senha, codAtm);
            m = new HashMap<String, Object>();
            m.put("averbacao", a);
            m.put("nfe", ((HashMap)o).get("nfe"));
            m.put("xml", ((HashMap)o).get("xml"));
            m.put("tipoAverbacao", (short)0);
            averbacaoNfe.add(m);
        }
        for (Map<String, Object> o2 : xmlNfesCancelados) {
            xml = (String)((HashMap)o2).get("xml");
            a = this.docAverbaCteMdfeNfe.sendMsgNfe(xml, usuario, senha, codAtm);
            m = new HashMap();
            m.put("averbacao", a);
            m.put("nfe", ((HashMap)o2).get("nfe"));
            m.put("xml", ((HashMap)o2).get("xml"));
            m.put("tipoAverbacao", (short)1);
            averbacaoNfe.add(m);
        }
        return averbacaoNfe;
    }

    private void salvarAverbacaoNfe(List<Map<String, Object>> averbacoes) {
        for (Map<String, Object> o : averbacoes) {
            Retorno resp = (Retorno)((HashMap)o).get("averbacao");
            if (resp == null) continue;
            this.salvarObjetoNfe(resp, o);
        }
    }

    private void salvarObjetoNfe(Retorno msg, Object o) {
        NotaFiscalPropria nfe = (NotaFiscalPropria)((HashMap)o).get("nfe");
        Short tipoAverbacao = (Short)((HashMap)o).get("tipoAverbacao");
        if (msg.getAverbado() != null) {
            AverbacaoCte a = new AverbacaoCte();
            a.setDataCadastro(new Date());
            a.setNotaFiscalPropria(nfe);
            a.setTipoAverbacao(tipoAverbacao);
            a.setNumDoc(msg.getNumero());
            a.setSerieDoc(msg.getSerie());
            a.setFilialDoc(msg.getFilial());
            a.setLinhaArq((String)(msg.getInfAdic() != null ? msg.getInfAdic() + msg.getCNPJCli() : msg.getCNPJCli()));
            a.setProtocoloAverbacao(this.getProtocoloAverbacaoNfe(msg.getAverbado()));
            this.serviceAverbacaoCte.saveOrUpdate((InterfaceVO)a);
            this.serviceErroAverbacaoCte.deleteErros(a.getNotaFiscalPropria());
            this.addSuccesToResult(a);
        } else if (msg.getErros() != null) {
            this.addAndSaveErroAverb(null, null, nfe, tipoAverbacao, msg, "Erro ao averbar decorrente do site.");
        }
    }

    private ProtocoloAverbacao getProtocoloAverbacaoNfe(SuccessProcesso protocoloAverbacao) {
        ProtocoloAverbacao p = new ProtocoloAverbacao();
        Date d = ToolDate.strToDate((String)(protocoloAverbacao.getDhAverbacao().toString().substring(0, 10) + " " + protocoloAverbacao.getDhAverbacao().toString().substring(11, 19)), (String)"yyyy-MM-dd HH:mm:ss");
        p.setData(d);
        p.setHora(d);
        p.setNumeroProtocolo(protocoloAverbacao.getProtocolo());
        return p;
    }

    private void addAndSaveErroAverb(Cte cte, ManifestoCteEletronico mdfe, NotaFiscalPropria nfe, short tipoAverbacao, Object msg, String aux) {
        ErroAverbacaoCte e = null;
        e = cte != null ? this.serviceErroAverbacaoCte.getErroAverbacaoPorCte(cte, Short.valueOf(tipoAverbacao)) : (mdfe != null ? this.serviceErroAverbacaoCte.getErroAverbacaoPorMdfe(mdfe, Short.valueOf(tipoAverbacao)) : this.serviceErroAverbacaoCte.getErroAverbacaoPorNfe(nfe, Short.valueOf(tipoAverbacao)));
        if (e == null) {
            e = new ErroAverbacaoCte();
            e.setDataCadastro(new Date());
        }
        e.setCte(cte);
        e.setManifestoCteEletronico(mdfe);
        e.setNotaFiscalPropria(nfe);
        e.setTipoAverbacao(Short.valueOf(tipoAverbacao));
        if (msg != null) {
            if (msg instanceof Retorno) {
                Retorno retorno = (Retorno)msg;
                e.setNumDoc(retorno.getNumero());
                e.setSerieDoc(retorno.getSerie());
                e.setFilialDoc(retorno.getFilial());
                e.setLinhaArq((String)(retorno.getInfAdic() != null ? retorno.getInfAdic() + retorno.getCNPJCli() : retorno.getCNPJCli()));
                e.setErroDetalheAverbacao(this.getErroDetalhe(retorno.getErros().getErro()));
            } else {
                RetornoMDFe retornoMdfe = (RetornoMDFe)msg;
                e.setNumDoc(retornoMdfe.getNumero());
                e.setSerieDoc(retornoMdfe.getSerie());
                e.setFilialDoc(retornoMdfe.getFilial());
                e.setLinhaArq("MDFE");
                e.setErroDetalheAverbacao(this.getErroDetalhe(retornoMdfe.getErros().getErro()));
            }
            ErroDetalheAverbacao er = new ErroDetalheAverbacao();
            er.setDescCompleta(aux);
            e.getErroDetalheAverbacao().add(er);
        }
        this.serviceErroAverbacaoCte.saveOrUpdate((InterfaceVO)e);
        this.addErrorToResult(e);
    }

    private List<ErroDetalheAverbacao> getErroDetalhe(List<ErroProcesso> tErroDetalheAverbacao) {
        ArrayList<ErroDetalheAverbacao> erroDetalheAverbacao = new ArrayList<ErroDetalheAverbacao>();
        for (ErroProcesso o : tErroDetalheAverbacao) {
            ErroDetalheAverbacao e = new ErroDetalheAverbacao();
            e.setCodigo(o.getCodigo());
            e.setValorEnviado(o.getValorInformado());
            e.setValorEsperado(o.getValorEsperado());
            e.setLimite(null);
            e.setDescCompleta(o.getDescricao());
            erroDetalheAverbacao.add(e);
        }
        return erroDetalheAverbacao;
    }

    private void addErrorToResult(ErroAverbacaoCte e) {
        Object temp = "";
        for (ErroDetalheAverbacao det : e.getErroDetalheAverbacao()) {
            temp = (String)temp + det.getDescCompleta() + "<br/>";
        }
        this.result.addDet(EnumConstantsTaskResult.RESULT_ERRO, e.getCte() != null ? "Erro ao averbar CTe: " + String.valueOf(e.getCte()) + ", Detalhes: " + (String)temp : (e.getManifestoCteEletronico() != null ? "Erro ao averbar MDFe: " + String.valueOf(e.getManifestoCteEletronico()) + ", Detalhes: " + (String)temp : "Erro ao averbar NFe: " + String.valueOf(e.getNotaFiscalPropria()) + ", Detalhes: " + (String)temp));
    }

    private void addSuccesToResult(AverbacaoCte a) {
        this.result.addDet(EnumConstantsTaskResult.RESULT_OK, a.getCte() != null ? "CTe averbado: " + String.valueOf(a.getCte()) : (a.getManifestoCteEletronico() != null ? "MDFe averbado: " + String.valueOf(a.getManifestoCteEletronico()) : "NFe averbado: " + String.valueOf(a.getNotaFiscalPropria())));
    }
}

